package com.biz.crm.income.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.CrmCodeRuleConstants;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.common.GlobalParam;
import com.biz.crm.crmlog.handle.util.CrmLogSendUtil;
import com.biz.crm.exception.CommonException;
import com.biz.crm.income.mapper.TpmIncomeBudgetMapper;
import com.biz.crm.income.model.TpmIncomeBudgetEntity;
import com.biz.crm.income.service.ITpmIncomeBudgetService;
import com.biz.crm.mdm.customer.MdmCustomerMsgFeign;
import com.biz.crm.mdm.org.MdmOrgFeign;
import com.biz.crm.mdm.product.MdmProductFeign;
import com.biz.crm.mdm.productlevel.MdmProductLevelFeign;
import com.biz.crm.mdm.terminal.MdmTerminalFeign;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.humanarea.MdmCustomerOrgSearchReqVo;
import com.biz.crm.nebular.mdm.humanarea.MdmPositionSelectPageRespVo;
import com.biz.crm.nebular.mdm.org.req.MdmOrgReqVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.mdm.product.req.MdmProductQueryReqVo;
import com.biz.crm.nebular.mdm.product.req.MdmProductReqVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductQueryRespVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductRespVo;
import com.biz.crm.nebular.mdm.productlevel.req.MdmProductLevelReqVo;
import com.biz.crm.nebular.mdm.productlevel.req.MdmProductLevelSelectReqVo;
import com.biz.crm.nebular.mdm.productlevel.resp.MdmProductLevelRespVo;
import com.biz.crm.nebular.mdm.productlevel.resp.MdmProductLevelSelectRespVo;
import com.biz.crm.nebular.mdm.terminal.MdmCustomerTerminalVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.biz.crm.nebular.tpm.income.req.TpmIncomeBudgetReqVo;
import com.biz.crm.nebular.tpm.income.resp.TpmIncomeBudgetRespVo;
import com.biz.crm.util.*;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.commons.collections4.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

import lombok.extern.slf4j.Slf4j;
import org.springframework.transaction.annotation.Transactional;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import javax.annotation.Resource;

/**
 * 收入预算;接口实现
 *
 * @author lf
 * @date 2021-02-02 17:55:15
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="TpmIncomeBudgetServiceExpandImpl")
public class TpmIncomeBudgetServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<TpmIncomeBudgetMapper, TpmIncomeBudgetEntity> implements ITpmIncomeBudgetService {

    @Resource
    private TpmIncomeBudgetMapper tpmIncomeBudgetMapper;

    @Autowired
    private InComeServiceHelp inComeHelpService;

    @Autowired
    private MdmOrgFeign mdmOrgFeign;

    @Resource
    private MdmCustomerMsgFeign mdmCustomerMsgFeign;

    @Autowired
    private MdmTerminalFeign terminalFeign;

    @Autowired
    private MdmProductFeign mdmProductFeign;

    @Autowired
    private MdmProductLevelFeign mdmProductLevelFeign;
    @Autowired
    private CrmLogSendUtil crmLogSendUtil;
    /**
     * 列表
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<TpmIncomeBudgetRespVo> findList(TpmIncomeBudgetReqVo reqVo){
        Page<TpmIncomeBudgetRespVo> page = new Page<>(reqVo.getPageNum(), reqVo.getPageSize());
        List<TpmIncomeBudgetRespVo> list = tpmIncomeBudgetMapper.findList(page, reqVo);
        if (CollectionUtils.isNotEmpty(list)){
            list.forEach(o->{
                inComeHelpService.setRespVoData(o);
            });
        }
        return PageResult.<TpmIncomeBudgetRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     * @param id id
     * @return tpmIncomeBudgetRespVo
     */
    @Override
    public TpmIncomeBudgetRespVo query(String id){
        AssertUtils.isNotEmpty(id, CommonException.IDS_NULL);
        List<TpmIncomeBudgetEntity> entities = tpmIncomeBudgetMapper.selectList(Wrappers.<TpmIncomeBudgetEntity>lambdaQuery()
                .eq(TpmIncomeBudgetEntity::getId,id));
        if (entities.size()>1){
            throw new BusinessException("数据异常");
        }
        if (entities.size()<1){
            throw new BusinessException("不存在该数据");
        }
        TpmIncomeBudgetRespVo tpmIncomeBudgetRespVo = CrmBeanUtil.copy(entities.get(0),TpmIncomeBudgetRespVo.class);
        inComeHelpService.setRespVoData(tpmIncomeBudgetRespVo);
        return tpmIncomeBudgetRespVo;
    }

    /**
     * 新增
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(TpmIncomeBudgetReqVo reqVo){
        inComeHelpService.checkData(reqVo);
        TpmIncomeBudgetEntity entity = CrmBeanUtil.copy(reqVo,TpmIncomeBudgetEntity.class);
        this.save(entity);
        //日志
        TpmIncomeBudgetRespVo newData = CrmBeanUtil.copy(entity, TpmIncomeBudgetRespVo.class);
        Object menuCodeObj = ThreadLocalUtil.getObj(GlobalParam.MENU_CODE);
        crmLogSendUtil.sendForAdd(menuCodeObj.toString(),newData.getId(),newData.getIncomeCode(),newData);
    }

    /**
     * 更新
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(TpmIncomeBudgetReqVo reqVo){
        inComeHelpService.updateCheck(reqVo);
        inComeHelpService.checkData(reqVo);
        TpmIncomeBudgetEntity entity =CrmBeanUtil.copy(reqVo,TpmIncomeBudgetEntity.class);
        //日志老数据
        TpmIncomeBudgetRespVo oldData = this.query(reqVo.getId());
        this.updateById(entity);
        //日志
        Object menuCodeObj = ThreadLocalUtil.getObj(GlobalParam.MENU_CODE);
        TpmIncomeBudgetRespVo newData = CrmBeanUtil.copy(entity, TpmIncomeBudgetRespVo.class);
        crmLogSendUtil.sendForUpdate(menuCodeObj.toString(),newData.getId(),newData.getIncomeCode(),oldData,newData);
    }

    /**
     * 启用
     * @param ids
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(List<String>ids){
        AssertUtils.isNotEmpty(ids,CommonException.IDS_NULL);
        //设置状态为启用
        List<TpmIncomeBudgetEntity> tpmIncomeBudgetEntities = tpmIncomeBudgetMapper.selectBatchIds(ids);
        //日志老数据
        List<TpmIncomeBudgetRespVo> oldDataList = CrmBeanUtil.copyList(tpmIncomeBudgetEntities,TpmIncomeBudgetRespVo.class);
        if(CollectionUtils.isNotEmpty(tpmIncomeBudgetEntities)){
            tpmIncomeBudgetEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(tpmIncomeBudgetEntities);
        // 日志
        Object menuCodeObj = ThreadLocalUtil.getObj(GlobalParam.MENU_CODE);
        List<TpmIncomeBudgetRespVo> newDataList = CrmBeanUtil.copyList(tpmIncomeBudgetEntities,TpmIncomeBudgetRespVo.class);
        for (int i = 0;i < newDataList.size();i++){
            crmLogSendUtil.sendForUpdate(menuCodeObj.toString(),newDataList.get(i).getId(),newDataList.get(i).getIncomeCode(),oldDataList.get(i),newDataList.get(i));
        }
    }

    /**
     * 禁用
     * @param ids
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(List<String> ids){
        AssertUtils.isNotEmpty(ids,CommonException.IDS_NULL);
        //设置状态为禁用
        List<TpmIncomeBudgetEntity> tpmIncomeBudgetEntities = tpmIncomeBudgetMapper.selectBatchIds(ids);
        //日志老数据
        List<TpmIncomeBudgetRespVo> oldDataList = CrmBeanUtil.copyList(tpmIncomeBudgetEntities,TpmIncomeBudgetRespVo.class);
        if(CollectionUtils.isNotEmpty(tpmIncomeBudgetEntities)){
                tpmIncomeBudgetEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(tpmIncomeBudgetEntities);
        // 日志
        Object menuCodeObj = ThreadLocalUtil.getObj(GlobalParam.MENU_CODE);
        List<TpmIncomeBudgetRespVo> newDataList = CrmBeanUtil.copyList(tpmIncomeBudgetEntities,TpmIncomeBudgetRespVo.class);
        for (int i = 0;i < newDataList.size();i++){
            crmLogSendUtil.sendForUpdate(menuCodeObj.toString(),newDataList.get(i).getId(),newDataList.get(i).getIncomeCode(),oldDataList.get(i),newDataList.get(i));
        }
    }

    /**
     * 批量删除   真删除
     * @param ids ids
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void batchDelete(List<String> ids) {
        AssertUtils.isNotEmpty(ids, CommonException.IDS_NULL);
        List<TpmIncomeBudgetEntity> entities = tpmIncomeBudgetMapper.selectBatchIds(ids);
        List<String> removeIds = Lists.newArrayList();
        //日志老数据
        List<TpmIncomeBudgetRespVo> oldDataList = CrmBeanUtil.copyList(entities,TpmIncomeBudgetRespVo.class);
        if (CollectionUtils.isNotEmpty(entities)){
            entities.forEach(o->{
                removeIds.add(o.getId());
            });
            this.removeByIds(removeIds);
        }
        //日志
        Object menuCodeObj = ThreadLocalUtil.getObj(GlobalParam.MENU_CODE);
        for (TpmIncomeBudgetRespVo oldData: oldDataList) {
            crmLogSendUtil.sendForDel(menuCodeObj.toString(),oldData.getId(),oldData.getIncomeCode(),oldData);
        }
    }

    /**
     * 获取所有已经启用的组织
     * @param mdmOrgReqVo
     * @return
     */
   @Override
   public List<MdmOrgRespVo> findAllOrgCodes(MdmOrgReqVo mdmOrgReqVo){
        mdmOrgReqVo.setOrgCode(UserUtils.getUser().getOrgcode());
        Result<List<MdmOrgRespVo>> orgRespVos;
        try {
            orgRespVos =mdmOrgFeign.findAllChildrenOrgList(mdmOrgReqVo);
        } catch (Exception e) {
            log.error("{}",e);
            throw new BusinessException("收入预算新增获取所有组织,调用mdm接口失败");
        }
        return ApiResultUtil.objResult(orgRespVos, true);
    }

    /**
     * 根据组织 获取 客户
     * @param mdmOrgReqVo
     * @return
     */
    @Override
    public List<MdmCustomerMsgRespVo> findCustomerByOrgCode(MdmOrgReqVo mdmOrgReqVo) {
        MdmCustomerOrgSearchReqVo mdmCustomerOrgSearchReqVo = new MdmCustomerOrgSearchReqVo();
        AssertUtils.isNotEmpty(mdmOrgReqVo.getOrgCode(),"组织不能为空");
        mdmCustomerOrgSearchReqVo.setOrgCodeList(Lists.newArrayList(mdmOrgReqVo.getOrgCode()));
        Result<List<MdmCustomerMsgRespVo>> customerOrgRespVos;
        try {
            customerOrgRespVos = mdmCustomerMsgFeign.findCurrentAndSubCustomerList(mdmCustomerOrgSearchReqVo);
        } catch (Exception e) {
            log.error("{}",e);
            throw new BusinessException("收入预算新增获取对应客户,调用mdm接口失败");
        }
        return ApiResultUtil.objResult(customerOrgRespVos,true);
    }

    /**
     * 根据组织获取 门店
     * @param mdmOrgReqVo
     * @return
     */
    @Override
    public List<MdmTerminalVo> findTerminalByOrgCode(MdmOrgReqVo mdmOrgReqVo) {

        Result<List<MdmTerminalVo>> terminalRespVos;
        MdmCustomerTerminalVo mdmCustomerTerminalVo = new MdmCustomerTerminalVo();
        AssertUtils.isNotEmpty(mdmOrgReqVo.getOrgCode(),"组织不能为空");
        mdmCustomerTerminalVo.setOrgCodeList(Lists.newArrayList(mdmOrgReqVo.getOrgCode()));
        try {
            terminalRespVos = terminalFeign.customerTerminalList(mdmCustomerTerminalVo);
        } catch (Exception e) {
            log.error("{}",e);
            throw new BusinessException("收入预算新增获取对应门店,调用mdm接口失败");
        }
        return ApiResultUtil.objResult(terminalRespVos,true);
    }

    /**
     *  获取所有门店
     * @param mdmProductReqVo
     * @return
     */
    @Override
    public List<MdmProductRespVo> findAllProduct(MdmProductReqVo mdmProductReqVo) {
        Result<List<MdmProductRespVo>> productRespVos;
        try {
            mdmProductReqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            productRespVos = mdmProductFeign.listCondition(mdmProductReqVo);
        } catch (Exception e){
            log.error("{}",e);
            throw new BusinessException("收入预算获取商品，调用mdm接口失败");
        }
        return ApiResultUtil.objResult(productRespVos,true);
    }

    @Override
    public List<MdmProductQueryRespVo> findAllProductByLevelCode(MdmProductLevelSelectReqVo mdmProductLevelSelectReqVo) {
        Result<List<MdmProductQueryRespVo>> productRespVos;
        MdmProductQueryReqVo mdmProductQueryReqVo = new MdmProductQueryReqVo();
        AssertUtils.isNotEmpty(mdmProductLevelSelectReqVo.getProductLevelCode(),"产品层级不能为空");
        mdmProductQueryReqVo.setProductLevelCode(mdmProductLevelSelectReqVo.getProductLevelCode());
        try {
             productRespVos = mdmProductFeign.queryProductList(mdmProductQueryReqVo);
        } catch (Exception e) {
            log.error("{}",e);
            throw new BusinessException("收入预算通过层级及下级获取商品，调用mdm接口失败");
        }
        return ApiResultUtil.objResult(productRespVos,true);
    }

    @Override
    public List<MdmProductLevelSelectRespVo> findAllProductLevel(MdmProductLevelSelectReqVo mdmProductLevelSelectReqVo) {
        Result<List<MdmProductLevelSelectRespVo>> productLevelRespVos;
        try {
            productLevelRespVos = mdmProductLevelFeign.productLevelSelectList(mdmProductLevelSelectReqVo);
        }catch (Exception e) {
            log.error("{}", e);
            throw new BusinessException("收入预算获取层级及下级，调用mdm接口失败");
        }
        return ApiResultUtil.objResult(productLevelRespVos,true);
    }
}
