package com.biz.crm.invoicepool.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.invoicepool.service.ITpmInvoicePoolService;
import com.biz.crm.nebular.tpm.invoicepool.req.TpmInvoicePoolReqVo;
import com.biz.crm.nebular.tpm.invoicepool.resp.TpmInvoicePoolRespVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 
 *
 * @author gavin
 * @date 2021-12-16 16:29:22
 */
@Slf4j
@RestController
@RequestMapping("/tpminvoicepool")
@Api(tags = "发票池")
public class TpmInvoicePoolController {
    @Autowired
    private ITpmInvoicePoolService tpmInvoicePoolService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<TpmInvoicePoolRespVo>> list(@RequestBody TpmInvoicePoolReqVo tpmInvoicePoolReqVo) {
        PageResult<TpmInvoicePoolRespVo> result=tpmInvoicePoolService.findList(tpmInvoicePoolReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @GetMapping("/query")
    @CrmLog
    public Result<TpmInvoicePoolRespVo> query(@RequestParam(value = "id", required = false)String id, @RequestParam(value = "invoiceNumber", required = false)String invoiceNumber) {
        TpmInvoicePoolRespVo respVo=tpmInvoicePoolService.query(id, invoiceNumber);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody TpmInvoicePoolReqVo tpmInvoicePoolReqVo) {
        tpmInvoicePoolService.save(tpmInvoicePoolReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody TpmInvoicePoolReqVo tpmInvoicePoolReqVo) {
        tpmInvoicePoolService.update(tpmInvoicePoolReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        tpmInvoicePoolService.deleteBatch(ids);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody TpmInvoicePoolReqVo tpmInvoicePoolReqVo) {
        tpmInvoicePoolService.enableBatch(tpmInvoicePoolReqVo);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody  TpmInvoicePoolReqVo tpmInvoicePoolReqVo) {
        tpmInvoicePoolService.disableBatch(tpmInvoicePoolReqVo);
        return Result.ok("禁用成功");
    }
}
