package com.biz.crm.invoicepool.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.invoicepool.model.TpmInvoicePoolEntity;
import com.biz.crm.nebular.tpm.invoicepool.req.TpmInvoicePoolReqVo;
import com.biz.crm.nebular.tpm.invoicepool.resp.TpmInvoicePoolRespVo;

import java.util.List;


/**
 * 接口
 *
 * @author gavin
 * @date 2021-12-16 16:29:22
 */
public interface ITpmInvoicePoolService extends IService<TpmInvoicePoolEntity> {

    /**
     * 列表
     * @param tpmInvoicePoolReqVo
     * @return PageResult<TpmInvoicePoolRespVo>
     */
    PageResult<TpmInvoicePoolRespVo> findList(TpmInvoicePoolReqVo tpmInvoicePoolReqVo);

    /**
     * 查询
     * @param id
     * @return TpmInvoicePoolRespVo
     */
    TpmInvoicePoolRespVo query(String id, String invoiceNumber);

    /**
     * 新增
     * @param tpmInvoicePoolReqVo
     * @return
     */
    void save(TpmInvoicePoolReqVo tpmInvoicePoolReqVo);

    /**
     * 更新
     * @param tpmInvoicePoolReqVo
     * @return
     */
    void update(TpmInvoicePoolReqVo tpmInvoicePoolReqVo);

    /**
     * 删除
     * @param ids
     * @return
     */
    void deleteBatch(List<String> ids);

    /**
     * 启用
     * @param tpmInvoicePoolReqVo
     * @return
     */
    void enableBatch(TpmInvoicePoolReqVo tpmInvoicePoolReqVo);

    /**
     * 禁用
     * @param tpmInvoicePoolReqVo
     * @return
     */
    void disableBatch(TpmInvoicePoolReqVo tpmInvoicePoolReqVo);
}

