package com.biz.crm.liqueraudit.controller;

import com.alibaba.fastjson.JSON;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.liqueraudit.service.ITpmLiqueurAuditService;
import com.biz.crm.nebular.activiti.act.ActivitiCallBackVo;
import com.biz.crm.nebular.tpm.audit.req.TpmAuditReqVo;
import com.biz.crm.nebular.tpm.liqueuract.req.TpmLiqueurActRegisterDetailAttachReqVo;
import com.biz.crm.nebular.tpm.liqueuract.req.TpmLiqueurActRegisterDetailReqVo;
import com.biz.crm.nebular.tpm.liqueuract.req.TpmLiqueurActRegisterReqVo;
import com.biz.crm.nebular.tpm.liqueuract.req.TpmLiqueurActReqVo;
import com.biz.crm.nebular.tpm.liqueuract.resp.TpmLiqueurActRegisterDetailAttachRespVo;
import com.biz.crm.nebular.tpm.liqueuract.resp.TpmLiqueurActRegisterDetailRespVo;
import com.biz.crm.nebular.tpm.liqueuract.resp.TpmLiqueurActRegisterRespVo;
import com.biz.crm.nebular.tpm.liqueuract.resp.TpmLiqueurActRespVo;
import com.biz.crm.nebular.tpm.liqueuraudit.req.TpmLiqueurAuditReqVo;
import com.biz.crm.nebular.tpm.liqueuraudit.resp.TpmLiqueurAuditRespVo;
import com.biz.crm.util.Result;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 酒类TPM核销申请主表;
 *
 * @author jerry7
 * @date 2021-03-10 10:09:16
 */
@Slf4j
@RestController
@RequestMapping("/tpmliqueuraudit")
@Api(tags = "酒类TPM核销申请主表;")
public class TpmLiqueurAuditController {
    @Autowired
    private ITpmLiqueurAuditService tpmLiqueurAuditService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<TpmLiqueurAuditRespVo>> list(@RequestBody TpmLiqueurAuditReqVo tpmLiqueurAuditReqVo) {
        PageResult<TpmLiqueurAuditRespVo> result = tpmLiqueurAuditService.findList(tpmLiqueurAuditReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @GetMapping("/query")
    @CrmLog
    public Result<TpmLiqueurAuditRespVo> query(@RequestParam(value = "id", required = false) String id) {
        TpmLiqueurAuditRespVo respVo = tpmLiqueurAuditService.query(id);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody TpmLiqueurAuditReqVo tpmLiqueurAuditReqVo) {
        UserRedis user = UserUtils.getUser();
        tpmLiqueurAuditReqVo.setLockUserName(user.getUsername());
        tpmLiqueurAuditService.save(tpmLiqueurAuditReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody TpmLiqueurAuditReqVo tpmLiqueurAuditReqVo) {
        UserRedis user = UserUtils.getUser();
        tpmLiqueurAuditReqVo.setLockUserName(user.getUsername());
        tpmLiqueurAuditService.update(tpmLiqueurAuditReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        tpmLiqueurAuditService.deleteBatch(ids);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody TpmLiqueurAuditReqVo tpmLiqueurAuditReqVo) {
        tpmLiqueurAuditService.enableBatch(tpmLiqueurAuditReqVo);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody TpmLiqueurAuditReqVo tpmLiqueurAuditReqVo) {
        tpmLiqueurAuditService.disableBatch(tpmLiqueurAuditReqVo);
        return Result.ok("禁用成功");
    }

    /**
     * 获取可核销活动列表
     */
    @ApiOperation(value = "查询可核销活动列表")
    @PostMapping("/getActList")
    @CrmLog
    public Result<PageResult<TpmLiqueurActRespVo>> getActList(@RequestBody TpmLiqueurActReqVo tpmLiqueurActReqVo) {
        PageResult<TpmLiqueurActRespVo> result = tpmLiqueurAuditService.getActList(tpmLiqueurActReqVo);
        return Result.ok(result);
    }

    /**
     * 获取可核销活动明细列表
     */
    @ApiOperation(value = "查询可核销活动明细列表")
    @PostMapping("/getActDetailList")
    @CrmLog
    public Result<PageResult<TpmLiqueurActRegisterDetailRespVo>> getActDetailList(@RequestBody TpmLiqueurActRegisterDetailReqVo reqVo) {
        PageResult<TpmLiqueurActRegisterDetailRespVo> result = tpmLiqueurAuditService.getActDetailList(reqVo);
        return Result.ok(result);
    }

    @ApiModelProperty(value = "根据活动明细列表查询附加信息列表")
    @PostMapping("/getAttachList")
    @CrmLog
    public Result<PageResult<TpmLiqueurActRegisterDetailAttachRespVo>> getAttachList(@RequestBody TpmLiqueurActRegisterDetailAttachReqVo reqVo) {
        PageResult<TpmLiqueurActRegisterDetailAttachRespVo> result = tpmLiqueurAuditService.getAttachList(reqVo);
        return Result.ok(result);
    }

    @ApiOperation(value = "工作流回调接口")
    @PostMapping("/liqueurAuditCallBack")
    @CrmLog
    public Result callback(@RequestBody ActivitiCallBackVo activitiCallBackVo) {
        log.info("酒类核销收到工作流回调请求,请求参数={}", JSON.toJSONString(activitiCallBackVo));
        tpmLiqueurAuditService.auditCallBack(activitiCallBackVo);
        return Result.ok("核销审批回调成功");
    }


    /**
     * 提交审批
     */
    @ApiOperation(value = "提交审批")
    @PostMapping("/approve")
    @CrmLog
    public Result approve(@RequestBody TpmLiqueurAuditReqVo reqVo) {
        UserRedis user = UserUtils.getUser();
        reqVo.setLockUserName(user.getUsername());
        tpmLiqueurAuditService.approve(reqVo);
        return Result.ok("提交审批成功");
    }

}
