package com.biz.crm.liqueraudit.controller;

import com.biz.crm.liqueraudit.service.ITpmLiqueurAuditDetailsService;
import com.biz.crm.nebular.tpm.liqueuraudit.req.TpmLiqueurAuditDetailsReqVo;
import com.biz.crm.nebular.tpm.liqueuraudit.resp.TpmLiqueurAuditDetailsRespVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import javax.validation.Valid;
import java.util.Objects;
import com.biz.crm.aop.CrmLog;

/**
 * 酒类tpm核销明细表
 *
 * @author jerry7
 * @date 2021-03-10 10:09:16
 */
@Slf4j
@RestController
@RequestMapping("/tpmliqueurauditdetails")
@Api(tags = "酒类tpm核销明细表")
public class TpmLiqueurAuditDetailsController {
    @Autowired
    private ITpmLiqueurAuditDetailsService tpmLiqueurAuditDetailsService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<TpmLiqueurAuditDetailsRespVo>> list(@RequestBody TpmLiqueurAuditDetailsReqVo tpmLiqueurAuditDetailsReqVo) {
        PageResult<TpmLiqueurAuditDetailsRespVo> result=tpmLiqueurAuditDetailsService.findList(tpmLiqueurAuditDetailsReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    public Result<TpmLiqueurAuditDetailsRespVo> query(@RequestBody TpmLiqueurAuditDetailsReqVo tpmLiqueurAuditDetailsReqVo) {
        TpmLiqueurAuditDetailsRespVo respVo=tpmLiqueurAuditDetailsService.query(tpmLiqueurAuditDetailsReqVo);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody TpmLiqueurAuditDetailsReqVo tpmLiqueurAuditDetailsReqVo) {
        tpmLiqueurAuditDetailsService.save(tpmLiqueurAuditDetailsReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody TpmLiqueurAuditDetailsReqVo tpmLiqueurAuditDetailsReqVo) {
        tpmLiqueurAuditDetailsService.update(tpmLiqueurAuditDetailsReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody TpmLiqueurAuditDetailsReqVo tpmLiqueurAuditDetailsReqVo) {
        tpmLiqueurAuditDetailsService.deleteBatch(tpmLiqueurAuditDetailsReqVo);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody TpmLiqueurAuditDetailsReqVo tpmLiqueurAuditDetailsReqVo) {
        tpmLiqueurAuditDetailsService.enableBatch(tpmLiqueurAuditDetailsReqVo);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody  TpmLiqueurAuditDetailsReqVo tpmLiqueurAuditDetailsReqVo) {
        tpmLiqueurAuditDetailsService.disableBatch(tpmLiqueurAuditDetailsReqVo);
        return Result.ok("禁用成功");
    }
}
