package com.biz.crm.liqueraudit.controller;

import com.biz.crm.liqueraudit.service.ITpmLiqueurAuditFileService;
import com.biz.crm.nebular.tpm.liqueuraudit.req.TpmLiqueurAuditFileReqVo;
import com.biz.crm.nebular.tpm.liqueuraudit.resp.TpmLiqueurAuditFileRespVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;

import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import javax.validation.Valid;
import java.util.Objects;
import com.biz.crm.aop.CrmLog;

/**
 * J酒类TPM核销申请资料表;
 *
 * @author jerry7
 * @date 2021-03-10 10:09:16
 */
@Slf4j
@RestController
@RequestMapping("/tpmliqueurauditfile")
@Api(tags = "J酒类TPM核销申请资料表;")
public class TpmLiqueurAuditFileController {
    @Autowired
    private ITpmLiqueurAuditFileService tpmLiqueurAuditFileService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<TpmLiqueurAuditFileRespVo>> list(@RequestBody TpmLiqueurAuditFileReqVo tpmLiqueurAuditFileReqVo) {
        PageResult<TpmLiqueurAuditFileRespVo> result=tpmLiqueurAuditFileService.findList(tpmLiqueurAuditFileReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    public Result<TpmLiqueurAuditFileRespVo> query(@RequestBody TpmLiqueurAuditFileReqVo tpmLiqueurAuditFileReqVo) {
        TpmLiqueurAuditFileRespVo respVo=tpmLiqueurAuditFileService.query(tpmLiqueurAuditFileReqVo);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody TpmLiqueurAuditFileReqVo tpmLiqueurAuditFileReqVo) {
        tpmLiqueurAuditFileService.save(tpmLiqueurAuditFileReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody TpmLiqueurAuditFileReqVo tpmLiqueurAuditFileReqVo) {
        tpmLiqueurAuditFileService.update(tpmLiqueurAuditFileReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody TpmLiqueurAuditFileReqVo tpmLiqueurAuditFileReqVo) {
        tpmLiqueurAuditFileService.deleteBatch(tpmLiqueurAuditFileReqVo);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody TpmLiqueurAuditFileReqVo tpmLiqueurAuditFileReqVo) {
        tpmLiqueurAuditFileService.enableBatch(tpmLiqueurAuditFileReqVo);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody  TpmLiqueurAuditFileReqVo tpmLiqueurAuditFileReqVo) {
        tpmLiqueurAuditFileService.disableBatch(tpmLiqueurAuditFileReqVo);
        return Result.ok("禁用成功");
    }
}
