package com.biz.crm.liqueraudit.mapper;


import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.liqueraudit.model.TpmLiqueurAuditAttachEntity;
import com.biz.crm.nebular.tpm.liqueuraudit.req.TpmLiqueurAuditAttachReqVo;
import com.biz.crm.nebular.tpm.liqueuraudit.resp.TpmLiqueurAuditAttachRespVo;
import org.apache.ibatis.annotations.Param;
import java.util.List;
import java.util.Map;

/**
 * 酒类TPM核销附加信息表;
 *
 * @author Huahongqiang
 * @date 2021-03-23 11:48:30
 */
public interface TpmLiqueurAuditAttachMapper extends BaseMapper<TpmLiqueurAuditAttachEntity> {
    /**
     * 列表
     * @param page
     * @param tpmLiqueurAuditAttachReqVo
     * @return
     */
    List<TpmLiqueurAuditAttachRespVo> findList(Page<TpmLiqueurAuditAttachRespVo> page, @Param("vo") TpmLiqueurAuditAttachReqVo tpmLiqueurAuditAttachReqVo);
    /**
     * 上账核销附加信息列表
     * @param page
     * @param tpmLiqueurAuditAttachReqVo
     * @return
     */
    List<TpmLiqueurAuditAttachRespVo> findAccountList(Page<TpmLiqueurAuditAttachRespVo> page, @Param("vo") TpmLiqueurAuditAttachReqVo tpmLiqueurAuditAttachReqVo);

}
