package com.biz.crm.liqueraudit.service;


import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.liqueraudit.model.TpmLiqueurAuditAttachEntity;
import com.biz.crm.nebular.tpm.liqueuraudit.req.TpmLiqueurAuditAttachReqVo;
import com.biz.crm.nebular.tpm.liqueuraudit.resp.TpmLiqueurAuditAttachRespVo;

/**
 * 酒类TPM核销附加信息表;接口
 *
 * @author Huahongqiang
 * @date 2021-03-23 11:48:30
 */
public interface ITpmLiqueurAuditAttachService extends IService<TpmLiqueurAuditAttachEntity> {

    /**
     * 列表
     * @param tpmLiqueurAuditAttachReqVo
     * @return PageResult<TpmLiqueurAuditAttachRespVo>
     */
    PageResult<TpmLiqueurAuditAttachRespVo> findList(TpmLiqueurAuditAttachReqVo tpmLiqueurAuditAttachReqVo);

    /**
     * 列表
     * @param tpmLiqueurAuditAttachReqVo
     * @return PageResult<TpmLiqueurAuditAttachRespVo>
     */
    PageResult<TpmLiqueurAuditAttachRespVo> findAccountList(TpmLiqueurAuditAttachReqVo tpmLiqueurAuditAttachReqVo);

    /**
     * 查询
     * @param tpmLiqueurAuditAttachReqVo
     * @return TpmLiqueurAuditAttachRespVo
     */
    TpmLiqueurAuditAttachRespVo query(TpmLiqueurAuditAttachReqVo tpmLiqueurAuditAttachReqVo);

    /**
     * 新增
     * @param tpmLiqueurAuditAttachReqVo
     * @return
     */
    void save(TpmLiqueurAuditAttachReqVo tpmLiqueurAuditAttachReqVo);

    /**
     * 更新
     * @param tpmLiqueurAuditAttachReqVo
     * @return
     */
    void update(TpmLiqueurAuditAttachReqVo tpmLiqueurAuditAttachReqVo);

    /**
     * 删除
     * @param tpmLiqueurAuditAttachReqVo
     * @return
     */
    void deleteBatch(TpmLiqueurAuditAttachReqVo tpmLiqueurAuditAttachReqVo);

    /**
     * 启用
     * @param tpmLiqueurAuditAttachReqVo
     * @return
     */
    void enableBatch(TpmLiqueurAuditAttachReqVo tpmLiqueurAuditAttachReqVo);

    /**
     * 禁用
     * @param tpmLiqueurAuditAttachReqVo
     * @return
     */
    void disableBatch(TpmLiqueurAuditAttachReqVo tpmLiqueurAuditAttachReqVo);
}

