package com.biz.crm.liqueraudit.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.liqueraudit.model.TpmLiqueurAuditFileEntity;
import com.biz.crm.nebular.tpm.liqueuraudit.req.TpmLiqueurAuditFileReqVo;
import com.biz.crm.nebular.tpm.liqueuraudit.resp.TpmLiqueurAuditFileRespVo;

import java.util.Map;

/**
 * J酒类TPM核销申请资料表;接口
 *
 * @author jerry7
 * @date 2021-03-10 10:09:16
 */
public interface ITpmLiqueurAuditFileService extends IService<TpmLiqueurAuditFileEntity> {

    /**
     * 列表
     * @param tpmLiqueurAuditFileReqVo
     * @return PageResult<TpmLiqueurAuditFileRespVo>
     */
    PageResult<TpmLiqueurAuditFileRespVo> findList(TpmLiqueurAuditFileReqVo tpmLiqueurAuditFileReqVo);

    /**
     * 查询
     * @param tpmLiqueurAuditFileReqVo
     * @return TpmLiqueurAuditFileRespVo
     */
    TpmLiqueurAuditFileRespVo query(TpmLiqueurAuditFileReqVo tpmLiqueurAuditFileReqVo);

    /**
     * 新增
     * @param tpmLiqueurAuditFileReqVo
     * @return
     */
    void save(TpmLiqueurAuditFileReqVo tpmLiqueurAuditFileReqVo);

    /**
     * 更新
     * @param tpmLiqueurAuditFileReqVo
     * @return
     */
    void update(TpmLiqueurAuditFileReqVo tpmLiqueurAuditFileReqVo);

    /**
     * 删除
     * @param tpmLiqueurAuditFileReqVo
     * @return
     */
    void deleteBatch(TpmLiqueurAuditFileReqVo tpmLiqueurAuditFileReqVo);

    /**
     * 启用
     * @param tpmLiqueurAuditFileReqVo
     * @return
     */
    void enableBatch(TpmLiqueurAuditFileReqVo tpmLiqueurAuditFileReqVo);

    /**
     * 禁用
     * @param tpmLiqueurAuditFileReqVo
     * @return
     */
    void disableBatch(TpmLiqueurAuditFileReqVo tpmLiqueurAuditFileReqVo);
}

