package com.biz.crm.liqueraudit.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.liqueraudit.model.TpmLiqueurAuditEntity;
import com.biz.crm.liqueuract.service.TpmLiqueurActService;
import com.biz.crm.nebular.activiti.act.ActivitiCallBackVo;
import com.biz.crm.nebular.tpm.liqueuract.req.TpmLiqueurActRegisterDetailAttachReqVo;
import com.biz.crm.nebular.tpm.liqueuract.req.TpmLiqueurActRegisterDetailReqVo;
import com.biz.crm.nebular.tpm.liqueuract.req.TpmLiqueurActRegisterReqVo;
import com.biz.crm.nebular.tpm.liqueuract.req.TpmLiqueurActReqVo;
import com.biz.crm.nebular.tpm.liqueuract.resp.TpmLiqueurActRegisterDetailAttachRespVo;
import com.biz.crm.nebular.tpm.liqueuract.resp.TpmLiqueurActRegisterDetailRespVo;
import com.biz.crm.nebular.tpm.liqueuract.resp.TpmLiqueurActRegisterRespVo;
import com.biz.crm.nebular.tpm.liqueuract.resp.TpmLiqueurActRespVo;
import com.biz.crm.nebular.tpm.liqueuraudit.req.TpmLiqueurAuditReqVo;
import com.biz.crm.nebular.tpm.liqueuraudit.resp.TpmLiqueurAuditRespVo;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;
import java.util.Map;

/**
 * 酒类TPM核销申请主表;接口
 *
 * @author jerry7
 * @date 2021-03-10 10:09:16
 */
public interface ITpmLiqueurAuditService extends IService<TpmLiqueurAuditEntity> {

    /**
     * 列表
     * @param tpmLiqueurAuditReqVo
     * @return PageResult<TpmLiqueurAuditRespVo>
     */
    PageResult<TpmLiqueurAuditRespVo> findList(TpmLiqueurAuditReqVo tpmLiqueurAuditReqVo);

    /**
     * 查询
     * @param id
     * @return TpmLiqueurAuditRespVo
     */
    TpmLiqueurAuditRespVo query(String id);

    /**
     * 组装查询方法的其他数据
     * @param respVo
     * @return
     */
    TpmLiqueurAuditRespVo buildAuditOtherData(TpmLiqueurAuditRespVo respVo);

    /**
     * 新增
     * @param tpmLiqueurAuditReqVo
     * @return
     */
    void save(TpmLiqueurAuditReqVo tpmLiqueurAuditReqVo);

    /**
     * 更新
     * @param tpmLiqueurAuditReqVo
     * @return
     */
    void update(TpmLiqueurAuditReqVo tpmLiqueurAuditReqVo);

    /**
     * 删除
     * @param ids
     * @return
     */
    void deleteBatch(@RequestBody List<String> ids);

    /**
     * 启用
     * @param tpmLiqueurAuditReqVo
     * @return
     */
    void enableBatch(TpmLiqueurAuditReqVo tpmLiqueurAuditReqVo);

    /**
     * 禁用
     * @param tpmLiqueurAuditReqVo
     * @return
     */
    void disableBatch(TpmLiqueurAuditReqVo tpmLiqueurAuditReqVo);

    /**
     * 可核销活动列表
     * @return PageResult<TpmLiqueurActRespVo>
     */
    PageResult<TpmLiqueurActRespVo> getActList(TpmLiqueurActReqVo tpmLiqueurActReqVo);

    /**
     * 可核销活动明细列表
     * @return PageResult<TpmLiqueurActRespVo>
     */
    PageResult<TpmLiqueurActRegisterDetailRespVo> getActDetailList(TpmLiqueurActRegisterDetailReqVo reqVo);

    /**
     * 根据核销明细列表查询附加信息列表
     * @return PageResult<TpmLiqueurActRegisterDetailAttachRespVo>
     */
    PageResult<TpmLiqueurActRegisterDetailAttachRespVo> getAttachList(TpmLiqueurActRegisterDetailAttachReqVo reqVo);

    /**
     * 酒类核销回调接口
     * @param activitiCallBackVo 核销回调请求
     */
    void auditCallBack(ActivitiCallBackVo activitiCallBackVo);

    /**
     * 提交审批
     * @param reqVo
     */
    void approve(TpmLiqueurAuditReqVo reqVo);

    void saveMaterials();

}

