package com.biz.crm.liqueraudit.service;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.audit.mapper.TpmAuditMapper;
import com.biz.crm.audit.model.TpmAuditEntity;
import com.biz.crm.base.BaseServiceHelper;
import com.biz.crm.base.BusinessException;
import com.biz.crm.costtypefine.mapper.TpmCostTypeFineMapper;
import com.biz.crm.costtypefine.model.TpmCostTypeFineEntity;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.GlobalWhetherEnum;
import com.biz.crm.eunm.tpm.ActAdvancePayApproveStatusEnum;
import com.biz.crm.eunm.tpm.ActApproveStatusEnum;
import com.biz.crm.eunm.tpm.ActSaveTypeEnum;
import com.biz.crm.eunm.tpm.FeeBudgetDetailTypeEnum;
import com.biz.crm.exception.tpm.AuditException;
import com.biz.crm.exception.tpm.BudgetSubjectsException;
import com.biz.crm.feebudget.model.TpmFeeBudgetControlEntity;
import com.biz.crm.feebudget.model.TpmFeeBudgetDetailsEntity;
import com.biz.crm.feebudget.model.TpmFeeBudgetEntity;
import com.biz.crm.feebudget.service.ITpmFeeBudgetControlService;
import com.biz.crm.feebudget.service.ITpmFeeBudgetDetailsService;
import com.biz.crm.feebudget.service.ITpmFeeBudgetService;
import com.biz.crm.liqueraudit.mapper.TpmLiqueurAuditMapper;
import com.biz.crm.liqueraudit.model.LiqueurAuditVo;
import com.biz.crm.liqueraudit.model.TpmLiqueurAuditDetailsEntity;
import com.biz.crm.liqueraudit.model.TpmLiqueurAuditEntity;
import com.biz.crm.liqueuract.mapper.TpmLiqueurActBudgetMapper;
import com.biz.crm.liqueuract.mapper.TpmLiqueurActBudgetTransactionMapper;
import com.biz.crm.liqueuract.mapper.TpmLiqueurActMapper;
import com.biz.crm.liqueuract.mapper.TpmLiqueurActRegisterDetailMapper;
import com.biz.crm.liqueuract.model.TpmLiqueurActBudgetEntity;
import com.biz.crm.liqueuract.model.TpmLiqueurActBudgetTransactionEntity;
import com.biz.crm.liqueuract.model.TpmLiqueurActEntity;
import com.biz.crm.liqueuract.model.TpmLiqueurActRegisterDetailEntity;
import com.biz.crm.liqueuract.service.ITpmLiqueurActRegisterDetailService;
import com.biz.crm.nebular.activiti.act.req.StartProcessReqVo;
import com.biz.crm.nebular.activiti.act.req.TaActFileReqVo;
import com.biz.crm.nebular.tpm.audit.req.TpmAuditReqVo;
import com.biz.crm.nebular.tpm.liqueuraudit.req.TpmLiqueurAuditAttachReqVo;
import com.biz.crm.nebular.tpm.liqueuraudit.req.TpmLiqueurAuditDetailsReqVo;
import com.biz.crm.nebular.tpm.liqueuraudit.req.TpmLiqueurAuditReqVo;
import com.biz.crm.nebular.tpm.liqueuraudit.resp.TpmLiqueurAuditRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;


/**
 * 酒类TPM核销helper
 *
 * @author jerry7
 * @date 2021-03-10 10:09:16
 */
@Slf4j
@Service
public class LiquerAuditServiceHelper extends BaseServiceHelper {

    @Resource
    private TpmAuditMapper auditMapper;

    @Resource
    private TpmLiqueurActMapper tpmLiqueurActMapper;

    @Resource
    private TpmLiqueurActRegisterDetailMapper tpmLiqueurActRegisterDetailMapper;

    @Resource
    private TpmCostTypeFineMapper tpmCostTypeFineMapper;

    @Resource
    private TpmLiqueurActBudgetTransactionMapper liqueurActBudgetTransactionMapper;

    @Resource
    private TpmLiqueurActBudgetMapper liqueurActBudgetMapper;

    @Resource
    private ITpmFeeBudgetDetailsService tpmFeeBudgetDetailsService;

    @Resource
    private ITpmFeeBudgetService tpmFeeBudgetService;

    @Resource
    private ITpmFeeBudgetControlService tpmFeeBudgetControlService;

    @Resource
    private ITpmLiqueurActRegisterDetailService actRegisterDetailService;

    @Resource
    private TpmLiqueurAuditMapper tpmLiqueurAuditMapper;

    @Resource
    private ITpmLiqueurAuditService tpmLiqueurAuditService;

    @Resource
    private ITpmLiqueurAuditDetailsService tpmLiqueurAuditDetailsService;

    @Resource
    private TpmLiqueurActMapper liqueurActMapper;

    /**
     * 转换列表数据
     *
     * @param list
     */
    public void convertListDate(List<TpmLiqueurAuditRespVo> list) {
        if (CollectionUtils.isNotEmpty(list)) {
            list.forEach(o -> {
                //审批状态
                if (StringUtils.isNotEmpty(o.getApproveStatus())) {
                    o.setApproveStatusName(ActAdvancePayApproveStatusEnum.getStatusName(o.getApproveStatus()));
                }
            });
        }
    }

    /**
     * 删除检查
     *
     * @param ids
     */
    public void deleteCheck(List<TpmLiqueurAuditEntity> tpmAuditEntities, List<String> ids) {
        tpmAuditEntities.forEach(tpmAuditEntity -> {
            AssertUtils.isTrue(ActApproveStatusEnum.CREATE.getCode().equals(tpmAuditEntity.getApproveStatus()), "已提交数据不能删除");
        });
    }

    /**
     * 新增,编辑,校验
     *
     * @param reqVo 发起核销请求
     */
    public void saveCheck(TpmLiqueurAuditReqVo reqVo) {
        //校验主表数据
        if (StringUtils.isNotEmpty(reqVo.getId())) {
            TpmLiqueurAuditEntity tpmLiqueurAuditEntity = tpmLiqueurAuditMapper.selectById(reqVo.getId());
            AssertUtils.isNotNull(tpmLiqueurAuditEntity, AuditException.DATA_NOT_EXIST);
            if (!ActApproveStatusEnum.getCanUpdateStatus().contains(tpmLiqueurAuditEntity.getApproveStatus())) {
                throw new BusinessException("当前数据状态不允许修改操作");
            }
            reqVo.setAuditCode(tpmLiqueurAuditEntity.getAuditCode());
        }
        AssertUtils.isNotEmpty(reqVo.getAuditName(), "核销申请名称不能为空");
        AssertUtils.isNotNull(reqVo.getTotalAmount(), "核销总金额不能为空");
        if (ActSaveTypeEnum.getSendApproveTypes().contains(reqVo.getSaveType())) {
            reqVo.setApproveStatus(ActApproveStatusEnum.APPROVING.getCode());
        } else {
            //审批驳回的数据编辑时,如果不提交审批,状态保持不变
            if (StringUtils.isEmpty(reqVo.getApproveStatus())) {
                reqVo.setApproveStatus(ActApproveStatusEnum.CREATE.getCode());
            }
        }
        //校验活动信息
        this.saveActCheckDetails(reqVo);
        //校验明细信息
        this.saveCheckDetails(reqVo);
        //校验编码的重复
        this.checkDataExist(reqVo);
        //校验活动附加信息
        this.saveActCheckAttach(reqVo);

    }


    /**
     * 校验活动附件信息
     *
     * @param reqVo
     */
    private void saveActCheckAttach(TpmLiqueurAuditReqVo reqVo) {
        if (CollectionUtil.listNotEmptyNotSizeZero(reqVo.getAttachVos())) {
            return;
        }
        //转换活动编码-核销明细map
        Map<String, TpmLiqueurAuditDetailsReqVo> detailsReqVoMap = Maps.newHashMap();
        reqVo.getDetailsVos().forEach(detail -> {
            detailsReqVoMap.put(detail.getActDetailCode(), detail);
        });
        //转换为活动编码，附件信息列表 的map
        Map<String, List<TpmLiqueurAuditAttachReqVo>> attachMap = Maps.newHashMap();
        reqVo.getAttachVos().forEach(attach -> {
            AssertUtils.isNotNull(detailsReqVoMap.containsKey(attach.getActDetailCode()), "活动附加信息编码：" + attach.getActRegisterCode() + "所在的活动明细未选中");
            if (ObjectUtils.isNull(attach.getAuditAmount())) {
                attach.setAuditAmount(BigDecimal.ZERO);
            }
            List<TpmLiqueurAuditAttachReqVo> list = Lists.newArrayList();
            list.add(attach);
            if (attachMap.containsKey(attach.getActDetailCode())) {
                list.addAll(attachMap.get(attach.getActDetailCode()));
            }
            attachMap.put(attach.getActDetailCode(), list);
        });
        //校验同一核销明细的上账金额，是否与活动附加信息一致
        reqVo.getDetailsVos().forEach(detail -> {
            List<TpmLiqueurAuditAttachReqVo> attach = attachMap.get(detail.getActDetailCode());
            //AssertUtils.isNotNull(attach,"活动明细："+detail.getActCode()+"未选中活动附加信息");
            if (CollectionUtil.listNotEmptyNotSizeZero(attach)) {
                BigDecimal attachAmount = BigDecimal.ZERO;
                for (TpmLiqueurAuditAttachReqVo a : attach) {
                    attachAmount = attachAmount.add(a.getAuditAmount());
                }
                AssertUtils.isTrue(detail.getBillAuditAmount().compareTo(attachAmount) == 0, "活动明细：" + detail.getActDetailCode() + "上账金额与附加信息金额不一致");
            }
        });

    }

    private void saveActCheckDetails(TpmLiqueurAuditReqVo reqVo) {
        //校验活动信息
        AssertUtils.isNotEmpty(reqVo.getActCode(), "核销申请活动编码不能为空");
        List<TpmLiqueurActEntity> tpmActEntities = tpmLiqueurActMapper.selectList(Wrappers.<TpmLiqueurActEntity>lambdaQuery().eq(TpmLiqueurActEntity::getActCode, reqVo.getActCode()));
        AssertUtils.isTrue(CollectionUtils.size(tpmActEntities) == 1, "活动数据异常");
        TpmLiqueurActEntity entity = tpmActEntities.get(0);
        AssertUtils.isNotNull(entity, "活动编码:" + reqVo.getActCode() + "数据不存在");
        AssertUtils.isTrue(StringUtils.equals(ActApproveStatusEnum.APPROVED.getCode(), entity.getApproveStatus()), "审批未通过的活动:" + entity.getActCode() + "不能核销");
        AssertUtils.isTrue(StringUtils.equals(GlobalWhetherEnum.NO.getCode(), entity.getIsAllAudit()), "完成核销的活动不能再次核销");
        reqVo.setFineCode(entity.getFineCode());
        reqVo.setFineName(entity.getFineName());
    }

    private void saveCheckDetails(TpmLiqueurAuditReqVo reqVo) {
        //校验明细表数据
        List<TpmLiqueurAuditDetailsReqVo> detailVos = reqVo.getDetailsVos();
        AssertUtils.isNotEmpty(detailVos, "核销申请活动明细信息不能为空");
        Set<String> actDetailCodes = Sets.newHashSet();
        detailVos.forEach(o -> {
            AssertUtils.isNotEmpty(o.getActDetailCode(), "活动明细编码不能为空");
            AssertUtils.isTrue(reqVo.getActCode().equals(o.getActCode()), "活动明细编码:" + o.getActDetailCode() + "不在选定的核销活动范围内");
            o.setBillAuditAmount(o.getBillAuditAmount());
            o.setMaterialsAmount(o.getMaterialsAmount());
            o.setAmount(o.getAmount());
            actDetailCodes.add(o.getActDetailCode());
        });
        //正在核销活动明细编码-核销明细map
        Map<String, TpmLiqueurAuditDetailsEntity> auditDetailEntityMap = Maps.newHashMap();
        //获取活动的正在核销的数据
        List<TpmLiqueurAuditEntity> auditEntities = tpmLiqueurAuditService.getBaseMapper().selectList(new LambdaQueryWrapper<TpmLiqueurAuditEntity>()
                .eq(TpmLiqueurAuditEntity::getActCode, reqVo.getActCode())
                .eq(TpmLiqueurAuditEntity::getApproveStatus, ActApproveStatusEnum.APPROVING.getCode()));
        if (CollectionUtil.listNotEmptyNotSizeZero(auditEntities)) {
            //获取正在核销的核销明细
            List<TpmLiqueurAuditDetailsEntity> detailEntities = tpmLiqueurAuditDetailsService.getBaseMapper().selectList(new LambdaQueryWrapper<TpmLiqueurAuditDetailsEntity>()
                    .in(TpmLiqueurAuditDetailsEntity::getAuditCode, auditEntities.stream().map(TpmLiqueurAuditEntity::getAuditCode).collect(Collectors.toSet())));
            auditDetailEntityMap = detailEntities.stream().collect(Collectors.toMap(TpmLiqueurAuditDetailsEntity::getActDetailCode, Function.identity()));
        }
        AssertUtils.isTrue(detailVos.size() == CollectionUtils.size(actDetailCodes), "请不要选择重复的活动明细");
        //校验活动关联的活动细类
        List<TpmCostTypeFineEntity> fineEntities = tpmCostTypeFineMapper.selectList(Wrappers.<TpmCostTypeFineEntity>lambdaQuery()
                .eq(TpmCostTypeFineEntity::getFineCode, reqVo.getFineCode()));
        AssertUtils.isNotEmpty(fineEntities, "活动细类数据异常");
        TpmCostTypeFineEntity typeFineEntity = fineEntities.get(0);
        AssertUtils.isNotNull(typeFineEntity, "活动细类不存在");
        //校验活动明细
        List<TpmLiqueurActRegisterDetailEntity> tpmLiqueurActRegisterDetailEntities = tpmLiqueurActRegisterDetailMapper.selectList(Wrappers.<TpmLiqueurActRegisterDetailEntity>lambdaQuery().in(TpmLiqueurActRegisterDetailEntity::getActDetailCode, actDetailCodes));
        AssertUtils.isNotEmpty(tpmLiqueurActRegisterDetailEntities, "您选择的活动明细数据发生变更,请重新选择数据");
        Map<String, TpmLiqueurActRegisterDetailEntity> actDetailMap = tpmLiqueurActRegisterDetailEntities.stream().collect(Collectors.toMap(TpmLiqueurActRegisterDetailEntity::getActDetailCode, Function.identity()));
        //总物料核销金额
        BigDecimal allMaterialsAmount = BigDecimal.ZERO;
        //总核销金额
        BigDecimal allAuditAmount = BigDecimal.ZERO;
        for (int i = 0; i < detailVos.size(); i++) {
            TpmLiqueurAuditDetailsReqVo detailReqVo = detailVos.get(i);
            //校验此活动明细是否有正在审批中的核销明细
            AssertUtils.isTrue(!auditDetailEntityMap.containsKey(detailReqVo.getActDetailCode()),"活动明细编码:" + detailReqVo.getActDetailCode()+"已经有正在审批中的核销");
            AssertUtils.isNotNull(detailReqVo.getAmount(), "本次核销金额不能为空");
            detailReqVo.setAmount(detailReqVo.getBillAuditAmount().add(detailReqVo.getMaterialsAmount()));
            allMaterialsAmount = allMaterialsAmount.add(detailReqVo.getMaterialsAmount());
            allAuditAmount = allAuditAmount.add(detailReqVo.getAmount());
            //从查询到的活动明细表中获取请求的明细
            TpmLiqueurActRegisterDetailEntity tpmLiqueurActRegisterDetailEntity = actDetailMap.get(detailReqVo.getActDetailCode());
            AssertUtils.isNotNull(tpmLiqueurActRegisterDetailEntity, "活动明细编码:" + detailReqVo.getActDetailCode() + "不存在,或者不能进行核销操作");
            //校验每行的本次核销金额是否超额核销比控制，（本次核销金额+累计已核销金额）/申请金额不能超过活动细类的（1+超额核销比），
            // 如超出则不允许提交，并提示第**行超过允许最大核销金额**，其中最大核销金额为申请金额*（1+超额核销比/100）-已核销金额
            //从活动细类获取超额核销比例
            BigDecimal extraAuditRatio = typeFineEntity.getExtraAuditRatio();
            //获取申请金额
            BigDecimal addAmount = detailReqVo.getAmount().add(detailReqVo.getAuditAmount());
            //获取最大核销金额
            BigDecimal maxAuditAmount = (Optional.ofNullable(extraAuditRatio).orElse(BigDecimal.ZERO).multiply(detailReqVo.getApplyAmount()).divide(BigDecimal.valueOf(100))).add(detailReqVo.getApplyAmount());
            AssertUtils.isTrue(addAmount.compareTo(maxAuditAmount) < 1, "第" + (i + 1) + "行超过允许最大核销金额:" + maxAuditAmount.subtract(Optional.ofNullable(detailReqVo.getFeeUsed()).orElse(BigDecimal.ZERO)));
            if (StringUtils.equals(GlobalWhetherEnum.NO.getCode(), typeFineEntity.getIsAllowRepeatAudit())) {
                detailReqVo.setIsAllAudit(GlobalWhetherEnum.YES.getCode());
            }
            //校验核销是否完成
            if (StringUtils.equals(GlobalWhetherEnum.YES.getCode(), typeFineEntity.getIsAllowRepeatAudit())) {
                //允许多次核销,但是超额核销比例为空,如果核销金额等于活动明细的费用申请金额,完全核销标识也必须为 Y ,
                if (Objects.isNull(typeFineEntity.getExtraAuditRatio()) && addAmount.compareTo(detailReqVo.getApplyAmount()) == 0) {
                    detailReqVo.setIsAllAudit(GlobalWhetherEnum.YES.getCode());
                }
                if (Objects.nonNull(typeFineEntity.getExtraAuditRatio()) && addAmount.compareTo(maxAuditAmount) == 0) {
                    detailReqVo.setIsAllAudit(GlobalWhetherEnum.YES.getCode());
                }
            }
        }
        reqVo.setTotalAmount(allAuditAmount);
        reqVo.setMaterialsAmount(allMaterialsAmount);
        reqVo.setBillAuditAmount(allAuditAmount.subtract(allMaterialsAmount));
    }

    private void checkDataExist(TpmLiqueurAuditReqVo reqVo) {
        LambdaQueryWrapper<TpmAuditEntity> wrapper = new LambdaQueryWrapper<TpmAuditEntity>().eq(TpmAuditEntity::getAuditCode, reqVo.getAuditCode());
        if (StringUtils.isNotEmpty(reqVo.getId())) {
            wrapper.ne(TpmAuditEntity::getId, reqVo.getId());
        }
        Integer count = auditMapper.selectCount(wrapper);
        AssertUtils.isTrue(count==0, AuditException.DATA_CODE_DUPLICATE);
    }

    /**
     * 组装提交审批流的参数
     *
     * @param entity
     * @param reqVo
     * @return
     */
    public StartProcessReqVo buildStartProcessData(TpmLiqueurAuditEntity entity, TpmLiqueurAuditReqVo reqVo) {
        UserRedis user = UserUtils.getUser();
        StartProcessReqVo startProcessReqVo = new StartProcessReqVo();
        startProcessReqVo.setCallBackFeign("TpmLiqueurAuditCallBackFeign");
        startProcessReqVo.setProcessKey(reqVo.getWorkFlowKey());
        startProcessReqVo.setUserCode(user.getUsername());
        startProcessReqVo.setPosCode(user.getPoscode());
        startProcessReqVo.setTitle(reqVo.getTitle());
        startProcessReqVo.setFormNo(entity.getId());
        startProcessReqVo.setRemark(reqVo.getApproveRemarks());
        startProcessReqVo.setSignTicket(System.currentTimeMillis() + "");
        startProcessReqVo.setBusinessCode(entity.getAuditCode());
        List<TaActFileReqVo> taActFileReqVos = Optional.ofNullable(reqVo.getActivityFileVos()).orElse(Lists.newArrayList()).stream().map(o -> {
            TaActFileReqVo taActFileReqVo = new TaActFileReqVo();
            taActFileReqVo.setObjectName(o.getObjectName());
            taActFileReqVo.setFileAddress(o.getAddressUrl());
            return taActFileReqVo;
        }).collect(Collectors.toList());
        startProcessReqVo.setFileList(taActFileReqVos);
        return startProcessReqVo;
    }

    /**
     * 核销提交审批校验
     *
     * @param tpmAuditReqVo
     * @return
     */
    public void approveCheck(TpmLiqueurAuditReqVo tpmAuditReqVo) {
        //活动关闭为单条操作,参数接收为id
        AssertUtils.isNotEmpty(tpmAuditReqVo.getWorkFlowKey(), "请选择流程");
        AssertUtils.isNotEmpty(tpmAuditReqVo.getId(), "id不能为空");
        //提交审批的数据审批状态必须为 待提交、审批驳回、流程追回
        TpmLiqueurAuditEntity entity = tpmLiqueurAuditMapper.selectOne(new LambdaQueryWrapper<TpmLiqueurAuditEntity>().eq(TpmLiqueurAuditEntity::getId, tpmAuditReqVo.getId()));
        //获取可以提交审批的状态
        Set<String> canApproveStatus = ActApproveStatusEnum.getCanApproveStatus();
        AssertUtils.isTrue(canApproveStatus.contains(entity.getApproveStatus()), "仅状态为“待提交、审批驳回、流程追回”的单据可提交审批");
        tpmAuditReqVo.setSaveType(ActSaveTypeEnum.APPROVE.getCode());
    }


    /**
     * 根据businessLineCodes查询transaction列表并转换为businessLineCode-transaction数组map
     *
     * @param businessLineCodes
     * @param auditVo
     */
    public void convertTransactionMap(Set<String> businessLineCodes, LiqueurAuditVo auditVo) {
        //查询核销新增的transaction列表
        List<TpmLiqueurActBudgetTransactionEntity> transactionEntities = liqueurActBudgetTransactionMapper.selectList(new LambdaQueryWrapper<TpmLiqueurActBudgetTransactionEntity>()
                .in(TpmLiqueurActBudgetTransactionEntity::getBusinessLineCode, businessLineCodes)
                .eq(TpmLiqueurActBudgetTransactionEntity::getTransactionType, FeeBudgetDetailTypeEnum.USE.getCode())
                .eq(TpmLiqueurActBudgetTransactionEntity::getDelFlag, CrmDelFlagEnum.NORMAL.getCode()));
        //转换为核销明细编码，transaction数组map
        Map<String, List<TpmLiqueurActBudgetTransactionEntity>> transactionMap = Maps.newHashMap();
        transactionEntities.forEach(transactionEntity -> {
            List<TpmLiqueurActBudgetTransactionEntity> list = transactionMap.containsKey(transactionEntity.getBusinessLineCode()) ? transactionMap.get(transactionEntity.getBusinessLineCode()) : Lists.newArrayList();
            list.add(transactionEntity);
            transactionMap.put(transactionEntity.getBusinessLineCode(), list);
        });
        auditVo.setTransactionEntities(transactionEntities);
        auditVo.setTransactionMap(transactionMap);
    }

    /**
     * 根据actBudgetCodes 查询活动明细列表
     *
     * @param actBudgetCodes
     * @param auditVo
     */
    public void convertActBudgetMap(Set<String> actBudgetCodes, LiqueurAuditVo auditVo) {
        if (!com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(actBudgetCodes)) {
            return;
        }
        List<TpmLiqueurActBudgetEntity> tpmLiqueurActBudgetEntities = liqueurActBudgetMapper.selectList(new LambdaQueryWrapper<TpmLiqueurActBudgetEntity>()
                //匹配活动预算编码
                .in(TpmLiqueurActBudgetEntity::getActBudgetCode, actBudgetCodes)
                .eq(TpmLiqueurActBudgetEntity::getDelFlag, CrmDelFlagEnum.NORMAL.getCode()));
        //转换为费用编码-活动预算map
        Map<String, TpmLiqueurActBudgetEntity> actBudgetEntityMap = tpmLiqueurActBudgetEntities.stream().collect(Collectors.toMap(TpmLiqueurActBudgetEntity::getActBudgetCode, Function.identity()));

        List<TpmLiqueurActEntity> tpmLiqueurActEntities = liqueurActMapper.selectList(new LambdaQueryWrapper<TpmLiqueurActEntity>()
                //匹配活动编码
                .in(TpmLiqueurActEntity::getActCode, tpmLiqueurActBudgetEntities.stream().map(TpmLiqueurActBudgetEntity::getActCode).collect(Collectors.toSet()))
                .eq(TpmLiqueurActEntity::getDelFlag, CrmDelFlagEnum.NORMAL.getCode()));
        //转换为活动-活动详情map
        Map<String, TpmLiqueurActEntity> actMap = tpmLiqueurActEntities.stream().collect(Collectors.toMap(TpmLiqueurActEntity::getActCode, Function.identity()));
        auditVo.setActEntities(tpmLiqueurActEntities);
        auditVo.setActEntityMap(actMap);
        auditVo.setTpmLiqueurActBudgetEntities(tpmLiqueurActBudgetEntities);
        auditVo.setActBudgetEntityMap(actBudgetEntityMap);
    }

    /**
     * 根据businessLineCodes查询FeeBudgetDetail列表并转换为businessLineCode-FeeBudgetDetail数组map
     *
     * @param businessLineCodes
     * @param auditVo
     */
    public void convertFeeBudgetDetailMap(Set<String> businessLineCodes, LiqueurAuditVo auditVo) {
        //查询核销新增的费用预算明细列表
        List<TpmFeeBudgetDetailsEntity> feeBudgetDetailsEntities = tpmFeeBudgetDetailsService.getBaseMapper().selectList(new LambdaQueryWrapper<TpmFeeBudgetDetailsEntity>()
                .in(TpmFeeBudgetDetailsEntity::getBusinessLineCode, businessLineCodes)
                .eq(TpmFeeBudgetDetailsEntity::getDelFlag, CrmDelFlagEnum.NORMAL.getCode()));
        //转换为核销明细，费用预算明细List map
        Map<String, List<TpmFeeBudgetDetailsEntity>> feeBudgetDetailMap = Maps.newHashMap();
        feeBudgetDetailsEntities.forEach(feeBudgetDetail -> {
            List<TpmFeeBudgetDetailsEntity> list = feeBudgetDetailMap.containsKey(feeBudgetDetail.getBusinessLineCode()) ? feeBudgetDetailMap.get(feeBudgetDetail.getBusinessLineCode()) : Lists.newArrayList();
            list.add(feeBudgetDetail);
            feeBudgetDetailMap.put(feeBudgetDetail.getBusinessLineCode(), list);
        });
        auditVo.setFeeBudgetDetailsEntities(feeBudgetDetailsEntities);
        auditVo.setFeeBudgetDetailMap(feeBudgetDetailMap);
    }

    /**
     * 根据费用预算编码获取费用预算列表，费用预算管控列表
     *
     * @param feeBudgetCodes
     * @param auditVo
     */
    public void convertFeeBudgetData(Set<String> feeBudgetCodes, LiqueurAuditVo auditVo) {
        //根据费用预算使用详情获取费用预算列表，只查询本次核销有扣减预算的费用预算列表
        if (!com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(feeBudgetCodes)) {
            return;
        }
        List<TpmFeeBudgetEntity> budgetEntities = tpmFeeBudgetService.getBaseMapper().selectList(new LambdaQueryWrapper<TpmFeeBudgetEntity>()
                .in(TpmFeeBudgetEntity::getFeeBudgetCode, feeBudgetCodes)
                .eq(TpmFeeBudgetEntity::getDelFlag, CrmDelFlagEnum.NORMAL.getCode()));
        //获取控制维度管控表
        List<TpmFeeBudgetControlEntity> controlEntities = tpmFeeBudgetControlService.getBaseMapper().selectList(new LambdaQueryWrapper<TpmFeeBudgetControlEntity>()
                .in(TpmFeeBudgetControlEntity::getId, budgetEntities.stream().map(TpmFeeBudgetEntity::getControlId).collect(Collectors.toList()))
                .eq(TpmFeeBudgetControlEntity::getDelFlag, CrmDelFlagEnum.NORMAL.getCode()));
        //转换为控制id，控制维度map
        Map<String, TpmFeeBudgetControlEntity> controlEntityMap = controlEntities.stream().collect(Collectors.toMap(TpmFeeBudgetControlEntity::getId, Function.identity()));
        //转换为预算编码，费用预算map
        Map<String, TpmFeeBudgetEntity> feeBudgetEntityMap = budgetEntities.stream().collect(Collectors.toMap(TpmFeeBudgetEntity::getFeeBudgetCode, Function.identity()));
        auditVo.setFeeBudgetEntities(budgetEntities);
        auditVo.setFeeBudgetControlEntities(controlEntities);
        auditVo.setFeeBudgetControlEntityMap(controlEntityMap);
        auditVo.setFeeBudgetEntityMap(feeBudgetEntityMap);
    }

    /**
     * 根据活动明细编码获取活动明细列表
     *
     * @param actDetailCodes
     * @param auditVo
     */
    public void convertActRegisterDetail(Set<String> actDetailCodes, LiqueurAuditVo auditVo) {
        //活动明细编码获取活动明细列表
        List<TpmLiqueurActRegisterDetailEntity> actRegisterDetailEntities = actRegisterDetailService.getBaseMapper().selectList(new LambdaQueryWrapper<TpmLiqueurActRegisterDetailEntity>()
                .in(TpmLiqueurActRegisterDetailEntity::getActDetailCode, actDetailCodes)
                .eq(TpmLiqueurActRegisterDetailEntity::getDelFlag, CrmDelFlagEnum.NORMAL.getCode()));
        //转换为活动明细编码-活动明细map
        Map<String, TpmLiqueurActRegisterDetailEntity> actRegisterDetailEntityMap = actRegisterDetailEntities.stream().collect(Collectors.toMap(TpmLiqueurActRegisterDetailEntity::getActDetailCode, Function.identity()));
        auditVo.setActRegisterDetailEntities(actRegisterDetailEntities);
        auditVo.setActRegisterDetailEntityMap(actRegisterDetailEntityMap);
    }
}
