package com.biz.crm.liqueraudit.service.impl;

import com.biz.crm.liqueraudit.mapper.TpmLiqueurAuditDetailsMapper;
import com.biz.crm.liqueraudit.model.TpmLiqueurAuditDetailsEntity;
import com.biz.crm.liqueraudit.service.ITpmLiqueurAuditDetailsService;
import com.biz.crm.nebular.tpm.liqueuraudit.req.TpmLiqueurAuditDetailsReqVo;
import com.biz.crm.nebular.tpm.liqueuraudit.resp.TpmLiqueurAuditDetailsRespVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.util.CrmBeanUtil;
import org.apache.commons.collections4.CollectionUtils;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.transaction.annotation.Transactional;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import javax.annotation.Resource;

/**
 * 酒类tpm核销明细表接口实现
 *
 * @author jerry7
 * @date 2021-03-10 10:09:16
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="TpmLiqueurAuditDetailsServiceExpandImpl")
public class TpmLiqueurAuditDetailsServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<TpmLiqueurAuditDetailsMapper, TpmLiqueurAuditDetailsEntity> implements ITpmLiqueurAuditDetailsService {

    @Resource
    private TpmLiqueurAuditDetailsMapper tpmLiqueurAuditDetailsMapper;

    /**
     * 列表
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<TpmLiqueurAuditDetailsRespVo> findList(TpmLiqueurAuditDetailsReqVo reqVo){
        Page<TpmLiqueurAuditDetailsRespVo> page = new Page<>(reqVo.getPageNum(), reqVo.getPageSize());
        List<TpmLiqueurAuditDetailsRespVo> list = tpmLiqueurAuditDetailsMapper.findList(page, reqVo);
        return PageResult.<TpmLiqueurAuditDetailsRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     * @param reqVo
     * @return tpmLiqueurAuditDetailsRespVo
     */
    @Override
    public TpmLiqueurAuditDetailsRespVo query(TpmLiqueurAuditDetailsReqVo reqVo){
        return null;
    }

    /**
     * 新增
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(TpmLiqueurAuditDetailsReqVo reqVo){
        TpmLiqueurAuditDetailsEntity entity = CrmBeanUtil.copy(reqVo,TpmLiqueurAuditDetailsEntity.class);
        this.save(entity);
    }

    /**
     * 更新
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(TpmLiqueurAuditDetailsReqVo reqVo){
        TpmLiqueurAuditDetailsEntity entity = this.getById(reqVo.getId());
        this.updateById(entity);
    }

    /**
     * 删除
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(TpmLiqueurAuditDetailsReqVo reqVo){
        List<TpmLiqueurAuditDetailsEntity> tpmLiqueurAuditDetailsEntities = tpmLiqueurAuditDetailsMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(tpmLiqueurAuditDetailsEntities)){
            tpmLiqueurAuditDetailsEntities.forEach(o -> {
                 o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(tpmLiqueurAuditDetailsEntities);
    }

    /**
     * 启用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(TpmLiqueurAuditDetailsReqVo reqVo){
        //设置状态为启用
        List<TpmLiqueurAuditDetailsEntity> tpmLiqueurAuditDetailsEntities = tpmLiqueurAuditDetailsMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(tpmLiqueurAuditDetailsEntities)){
            tpmLiqueurAuditDetailsEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(tpmLiqueurAuditDetailsEntities);
    }

    /**
     * 禁用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(TpmLiqueurAuditDetailsReqVo reqVo){
        //设置状态为禁用
        List<TpmLiqueurAuditDetailsEntity> tpmLiqueurAuditDetailsEntities = tpmLiqueurAuditDetailsMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(tpmLiqueurAuditDetailsEntities)){
                tpmLiqueurAuditDetailsEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(tpmLiqueurAuditDetailsEntities);
    }
}
