package com.biz.crm.liqueraudit.service.impl;

import com.biz.crm.liqueraudit.mapper.TpmLiqueurAuditFileMapper;
import com.biz.crm.liqueraudit.model.TpmLiqueurAuditFileEntity;
import com.biz.crm.liqueraudit.service.ITpmLiqueurAuditFileService;
import com.biz.crm.nebular.tpm.liqueuraudit.req.TpmLiqueurAuditFileReqVo;
import com.biz.crm.nebular.tpm.liqueuraudit.resp.TpmLiqueurAuditFileRespVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.util.CrmBeanUtil;
import org.apache.commons.collections4.CollectionUtils;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.transaction.annotation.Transactional;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import javax.annotation.Resource;

/**
 * J酒类TPM核销申请资料表;接口实现
 *
 * @author jerry7
 * @date 2021-03-10 10:09:16
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="TpmLiqueurAuditFileServiceExpandImpl")
public class TpmLiqueurAuditFileServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<TpmLiqueurAuditFileMapper, TpmLiqueurAuditFileEntity> implements ITpmLiqueurAuditFileService {

    @Resource
    private TpmLiqueurAuditFileMapper tpmLiqueurAuditFileMapper;

    /**
     * 列表
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<TpmLiqueurAuditFileRespVo> findList(TpmLiqueurAuditFileReqVo reqVo){
        Page<TpmLiqueurAuditFileRespVo> page = new Page<>(reqVo.getPageNum(), reqVo.getPageSize());
        List<TpmLiqueurAuditFileRespVo> list = tpmLiqueurAuditFileMapper.findList(page, reqVo);
        return PageResult.<TpmLiqueurAuditFileRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     * @param reqVo
     * @return tpmLiqueurAuditFileRespVo
     */
    @Override
    public TpmLiqueurAuditFileRespVo query(TpmLiqueurAuditFileReqVo reqVo){
        return null;
    }

    /**
     * 新增
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(TpmLiqueurAuditFileReqVo reqVo){
        TpmLiqueurAuditFileEntity entity = CrmBeanUtil.copy(reqVo,TpmLiqueurAuditFileEntity.class);
        this.save(entity);
    }

    /**
     * 更新
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(TpmLiqueurAuditFileReqVo reqVo){
        TpmLiqueurAuditFileEntity entity = this.getById(reqVo.getId());
        this.updateById(entity);
    }

    /**
     * 删除
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(TpmLiqueurAuditFileReqVo reqVo){
        List<TpmLiqueurAuditFileEntity> tpmLiqueurAuditFileEntities = tpmLiqueurAuditFileMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(tpmLiqueurAuditFileEntities)){
            tpmLiqueurAuditFileEntities.forEach(o -> {
                 o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(tpmLiqueurAuditFileEntities);
    }

    /**
     * 启用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(TpmLiqueurAuditFileReqVo reqVo){
        //设置状态为启用
        List<TpmLiqueurAuditFileEntity> tpmLiqueurAuditFileEntities = tpmLiqueurAuditFileMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(tpmLiqueurAuditFileEntities)){
            tpmLiqueurAuditFileEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(tpmLiqueurAuditFileEntities);
    }

    /**
     * 禁用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(TpmLiqueurAuditFileReqVo reqVo){
        //设置状态为禁用
        List<TpmLiqueurAuditFileEntity> tpmLiqueurAuditFileEntities = tpmLiqueurAuditFileMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(tpmLiqueurAuditFileEntities)){
                tpmLiqueurAuditFileEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(tpmLiqueurAuditFileEntities);
    }
}
