package com.biz.crm.liqueraudit.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.CrmCodeRuleConstants;
import com.biz.crm.activiti.act.TaActBaseFeign;
import com.biz.crm.annotation.Klock;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.budgetsubjects.mapper.TpmBudgetSubjectsMapper;
import com.biz.crm.budgetsubjects.model.TpmBudgetSubjectsEntity;
import com.biz.crm.common.GlobalParam;
import com.biz.crm.common.PageResult;
import com.biz.crm.common.TpmGlobalDictConstants;
import com.biz.crm.costtypecategories.service.ITpmCostTypeCategoriesService;
import com.biz.crm.costtypefine.model.TpmCostTypeFineEntity;
import com.biz.crm.costtypefine.service.ITpmCostTypeFineService;
import com.biz.crm.crmlog.handle.util.CrmLogSendUtil;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.GlobalWhetherEnum;
import com.biz.crm.eunm.activiti.Indicator;
import com.biz.crm.eunm.tpm.*;
import com.biz.crm.exception.tpm.FeeBudgetException;
import com.biz.crm.feebudget.mapper.TpmFeeBudgetControlMapper;
import com.biz.crm.feebudget.model.TpmFeeBudgetControlEntity;
import com.biz.crm.feebudget.model.TpmFeeBudgetDetailsEntity;
import com.biz.crm.feebudget.model.TpmFeeBudgetEntity;
import com.biz.crm.feebudget.service.ITpmFeeBudgetControlService;
import com.biz.crm.feebudget.service.ITpmFeeBudgetDetailsService;
import com.biz.crm.feebudget.service.ITpmFeeBudgetService;
import com.biz.crm.liqueraudit.mapper.TpmLiqueurAuditAttachMapper;
import com.biz.crm.liqueraudit.mapper.TpmLiqueurAuditDetailsMapper;
import com.biz.crm.liqueraudit.mapper.TpmLiqueurAuditFileMapper;
import com.biz.crm.liqueraudit.mapper.TpmLiqueurAuditMapper;
import com.biz.crm.liqueraudit.model.*;
import com.biz.crm.liqueraudit.service.*;
import com.biz.crm.liqueuract.mapper.*;
import com.biz.crm.liqueuract.model.TpmLiqueurActBudgetEntity;
import com.biz.crm.liqueuract.model.TpmLiqueurActBudgetTransactionEntity;
import com.biz.crm.liqueuract.model.TpmLiqueurActEntity;
import com.biz.crm.liqueuract.model.TpmLiqueurActRegisterDetailEntity;
import com.biz.crm.liqueuract.service.*;
import com.biz.crm.mq.RocketMQConstant;
import com.biz.crm.mq.RocketMQMessageBody;
import com.biz.crm.mq.RocketMQProducer;
import com.biz.crm.nebular.activiti.act.ActivitiCallBackVo;
import com.biz.crm.nebular.activiti.act.req.StartProcessReqVo;
import com.biz.crm.nebular.activiti.common.ProcessCommonVo;
import com.biz.crm.nebular.tpm.act.req.TpmActSendMessageVo;
import com.biz.crm.nebular.tpm.audit.req.TpmAuditReqVo;
import com.biz.crm.nebular.tpm.costtypecategories.resp.TpmCostTypeCategoriesRespVo;
import com.biz.crm.nebular.tpm.fiscalyear.req.TpmFiscalYearSettingReqVo;
import com.biz.crm.nebular.tpm.fiscalyear.resp.TpmFiscalYearSettingRespVo;
import com.biz.crm.nebular.tpm.liqueuract.req.TpmLiqueurActRegisterDetailAttachReqVo;
import com.biz.crm.nebular.tpm.liqueuract.req.TpmLiqueurActRegisterDetailReqVo;
import com.biz.crm.nebular.tpm.liqueuract.req.TpmLiqueurActReqVo;
import com.biz.crm.nebular.tpm.liqueuract.resp.TpmLiqueurActRegisterDetailAttachRespVo;
import com.biz.crm.nebular.tpm.liqueuract.resp.TpmLiqueurActRegisterDetailRespVo;
import com.biz.crm.nebular.tpm.liqueuract.resp.TpmLiqueurActRespVo;
import com.biz.crm.nebular.tpm.liqueuraudit.req.TpmLiqueurAuditAttachReqVo;
import com.biz.crm.nebular.tpm.liqueuraudit.req.TpmLiqueurAuditDetailsReqVo;
import com.biz.crm.nebular.tpm.liqueuraudit.req.TpmLiqueurAuditReqVo;
import com.biz.crm.nebular.tpm.liqueuraudit.resp.TpmLiqueurAuditAttachRespVo;
import com.biz.crm.nebular.tpm.liqueuraudit.resp.TpmLiqueurAuditDetailsRespVo;
import com.biz.crm.nebular.tpm.liqueuraudit.resp.TpmLiqueurAuditFileRespVo;
import com.biz.crm.nebular.tpm.liqueuraudit.resp.TpmLiqueurAuditRespVo;
import com.biz.crm.util.*;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.*;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 酒类TPM核销申请主表;接口实现
 *
 * @author jerry7
 * @date 2021-03-10 10:09:16
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name = "TpmLiqueurAuditServiceExpandImpl")
public class TpmLiqueurAuditServiceImpl<M extends BaseMapper<T>, T> extends ServiceImpl<TpmLiqueurAuditMapper, TpmLiqueurAuditEntity> implements ITpmLiqueurAuditService {

    @Resource
    private TpmLiqueurAuditMapper tpmLiqueurAuditMapper;

    @Autowired
    private LiquerAuditServiceHelper helper;

    @Autowired
    private ITpmLiqueurAuditDetailsService tpmLiqueurAuditDetailsService;

    @Autowired
    private ITpmLiqueurAuditFileService tpmLiqueurAuditFileService;

    @Resource
    private ITpmLiqueurActRegisterDetailService actRegisterDetailService;

    @Resource
    private TpmLiqueurActBudgetTransactionMapper liqueurActBudgetTransactionMapper;

    @Resource
    private ITpmLiqueurActBudgetTransactionService liqueurActBudgetTransactionService;

    @Resource
    private TpmFeeBudgetControlMapper feeBudgetControlMapper;

    @Resource
    private TpmLiqueurActBudgetMapper liqueurActBudgetMapper;

    @Resource
    private TpmBudgetSubjectsMapper budgetSubjectsMapper;

    @Resource
    private ITpmCostTypeFineService tpmCostTypeFineService;

    @Resource
    private ITpmLiqueurActRegisterService tpmLiqueurActRegisterService;

    @Resource
    private TpmLiqueurActBudgetService tpmLiqueurActBudgetService;

    @Resource
    private ITpmFeeBudgetService tpmFeeBudgetService;

    @Autowired
    private TaActBaseFeign activityFeign;

    @Resource
    private ITpmFeeBudgetControlService tpmFeeBudgetControlService;

    @Resource
    private TpmLiqueurActService tpmLiqueurActService;

    @Resource
    private TpmLiqueurActMapper liqueurActMapper;

    @Resource
    private TpmLiqueurActRegisterDetailMapper liqueurActRegisterDetailMapper;

    @Resource
    private TpmLiqueurActRegisterDetailAttachMapper liqueurActRegisterDetailAttachMapper;

    @Resource
    private ITpmFeeBudgetDetailsService tpmFeeBudgetDetailsService;

    @Value("${rocketmq.topic}" + "${rocketmq.environment-variable}")
    private String topic;

    @Resource
    private RocketMQProducer rocketMQProducer;

    @Resource
    private TpmLiqueurAuditDetailsMapper auditDetailsMapper;

    @Resource
    private TpmLiqueurAuditAttachMapper auditAttachMapper;

    @Resource
    private ITpmLiqueurAuditAttachService auditAttachService;

    @Resource
    private TpmLiqueurAuditFileMapper auditFileMapper;

    @Resource
    private ITpmCostTypeCategoriesService categoriesService;

    @Autowired
    private CrmLogSendUtil crmLogSendUtil;


    /**
     * 列表
     *
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<TpmLiqueurAuditRespVo> findList(TpmLiqueurAuditReqVo reqVo) {
        Page<TpmLiqueurAuditRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        List<TpmLiqueurAuditRespVo> list = tpmLiqueurAuditMapper.findList(page, reqVo);
        helper.convertListDate(list);
        return PageResult.<TpmLiqueurAuditRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     *
     * @param id
     * @return tpmLiqueurAuditRespVo
     */
    @Override
    public TpmLiqueurAuditRespVo query(String id) {
        AssertUtils.isNotEmpty(id, "id不能为空");
        TpmLiqueurAuditReqVo reqVo = new TpmLiqueurAuditReqVo();
        reqVo.setId(id);
        PageResult<TpmLiqueurAuditRespVo> pageResult = this.findList(reqVo);
        AssertUtils.isTrue(CollectionUtils.isNotEmpty(pageResult.getData()), "核销数据不存在");
        TpmLiqueurAuditRespVo respVo = pageResult.getData().get(0);
        //查询附加信息明细
        List<TpmLiqueurAuditAttachEntity> attachEntities = auditAttachMapper.selectList(Wrappers.lambdaQuery(TpmLiqueurAuditAttachEntity.class).eq(TpmLiqueurAuditAttachEntity::getAuditCode, respVo.getAuditCode()));
        List<TpmLiqueurAuditAttachRespVo> attachRespVos = CrmBeanUtil.copyList(attachEntities, TpmLiqueurAuditAttachRespVo.class);
        respVo.setAttachVos(attachRespVos);

        //查询核销明细
        List<TpmLiqueurAuditDetailsEntity> detailsEntities = auditDetailsMapper.selectList(Wrappers.lambdaQuery(TpmLiqueurAuditDetailsEntity.class).eq(TpmLiqueurAuditDetailsEntity::getAuditCode, respVo.getAuditCode()));
        if (CollectionUtils.isNotEmpty(detailsEntities)) {
            //查询核销资料
            List<TpmLiqueurAuditFileEntity> auditFileEntities = auditFileMapper.selectList(Wrappers.lambdaQuery(TpmLiqueurAuditFileEntity.class).eq(TpmLiqueurAuditFileEntity::getAuditCode, respVo.getAuditCode()));
            Map<String, List<TpmLiqueurAuditFileRespVo>> fileRespVosMap = auditFileEntities.stream().map(o -> {
                TpmLiqueurAuditFileRespVo fileRespVo = CrmBeanUtil.copy(o, TpmLiqueurAuditFileRespVo.class);
                return fileRespVo;
            }).collect(Collectors.groupingBy(TpmLiqueurAuditFileRespVo::getAuditDetailCode));
            List<TpmLiqueurAuditDetailsRespVo> detailsRespVos = detailsEntities.stream().map(o -> {
                TpmLiqueurAuditDetailsRespVo detailsRespVo = CrmBeanUtil.copy(o, TpmLiqueurAuditDetailsRespVo.class);
                //设置核销明细对应的核销资料
                if (MapUtils.isNotEmpty(fileRespVosMap)) {
                    List<TpmLiqueurAuditFileRespVo> tpmLiqueurAuditFileRespVos = fileRespVosMap.get(o.getAuditDetailCode());
                    detailsRespVo.setFileVos(tpmLiqueurAuditFileRespVos);
                }
                return detailsRespVo;
            }).collect(Collectors.toList());
            respVo.setDetailsVos(detailsRespVos);
        }

        //组装查询方法的其他数据,项目上自己实现
        buildAuditOtherData(respVo);

        return respVo;
    }

    /**
     * 组装查询方法的其他数据
     *
     * @param respVo
     * @return
     */
    @Override
    public TpmLiqueurAuditRespVo buildAuditOtherData(TpmLiqueurAuditRespVo respVo) {
        //具体逻辑项目上自己实现
        return respVo;
    }

    /**
     * 新增
     *
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    @Klock(keys = {"liqueurAudit", "#reqVo.lockUserName"}, waitTime = 0, leaseTime = 5)
    public void save(TpmLiqueurAuditReqVo reqVo) {
        //校验参数
        helper.saveCheck(reqVo);
        AssertUtils.isTrue(ActSaveTypeEnum.getCreateTypes().contains(reqVo.getSaveType()), "保存类型值错误");
        reqVo.setAuditCode(CodeUtil.createOneCode(CrmCodeRuleConstants.AUDIT));
        TpmLiqueurAuditEntity entity = CrmBeanUtil.copy(reqVo, TpmLiqueurAuditEntity.class);
        //保存核销主表数据
        this.save(entity);
        //保存核销明细表数据
        this.saveAuditDetailInfo(reqVo, entity);
        //保存费用上账附件表
        this.saveActAttach(reqVo, entity);
        //保存物料信息
        this.saveMaterials();
        //提交并审批时
        if (StringUtils.equals(ActSaveTypeEnum.ADD_AND_APPROVE.getCode(), reqVo.getSaveType())) {
            //占用预算
            this.occupyTheBudget(reqVo);
//            int i =1/0;
            this.sendToActivity(entity, reqVo);
        }
        //日志
        Object menuCodeObj = ThreadLocalUtil.getObj(GlobalParam.MENU_CODE);
        TpmLiqueurAuditRespVo newData = CrmBeanUtil.copy(entity, TpmLiqueurAuditRespVo.class);
        crmLogSendUtil.sendForAdd(menuCodeObj.toString(),newData.getId(),newData.getAuditCode(),newData);
    }

    /**
     * 更新
     *
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    @Klock(keys = {"liqueurAudit", "#reqVo.lockUserName"}, waitTime = 0, leaseTime = 5)
    public void update(TpmLiqueurAuditReqVo reqVo) {
        AssertUtils.isNotEmpty(reqVo.getId(), "id不能为空");
        helper.saveCheck(reqVo);
        //日志老数据
        TpmLiqueurAuditEntity oldEntity = this.getById(reqVo.getId());
        TpmLiqueurAuditRespVo oldData = CrmBeanUtil.copy(oldEntity, TpmLiqueurAuditRespVo.class);
        AssertUtils.isNotNull(oldEntity, FeeBudgetException.DATA_NOT_EXIST);
        AssertUtils.isTrue(ActSaveTypeEnum.getUpdateTypes().contains(reqVo.getSaveType()), "保存类型值错误");
        TpmLiqueurAuditEntity tpmLiqueurAuditEntity = CrmBeanUtil.copy(reqVo, TpmLiqueurAuditEntity.class);
        this.updateById(tpmLiqueurAuditEntity);
        //更新核销明细数据
        this.updateAuditDetail(reqVo, tpmLiqueurAuditEntity);
        //更新费用上账附件表
        this.updateAuditAttach(reqVo, tpmLiqueurAuditEntity);
        //保存物料信息
        this.saveMaterials();
        //提交并审批时占用预算
        if (StringUtils.equals(ActApproveStatusEnum.APPROVING.getCode(), tpmLiqueurAuditEntity.getApproveStatus())) {
            this.occupyTheBudget(reqVo);
            this.sendToActivity(tpmLiqueurAuditEntity, reqVo);
        }
        Object menuCodeObj = ThreadLocalUtil.getObj(GlobalParam.MENU_CODE);
        TpmLiqueurAuditRespVo newData = CrmBeanUtil.copy(tpmLiqueurAuditEntity,  TpmLiqueurAuditRespVo.class);
        //发送修改日志
        crmLogSendUtil.sendForUpdate(menuCodeObj.toString(),newData.getId(),newData.getAuditCode(),oldData,newData);
    }

    /**
     * 删除
     *
     * @param ids
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(List<String> ids) {
        List<TpmLiqueurAuditEntity> tpmAuditEntities = tpmLiqueurAuditMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty(tpmAuditEntities)) {
            helper.deleteCheck(tpmAuditEntities, ids);
            //删除核销明细表数据
            List<String> auditCodes = tpmAuditEntities.stream().map(TpmLiqueurAuditEntity::getAuditCode).collect(Collectors.toList());
            tpmLiqueurAuditDetailsService.getBaseMapper().delete(Wrappers.<TpmLiqueurAuditDetailsEntity>lambdaQuery()
                    .in(TpmLiqueurAuditDetailsEntity::getAuditCode, auditCodes));

            //删除核销附件信息表
            auditAttachService.getBaseMapper().delete(Wrappers.<TpmLiqueurAuditAttachEntity>lambdaQuery()
                    .in(TpmLiqueurAuditAttachEntity::getAuditCode, auditCodes));

            //删除核销主表数据
            tpmLiqueurAuditMapper.deleteBatchIds(ids);
        }
        //日志
        Object menuCodeObj = ThreadLocalUtil.getObj(GlobalParam.MENU_CODE);
        for (TpmLiqueurAuditEntity oldData:tpmAuditEntities) {
            crmLogSendUtil.sendForDel(menuCodeObj.toString(),oldData.getId(),oldData.getAuditCode(),oldData);
        }
    }

    /**
     * 启用
     *
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(TpmLiqueurAuditReqVo reqVo) {
        //设置状态为启用
        List<TpmLiqueurAuditEntity> tpmLiqueurAuditEntities = tpmLiqueurAuditMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty(tpmLiqueurAuditEntities)) {
            tpmLiqueurAuditEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(tpmLiqueurAuditEntities);
    }

    /**
     * 禁用
     *
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(TpmLiqueurAuditReqVo reqVo) {
        //设置状态为禁用
        List<TpmLiqueurAuditEntity> tpmLiqueurAuditEntities = tpmLiqueurAuditMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty(tpmLiqueurAuditEntities)) {
            tpmLiqueurAuditEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(tpmLiqueurAuditEntities);
    }

    @Override
    public PageResult<TpmLiqueurActRespVo> getActList(TpmLiqueurActReqVo reqVo) {
        reqVo.setApproveStatus(ActApproveStatusEnum.APPROVED.getCode());
        reqVo.setIsAllAudit(GlobalWhetherEnum.NO.getCode());
        reqVo.setIsAudit(GlobalWhetherEnum.YES.getCode());
        reqVo.setAllowAuditEndDate(DateUtil.formatDate());
        Page<TpmLiqueurActRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        List<TpmLiqueurActRespVo> list = liqueurActMapper.findList(page, reqVo);
        return PageResult.<TpmLiqueurActRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();

    }

    @Override
    public PageResult<TpmLiqueurActRegisterDetailRespVo> getActDetailList(TpmLiqueurActRegisterDetailReqVo reqVo) {
        reqVo.setIsAllAudit(GlobalWhetherEnum.NO.getCode());
        reqVo.setIsAudit(GlobalWhetherEnum.YES.getCode());
        //reqVo.setAllowAuditEndDate(DateUtil.formatDate());
        Page<TpmLiqueurActRegisterDetailRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        List<TpmLiqueurActRegisterDetailRespVo> list = liqueurActRegisterDetailMapper.findDetailByRegisterStatus(page, reqVo);
        return PageResult.<TpmLiqueurActRegisterDetailRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    @Override
    public PageResult<TpmLiqueurActRegisterDetailAttachRespVo> getAttachList(TpmLiqueurActRegisterDetailAttachReqVo reqVo) {
        Page<TpmLiqueurActRegisterDetailAttachRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        List<TpmLiqueurActRegisterDetailAttachRespVo> list = liqueurActRegisterDetailAttachMapper.findList(page, reqVo);
        return PageResult.<TpmLiqueurActRegisterDetailAttachRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void auditCallBack(ActivitiCallBackVo activitiCallBackVo) {
        TpmAuditReqVo reqVo = new TpmAuditReqVo();
        reqVo.setId(activitiCallBackVo.getFormNo());
        //审批通过
        if (Indicator.CON_BPM_DOING.getCode() == activitiCallBackVo.getProcessState()) {
            String actId = this.auditApproved(reqVo);
            //完全核销的活动不为空,发送消息(sfa需要终止核销)
            TpmActSendMessageVo actSendMessageVo = TpmActSendMessageVo.builder().actId(actId).type(ActSendMessageTypeEnum.ALL_AUDIT.getCode()).build();
            RocketMQMessageBody rocketMQMessageBody = RocketMQMessageBody.builder().topic(topic)
                    .tag(RocketMQConstant.CRM_MQ_TAG.TPM_ACT_APPROVED_AND_CLOSED)
                    .bizKey("tpm")
                    .msgBody(JSON.toJSONString(actSendMessageVo)).build();
            log.info("完全核销,发送MQ消息,messageBody={}", rocketMQMessageBody.getMsgBody());
            rocketMQProducer.convertAndSend(rocketMQMessageBody);

        }
        // 审批驳回
        if (Indicator.CON_BPM_PASS.getCode() == activitiCallBackVo.getProcessState()) {
            reqVo.setApproveStatus(ActApproveStatusEnum.REJECTED.getCode());
            this.rejectAndInterrupt(reqVo);
        }
        // 流程追回
        if (Indicator.CON_BPM_REJECT.getCode() == activitiCallBackVo.getProcessState()) {
            reqVo.setApproveStatus(ActApproveStatusEnum.INTERRUPT.getCode());
            this.rejectAndInterrupt(reqVo);
        }
    }

    @Override
    @Klock(keys = {"liqueurAudit", "#reqVo.lockUserName"}, waitTime = 0, leaseTime = 5)
    @Transactional(rollbackFor = Exception.class)
    public void approve(TpmLiqueurAuditReqVo reqVo) {
        helper.approveCheck(reqVo);
        this.update(reqVo);
    }

    /**
     * 保存核销明细数据以及核销资料
     *
     * @param reqVo
     */
    public void saveAuditDetailInfo(TpmLiqueurAuditReqVo reqVo, TpmLiqueurAuditEntity entity) {
        List<TpmLiqueurAuditDetailsReqVo> detailVos = reqVo.getDetailsVos();
        //待保存核销明细数据
        List<TpmLiqueurAuditDetailsEntity> tpmAuditDetailEntities = Lists.newArrayList();
        //待保存核销资料数据
        List<TpmLiqueurAuditFileEntity> tpmLiqueurAuditFileEntities = Lists.newArrayList();
        for (TpmLiqueurAuditDetailsReqVo o : detailVos) {
            o.setId(null);
            AssertUtils.isNotNull(o.getActDetailCode(), "活动明细编码不存在");
            o.setAuditCode(entity.getAuditCode());
            //生产核销明细编码
            o.setAuditDetailCode(CodeUtil.createOneCode(CrmCodeRuleConstants.AUDIT_DETAIL));
            if (Objects.isNull(o.getFeeUsed())) {
                o.setFeeUsed(BigDecimal.ZERO);
            }
            if (StringUtils.isBlank(o.getIsAllFeeUsed())) {
                o.setIsAllFeeUsed(GlobalWhetherEnum.NO.getCode());
            }
            tpmAuditDetailEntities.add(CrmBeanUtil.copy(o, TpmLiqueurAuditDetailsEntity.class));
            //核销资料
            List<TpmLiqueurAuditFileRespVo> auditFileRespVos = o.getFileVos();
            if (CollectionUtil.listNotEmptyNotSizeZero(auditFileRespVos)) {
                for (TpmLiqueurAuditFileRespVo file : auditFileRespVos) {
                    AssertUtils.isNotNull(file.getAuditFileType(), "核销资料类型不能为空");
                    if (file.getAuditFileType() == 1) {
                        AssertUtils.isNotNull(file.getExampleCode(), "核销采集示例编码不能为空");
                    }
                    file.setAuditCode(entity.getAuditCode());
                    file.setAuditDetailCode(o.getAuditDetailCode());
                    tpmLiqueurAuditFileEntities.add(CrmBeanUtil.copy(file, TpmLiqueurAuditFileEntity.class));
                }
            }
        }
        tpmLiqueurAuditFileService.saveBatch(tpmLiqueurAuditFileEntities);
        tpmLiqueurAuditDetailsService.saveBatch(tpmAuditDetailEntities);
    }

    /**
     * 保存活动附加信息
     *
     * @param reqVo
     */
    private void saveActAttach(TpmLiqueurAuditReqVo reqVo, TpmLiqueurAuditEntity entity) {
        List<TpmLiqueurAuditAttachReqVo> auditDetailsReqVos = reqVo.getAttachVos();
        if (!CollectionUtil.listNotEmptyNotSizeZero(auditDetailsReqVos)) {
            return;
        }
        Map<String, String> payTypeTypeMap = helper.getPayTypeTypeMap(TpmGlobalDictConstants.PAY_TYPE, TpmGlobalDictConstants.PAY_TYPE_TYPE);
        //根据投入类型获取费用科目信息
        List<String> categories = Lists.newArrayList();
        auditDetailsReqVos.forEach(detail -> {
            if (StringUtils.isNotEmpty(detail.getCategoriesCode())) {
                categories.add(detail.getCategoriesCode());
            }
        });
        List<TpmCostTypeCategoriesRespVo> categoriesRespVos = categoriesService.getCategoriesSubjectInfo(categories);
        Map<String, TpmCostTypeCategoriesRespVo> categoriesRespVoHashMap = Maps.newHashMap();
        if (CollectionUtil.listNotEmptyNotSizeZero(categoriesRespVos)) {
            categoriesRespVos.forEach(cate -> {
                categoriesRespVoHashMap.put(cate.getCategoriesCode(), cate);
            });
        }
        Map<String, TpmLiqueurAuditDetailsReqVo> map = Maps.newHashMap();
        reqVo.getDetailsVos().forEach(detail -> {
            map.put(detail.getActDetailCode(), detail);
        });
        reqVo.getAttachVos().forEach(attach -> {
            TpmLiqueurAuditDetailsReqVo detailsReqVo = map.get(attach.getActDetailCode());
            TpmCostTypeCategoriesRespVo tpmCostTypeCategoriesRespVo = categoriesRespVoHashMap.get(attach.getCategoriesCode());
            if(ObjectUtils.isNotNull(tpmCostTypeCategoriesRespVo)){
                attach.setAuditSubjectCode(tpmCostTypeCategoriesRespVo.getBudgetSubjectsCode());
                attach.setAuditSubjectName(tpmCostTypeCategoriesRespVo.getBudgetSubjectsName());
            }
            attach.setAuditCode(entity.getAuditCode());
            attach.setActCode(entity.getActCode());
            attach.setActName(reqVo.getActName());
            attach.setFineCode(entity.getFineCode());
            attach.setFineName(reqVo.getFineName());
            attach.setAuditDetailAttachCode(CodeUtil.createOneCode(CrmCodeRuleConstants.AUDIT_DETAIL_ATTACH));
            attach.setAccountAmount(BigDecimal.ZERO);
            attach.setAuditDetailCode(detailsReqVo.getAuditDetailCode());
            attach.setIsAllAudit(detailsReqVo.getIsAllAudit());
            attach.setIsAllFeeUsed(detailsReqVo.getIsAllFeeUsed());
            attach.setFeeUsed(detailsReqVo.getFeeUsed());
            attach.setBeginDate(detailsReqVo.getBeginDate());
            attach.setBeginDateSecond(detailsReqVo.getBeginDateSecond());
            attach.setEndDate(detailsReqVo.getEndData());
            attach.setEndDateSecond(detailsReqVo.getEndDateSecond());
            if (StringUtils.isNotEmpty(attach.getActDetailName())) {
                attach.setActDetailName(detailsReqVo.getActDetailName());
            }
            //更新payTypeType
            if (StringUtils.isNotEmpty(attach.getPayType())) {
                attach.setPayTypeType(payTypeTypeMap.get(attach.getPayType()));
            }
        });
        auditAttachService.saveOrUpdateBatch(CrmBeanUtil.copyList(reqVo.getAttachVos(), TpmLiqueurAuditAttachEntity.class));
    }


    /**
     * 占用预算
     * 先占用活动预算，后占用费用池
     *
     * @param reqVo 发起核销请求
     */
    private void occupyTheBudget(TpmLiqueurAuditReqVo reqVo) {
        List<TpmLiqueurAuditDetailsReqVo> occupyFeeBudgetDetails = reqVo.getDetailsVos();
        if (CollectionUtils.isEmpty(occupyFeeBudgetDetails)) {
            return;
        }
        //获取活动细类
        TpmCostTypeFineEntity tpmCostTypeFineEntity = tpmCostTypeFineService.getOne(new LambdaQueryWrapper<TpmCostTypeFineEntity>().eq(TpmCostTypeFineEntity::getFineCode, reqVo.getFineCode()));
        //修改活动的已核销金额
//        TpmLiqueurActEntity tpmLiqueurActEntity = liqueurActMapper.selectOne(new LambdaQueryWrapper<TpmLiqueurActEntity>().eq(TpmLiqueurActEntity::getActCode, reqVo.getActCode()));
//        tpmLiqueurActEntity.setAuditTotalAmount(tpmLiqueurActEntity.getAuditTotalAmount().add(reqVo.getBillAuditAmount()));
        //step1：循环活动明细，验证活动明细是否满足核销需求，不满足需求的放入list进行第二步，满足需求的保存核销明细记录
        checkAuditDetail(reqVo, tpmCostTypeFineEntity.getIsAllowRepeatAudit());
        //step2：获取活动预算，循环超额的活动明细进行扣减，扣减完成的保存核销记录，未完成的放入list进行第三步
        checkActAudit(reqVo);
        //step3：获取预算，循环未扣减完成的活动明细进行扣减，如果预算不足抛出异常
        checkFeeBudget(reqVo);
//        liqueurActMapper.updateById(tpmLiqueurActEntity);
    }


    /**
     * 根据预算科目编码集合查询预算科目map
     *
     * @param subjectsCodes
     * @return
     */
    public Map<String, TpmBudgetSubjectsEntity> findBudgetSubjectsByCodes(Collection<String> subjectsCodes) {
        Map<String, TpmBudgetSubjectsEntity> map = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(subjectsCodes)) {
            List<TpmBudgetSubjectsEntity> subjectsEntities = budgetSubjectsMapper.selectList(Wrappers.lambdaQuery(TpmBudgetSubjectsEntity.class).in(TpmBudgetSubjectsEntity::getBudgetSubjectsCode, subjectsCodes));
            if (CollectionUtils.isNotEmpty(subjectsEntities)) {
                subjectsEntities.forEach(o -> {
                    map.put(o.getBudgetSubjectsCode(), o);
                });
            }
        }
        return map;
    }

    /**
     * 校验活动明细申请金额是否满足核销金额扣减，如果满足扣减直接修改已核销金额，并根据活动明细的是否多次核销修改活动明细的核销状态
     */
    public void checkAuditDetail(TpmLiqueurAuditReqVo reqVo, String isAllowRepeatAudit) {
        List<TpmLiqueurAuditDetailsReqVo> occupyFeeBudgetDetails = reqVo.getDetailsVos();
        List<String> actDetailsCodes = occupyFeeBudgetDetails.stream().map(TpmLiqueurAuditDetailsReqVo::getActDetailCode).collect(Collectors.toList());
        //活动明细申请金额不满足扣减，需要扣减活动预算的核销明细列表
        List<TpmLiqueurAuditDetailsReqVo> tpmLiqueurAuditDetailsRespVos = Lists.newArrayList();
        List<TpmLiqueurActRegisterDetailEntity> detailEntityList = actRegisterDetailService.getBaseMapper().selectList(new LambdaQueryWrapper<TpmLiqueurActRegisterDetailEntity>()
                .in(TpmLiqueurActRegisterDetailEntity::getActDetailCode, actDetailsCodes)
                .eq(TpmLiqueurActRegisterDetailEntity::getDelFlag, CrmDelFlagEnum.NORMAL.getCode()));
        Map<String, TpmLiqueurActRegisterDetailEntity> actDetailMap = detailEntityList.stream().collect(Collectors.toMap(TpmLiqueurActRegisterDetailEntity::getActDetailCode, Function.identity()));
        //验证活动明细扣减
        for (TpmLiqueurAuditDetailsReqVo p : occupyFeeBudgetDetails) {
            //是否全部核销放到流程审批通过以后处理
            TpmLiqueurActRegisterDetailEntity actDetail = actDetailMap.get(p.getActDetailCode());
            AssertUtils.isNotNull(actDetail, p.getActDetailCode() + "对应的活动明细不存在！");
            //p.setIsAllAudit(GlobalWhetherEnum.NO.getCode().equals(isAllowRepeatAudit) ? GlobalWhetherEnum.YES.getCode() : GlobalWhetherEnum.NO.getCode());
            //验证活动明细的已核销金额是否大于申请金额，如果大于则直接进入活动预算扣减
            if (Optional.ofNullable(p.getAuditAmount()).orElse(BigDecimal.ZERO).compareTo(p.getApplyAmount()) > 0) {
                p.setAuditAmount(p.getAuditAmount().add(p.getAmount()));
                p.setWaitAmount(p.getAmount());
                tpmLiqueurAuditDetailsRespVos.add(p);
            }
            //验证活动明细的已核销金额加上当前核销金额是否大于申请金额，如果大于则将当前申请金额全部扣减，并计算需要进入活动预算扣减的金额
            else if (Optional.ofNullable(p.getAuditAmount().abs()).orElse(BigDecimal.ZERO).add(p.getAmount()).compareTo(p.getApplyAmount()) > 0) {
                //待核销金额为当前核销金额+已核销金额-申请金额
                BigDecimal waitAudit = p.getAmount().add(p.getAuditAmount().abs()).subtract(p.getApplyAmount());
                actDetail.setAuditAmount(p.getAmount().add(p.getAuditAmount().abs()));
                p.setWaitAmount(waitAudit);
                tpmLiqueurAuditDetailsRespVos.add(p);
            }//当活动明细申请金额大于等于当前核销金额，修改活动明细的已核销金额和是否已完成核销
            else {
                actDetail.setAuditAmount(p.getAuditAmount().add(p.getAmount()));
            }
        }
        actRegisterDetailService.saveOrUpdateBatch(detailEntityList);
        reqVo.setOccupyFeeBudgetDetails(tpmLiqueurAuditDetailsRespVos);
    }

    /**
     * 占用活动预算
     * 当活动明细占用完毕，需要占用活动预算时进入此方法
     */
    public void checkActAudit(TpmLiqueurAuditReqVo reqVo) {
        if (!CollectionUtil.listNotEmptyNotSizeZero(reqVo.getOccupyFeeBudgetDetails())) {
            return;
        }
        List<TpmLiqueurAuditDetailsReqVo> occupyFeeBudgetDetails = reqVo.getOccupyFeeBudgetDetails();
        //待进入费用预算扣减列表
        List<TpmLiqueurAuditDetailsReqVo> waitAuditList = Lists.newArrayList();
        //待新增Transaction列表
        List<TpmLiqueurActBudgetTransactionEntity> addTransaction = Lists.newArrayList();
        Set<String> actDetailCode = reqVo.getOccupyFeeBudgetDetails().stream().map(TpmLiqueurAuditDetailsReqVo::getActDetailCode).collect(Collectors.toSet());
        //查询酒类活动明细预算使用列表
        List<TpmLiqueurActBudgetTransactionEntity> budgetDetailsEntities = liqueurActBudgetTransactionMapper.selectList(new LambdaQueryWrapper<TpmLiqueurActBudgetTransactionEntity>()
                .in(TpmLiqueurActBudgetTransactionEntity::getBusinessLineCode, actDetailCode)
                .eq(TpmLiqueurActBudgetTransactionEntity::getTransactionType, FeeBudgetDetailTypeEnum.USE.getCode())
                .eq(TpmLiqueurActBudgetTransactionEntity::getDelFlag, CrmDelFlagEnum.NORMAL.getCode()));
        //转换活动明细编码-明细预算列表map
        Map<String, List<TpmLiqueurActBudgetTransactionEntity>> budgetDetailEntityMap = Maps.newHashMap();
        budgetDetailsEntities.forEach(budgetDetailsEntity -> {
            List<TpmLiqueurActBudgetTransactionEntity> list = Lists.newArrayList();
            if (budgetDetailEntityMap.containsKey(budgetDetailsEntity.getBusinessLineCode())) {
                list = budgetDetailEntityMap.get(budgetDetailsEntity.getBusinessLineCode());
            }
            list.add(budgetDetailsEntity);
            budgetDetailEntityMap.put(budgetDetailsEntity.getBusinessLineCode(), list);
        });
        //查询活动预算
        List<TpmLiqueurActBudgetEntity> tpmLiqueurActBudgetEntities = liqueurActBudgetMapper.selectList(new LambdaQueryWrapper<TpmLiqueurActBudgetEntity>()
                //匹配活动预算编码
                .in(TpmLiqueurActBudgetEntity::getActBudgetCode, budgetDetailsEntities.stream().map(TpmLiqueurActBudgetTransactionEntity::getActBudgetCode).collect(Collectors.toList()))
                //匹配费用预算编码
                .in(TpmLiqueurActBudgetEntity::getFeeBudgetCode, budgetDetailsEntities.stream().map(TpmLiqueurActBudgetTransactionEntity::getFeeBudgetCode).collect(Collectors.toList()))
                .eq(TpmLiqueurActBudgetEntity::getDelFlag, CrmDelFlagEnum.NORMAL.getCode()));
        //查询活动详情
        List<TpmLiqueurActEntity> tpmLiqueurActEntities = liqueurActMapper.selectList(new LambdaQueryWrapper<TpmLiqueurActEntity>()
                //匹配活动编码
                .in(TpmLiqueurActEntity::getActCode, tpmLiqueurActBudgetEntities.stream().map(TpmLiqueurActBudgetEntity::getActCode).collect(Collectors.toSet()))
                .eq(TpmLiqueurActEntity::getDelFlag, CrmDelFlagEnum.NORMAL.getCode()));
        //转换为活动-活动详情map
        Map<String, TpmLiqueurActEntity> actMap = tpmLiqueurActEntities.stream().collect(Collectors.toMap(TpmLiqueurActEntity::getActCode, Function.identity()));
        //转换为费用编码-活动预算map
        Map<String, TpmLiqueurActBudgetEntity> map = tpmLiqueurActBudgetEntities.stream().collect(Collectors.toMap(TpmLiqueurActBudgetEntity::getFeeBudgetCode, Function.identity()));
        //循环待扣减明细
        for (TpmLiqueurAuditDetailsReqVo p : occupyFeeBudgetDetails) {
            AssertUtils.isTrue(budgetDetailEntityMap.containsKey(p.getActDetailCode()), "活动详细编码：" + p.getActDetailCode() + "未找到对应的费用明细信息");
            List<TpmLiqueurActBudgetTransactionEntity> transactions = budgetDetailEntityMap.get(p.getActDetailCode());
            BigDecimal waitAudit = p.getWaitAmount();
            for (TpmLiqueurActBudgetTransactionEntity transaction : transactions) {
                //如果待扣减金额为0，则跳出循环
                if (waitAudit.compareTo(BigDecimal.ZERO) == 0) {
                    break;
                }
                TpmLiqueurActBudgetEntity actBudgetEntity = map.get(transaction.getFeeBudgetCode());
                TpmLiqueurActEntity actEntity = actMap.get(actBudgetEntity.getActCode());
                AssertUtils.isNotNull(actBudgetEntity, transaction.getFeeBudgetCode() + "对应的活动预算不存在");
                TpmLiqueurActBudgetTransactionEntity newTransaction = CrmBeanUtil.copy(transaction, TpmLiqueurActBudgetTransactionEntity.class);
                newTransaction.setBusinessCode(reqVo.getAuditCode());
                newTransaction.setBusinessLineCode(p.getAuditDetailCode());
                newTransaction.setBusinessType(LiqueurActBudgetBusinessTypeEnum.AUDIT.getCode());
                helper.setPublicParamsNull(newTransaction);
                //如果可用金额大于待扣减金额,则将可用金额扣减
                if (actBudgetEntity.getCanUseAmount().compareTo(waitAudit) > 0) {
                    actBudgetEntity.setCanUseAmount(actBudgetEntity.getCanUseAmount().subtract(waitAudit));
                    actBudgetEntity.setAuditAmount(actBudgetEntity.getAuditAmount().add(waitAudit));
                    actEntity.setCanUseAmount(actEntity.getCanUseAmount().subtract(waitAudit));
                    actEntity.setAuditTotalAmount(actEntity.getAuditTotalAmount().add(waitAudit));
                    newTransaction.setFeeAmount(waitAudit.negate());
                    waitAudit = BigDecimal.ZERO;
                    addTransaction.add(newTransaction);
                }//如果可用金额小于待扣减金额，但大于0，则将可用金额扣减至0，并更新待扣减金额
                else if (actBudgetEntity.getCanUseAmount().compareTo(BigDecimal.ZERO) > 0) {
                    waitAudit = waitAudit.subtract(actBudgetEntity.getCanUseAmount());
                    newTransaction.setFeeAmount(actBudgetEntity.getCanUseAmount().negate());
                    actBudgetEntity.setAuditAmount(actBudgetEntity.getAuditAmount().add(actBudgetEntity.getCanUseAmount()));
                    actEntity.setCanUseAmount(actEntity.getCanUseAmount().subtract(actBudgetEntity.getCanUseAmount()));
                    actEntity.setAuditTotalAmount(actEntity.getAuditTotalAmount().add(actBudgetEntity.getCanUseAmount()));
                    actBudgetEntity.setCanUseAmount(BigDecimal.ZERO);
                    addTransaction.add(newTransaction);
                }
            }
            //如果活动预算扣减完毕后待扣减金额不为0，将该明细放入计划扣减费用预算列表
            if (waitAudit.compareTo(BigDecimal.ZERO) > 0) {
                p.setWaitAmount(waitAudit);
                //将活动明细关联的费用预算编码保存，下一步费用预算占用使用
                p.setFeeBudgetCodes(transactions.stream().sorted(Comparator.comparing(TpmLiqueurActBudgetTransactionEntity::getReduceOrder)).map(TpmLiqueurActBudgetTransactionEntity::getFeeBudgetCode).collect(Collectors.toList()));
                waitAuditList.add(p);
            }
        }
        //保存活动预算
        tpmLiqueurActBudgetService.saveOrUpdateBatch(tpmLiqueurActBudgetEntities);
        liqueurActBudgetTransactionService.saveBatch(addTransaction);
        tpmLiqueurActService.updateBatchById(tpmLiqueurActEntities);
        reqVo.setOccupyFeeBudgetDetails(waitAuditList);
    }


    /**
     * 校验费用预算占用，当核销金额已经扣减了活动明细，活动预算后仍无法满足再进入此方法
     */
    public void checkFeeBudget(TpmLiqueurAuditReqVo reqVo) {
        List<TpmLiqueurAuditDetailsReqVo> occupyFeeBudgetDetails = reqVo.getOccupyFeeBudgetDetails();
        if (!CollectionUtil.listNotEmptyNotSizeZero(reqVo.getOccupyFeeBudgetDetails())) {
            return;
        }
        //需要新增的预算费用明细表
        List<TpmFeeBudgetDetailsEntity> addDetailsList = Lists.newArrayList();
        //获取费用预算列表
        List<String> feeBudgetCodes = Lists.newArrayList();
        List<List<String>> codes = occupyFeeBudgetDetails.stream().map(TpmLiqueurAuditDetailsReqVo::getFeeBudgetCodes).collect(Collectors.toList());
        codes.forEach(feeBudgetCodes::addAll);
        List<TpmFeeBudgetEntity> budgetEntities = tpmFeeBudgetService.getBaseMapper().selectList(new LambdaQueryWrapper<TpmFeeBudgetEntity>()
                .in(TpmFeeBudgetEntity::getFeeBudgetCode, feeBudgetCodes)
                .eq(TpmFeeBudgetEntity::getDelFlag, CrmDelFlagEnum.NORMAL.getCode()));
        //获取控制维度管控表
        List<TpmFeeBudgetControlEntity> controlEntities = tpmFeeBudgetControlService.getBaseMapper().selectList(new LambdaQueryWrapper<TpmFeeBudgetControlEntity>()
                .in(TpmFeeBudgetControlEntity::getId, budgetEntities.stream().map(TpmFeeBudgetEntity::getControlId).collect(Collectors.toList()))
                .eq(TpmFeeBudgetControlEntity::getDelFlag, CrmDelFlagEnum.NORMAL.getCode()));
        //转换为控制id，控制维度map
        Map<String, TpmFeeBudgetControlEntity> controlEntityMap = controlEntities.stream().collect(Collectors.toMap(TpmFeeBudgetControlEntity::getId, Function.identity()));
        //转换为预算编码，费用预算map
        Map<String, TpmFeeBudgetEntity> feeBudgetEntityMap = budgetEntities.stream().collect(Collectors.toMap(TpmFeeBudgetEntity::getFeeBudgetCode, Function.identity()));
        //获取预算科目
        Map<String, TpmBudgetSubjectsEntity> subjectsEntityMap = this.findBudgetSubjectsByCodes(budgetEntities.stream().map(TpmFeeBudgetEntity::getBudgetSubjectsCode).collect(Collectors.toList()));
        for (TpmLiqueurAuditDetailsReqVo p : occupyFeeBudgetDetails) {
            BigDecimal waitAudit = p.getWaitAmount();
            int reduceOrder = 1;
            for (String feeBudgetCode : p.getFeeBudgetCodes()) {
                //如果待扣减金额为0，则跳出循环
                if (waitAudit.compareTo(BigDecimal.ZERO) == 0) {
                    break;
                }
                AssertUtils.isTrue(feeBudgetEntityMap.containsKey(feeBudgetCode), "费用预算编码" + feeBudgetCode + "对应的预算不存在");
                TpmFeeBudgetEntity budget = feeBudgetEntityMap.get(feeBudgetCode);
                TpmFeeBudgetControlEntity control = controlEntityMap.get(budget.getControlId());
                TpmFeeBudgetDetailsEntity detailsEntity = new TpmFeeBudgetDetailsEntity();
                CrmBeanUtil.copyProperties(budget, detailsEntity);
                detailsEntity.setFeeBudgetCode(feeBudgetCode);
                detailsEntity.setFeeBudgetType(budget.getFeeBudgetType());
                detailsEntity.setOrgType(budget.getOrgType());
                detailsEntity.setBusinessCode(reqVo.getAuditCode());
                detailsEntity.setBusinessLineCode(p.getAuditDetailCode());
                detailsEntity.setBusinessName(reqVo.getAuditName());
                detailsEntity.setYear(String.valueOf(DateUtil.getCurrentYear()));
                detailsEntity.setMonth(String.valueOf(DateUtil.getCurrentMonth()));
                detailsEntity.setFeeBudgetDetailType(FeeBudgetDetailTypeEnum.USE.getCode());
                detailsEntity.setFeeBudgetDetailTypeName(FeeBudgetDetailTypeEnum.USE.getDes());
                detailsEntity.setReduceOrder(reduceOrder);
                detailsEntity.setBudgetSubjectsCode(budget.getBudgetSubjectsCode());
                detailsEntity.setBusinessRemarks(FeeBudgetRemarkEnum.WRITE_OFF_THE_OCCUPIED_BUDGET.getDes());
                detailsEntity.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
                helper.setPublicParamsNull(detailsEntity);
                //根据预算科目的控制类型来处理
                if (StringUtils.equals(BudgetSubjectsControlTypeEnum.NON.getCode(), subjectsEntityMap.get(budget.getBudgetSubjectsCode()).getControlType())) {
                    //如果预算科目不做控制，则完全扣减
                    waitAudit = getBigDecimal(waitAudit, feeBudgetCode, budget, detailsEntity, waitAudit);
                    control.setCanUseAmount(control.getCanUseAmount().subtract(detailsEntity.getFeeAmount().abs()));
                    addDetailsList.add(detailsEntity);
                } else {
                    //如果可用余额大于扣减金额，直接扣减
                    if (budget.getCanUseAmount().compareTo(waitAudit) > 0) {
                        waitAudit = getBigDecimal(waitAudit, feeBudgetCode, budget, detailsEntity, budget.getUsedAmount());
                        addDetailsList.add(detailsEntity);
                        control.setCanUseAmount(control.getCanUseAmount().subtract(detailsEntity.getFeeAmount().abs()));
                    } else if (budget.getCanUseAmount().compareTo(BigDecimal.ZERO) > 0) {
                        //可用余额小于扣减金额但大于0情况下，则将可用金额扣减至0，剩余金额继续进行扣减
                        detailsEntity.setFeeAmount(budget.getCanUseAmount().negate());
                        detailsEntity.setBeforAmount(budget.getCanUseAmount());
                        detailsEntity.setAfterAmount(BigDecimal.ZERO);
                        budget.setUsedAmount(budget.getCanUseAmount().add(budget.getCanUseAmount()));
                        budget.setCanUseAmount(BigDecimal.ZERO);
                        waitAudit = waitAudit.subtract(detailsEntity.getFeeAmount().abs());
                        control.setCanUseAmount(control.getCanUseAmount().subtract(detailsEntity.getFeeAmount().abs()));
                        addDetailsList.add(detailsEntity);
                    }
                }
                reduceOrder++;
            }
            //如果扣减完后，待扣减金额不为0，抛出异常
            AssertUtils.isTrue(waitAudit.compareTo(BigDecimal.ZERO) == 0, "活动明细：" + p.getActDetailCode() + "核销费用超出费用预算");
        }
        //保存预算的修改和新增的预算使用明细
        tpmFeeBudgetService.saveOrUpdateBatch(budgetEntities);
        tpmFeeBudgetControlService.saveOrUpdateBatch(controlEntities);
        tpmFeeBudgetDetailsService.saveOrUpdateBatch(addDetailsList);
    }

    private BigDecimal getBigDecimal(BigDecimal waitAudit, String feeBudgetCode, TpmFeeBudgetEntity budget, TpmFeeBudgetDetailsEntity detailsEntity, BigDecimal usedAmount) {
        detailsEntity.setFeeAmount(waitAudit.negate());
        detailsEntity.setBeforAmount(budget.getCanUseAmount());
        detailsEntity.setAfterAmount(budget.getCanUseAmount().subtract(waitAudit));
        budget.setUsedAmount(usedAmount.add(waitAudit));
        budget.setCanUseAmount(budget.getCanUseAmount().subtract(waitAudit));
        return BigDecimal.ZERO;
    }

    /**
     * 核销提交审批到工作流
     *
     * @param entity
     * @param reqVo
     */
    @Transactional(rollbackFor = Exception.class)
    public void sendToActivity(TpmLiqueurAuditEntity entity, TpmLiqueurAuditReqVo reqVo) {
        if (StringUtils.equals(ActApproveStatusEnum.APPROVING.getCode(), entity.getApproveStatus())) {
            //提交审批
            StartProcessReqVo processReqVo = helper.buildStartProcessData(entity, reqVo);
            String processNo = ActivityUtils.startProcess(processReqVo);
            entity.setProcessCode(processNo);
            this.saveOrUpdate(entity);
        }
    }

    /**
     * 审批通过(返回的是完全核销的活动id集合)
     * 占用预算：当活动完全核销为“是”，且核销金额大于活动申请金额时，在活动提交审批时占用差额部分预算，体现在费用预算明细表中，操作类型为“使用”，备注为“核销占用预算”
     *
     * @param tpmAuditReqVo
     */
    @Transactional(rollbackFor = Exception.class)
    public String auditApproved(TpmAuditReqVo tpmAuditReqVo) {
        //设置状态为审批通过
        AssertUtils.isNotEmpty(tpmAuditReqVo.getId(), "id不能为空");
        TpmLiqueurAuditEntity tpmAuditEntity = this.getById(tpmAuditReqVo.getId());
        //如果当前审批已经是审批通过的状态，则直接返回
        if (StringUtils.equals(ActApproveStatusEnum.APPROVED.getCode(), tpmAuditEntity.getApproveStatus())) {
            return tpmAuditEntity.getId();
        }
        AssertUtils.isTrue(StringUtils.equals(ActApproveStatusEnum.APPROVING.getCode(), tpmAuditEntity.getApproveStatus()), "此核销状态非审批中,无法审批通过！");
        tpmAuditEntity.setApproveStatus(ActApproveStatusEnum.APPROVED.getCode());
        this.updateById(tpmAuditEntity);
        //待新增活动预算使用明细
        List<TpmLiqueurActBudgetTransactionEntity> addTransactions = Lists.newArrayList();
        //修改活动的已核销金额
        TpmLiqueurActEntity tpmLiqueurActEntity = liqueurActMapper.selectOne(new LambdaQueryWrapper<TpmLiqueurActEntity>().eq(TpmLiqueurActEntity::getActCode, tpmAuditEntity.getActCode()));
        //tpmLiqueurActEntity.setAuditTotalAmount(tpmAuditEntity.);
        //获取完全核销的核销明细，进行预算退回操作
        List<TpmLiqueurAuditDetailsEntity> auditDetailsEntities = tpmLiqueurAuditDetailsService.getBaseMapper().selectList(new LambdaQueryWrapper<TpmLiqueurAuditDetailsEntity>()
                .eq(TpmLiqueurAuditDetailsEntity::getAuditCode, tpmAuditEntity.getAuditCode())
                .eq(TpmLiqueurAuditDetailsEntity::getIsAllAudit, GlobalWhetherEnum.YES.getCode()));
        List<String> actDetailCode =Lists.newArrayList();
        Map<String,TpmLiqueurAuditDetailsEntity> auditDetailsEntityMap=Maps.newHashMap();
        auditDetailsEntities.stream().forEach(o->{
            actDetailCode.add(o.getActDetailCode());
            auditDetailsEntityMap.put(o.getActDetailCode(),o);
        });
        if (!CollectionUtil.listNotEmptyNotSizeZero(actDetailCode)) {
            return tpmAuditEntity.getId();
        }
        //根据核销明细列表获取活动明细列表
        List<TpmLiqueurActRegisterDetailEntity> actRegisterDetailEntities = actRegisterDetailService.getBaseMapper().selectList(new LambdaQueryWrapper<TpmLiqueurActRegisterDetailEntity>()
                .in(TpmLiqueurActRegisterDetailEntity::getActDetailCode, actDetailCode));
        //获取活动明细对应的transaction列表
        List<TpmLiqueurActBudgetTransactionEntity> budgetTransactionEntities = liqueurActBudgetTransactionMapper.selectList(new LambdaQueryWrapper<TpmLiqueurActBudgetTransactionEntity>()
                .in(TpmLiqueurActBudgetTransactionEntity::getBusinessLineCode, actDetailCode)
                .eq(TpmLiqueurActBudgetTransactionEntity::getTransactionType, FeeBudgetDetailTypeEnum.USE.getCode())
                .eq(TpmLiqueurActBudgetTransactionEntity::getDelFlag, CrmDelFlagEnum.NORMAL.getCode()));
        //转换活动明细编码-预算列表map
        Map<String, List<TpmLiqueurActBudgetTransactionEntity>> transactionMap = Maps.newHashMap();
        budgetTransactionEntities.forEach(transactionEntity -> {
            List<TpmLiqueurActBudgetTransactionEntity> list = transactionMap.get(transactionEntity.getBusinessLineCode());
            if (!CollectionUtil.listNotEmptyNotSizeZero(list)) {
                list = Lists.newArrayList();
            }
            list.add(transactionEntity);
            transactionMap.put(transactionEntity.getBusinessLineCode(), list);
        });
        //获取transaction对应的预算
        List<TpmLiqueurActBudgetEntity> tpmLiqueurActBudgetEntities = liqueurActBudgetMapper.selectList(new LambdaQueryWrapper<TpmLiqueurActBudgetEntity>()
                //匹配活动预算编码
                .in(TpmLiqueurActBudgetEntity::getActBudgetCode, budgetTransactionEntities.stream().map(TpmLiqueurActBudgetTransactionEntity::getActBudgetCode).collect(Collectors.toList()))
                .eq(TpmLiqueurActBudgetEntity::getDelFlag, CrmDelFlagEnum.NORMAL.getCode()));
        Map<String, TpmLiqueurActBudgetEntity> actBudgetEntityMap = tpmLiqueurActBudgetEntities.stream().collect(Collectors.toMap(TpmLiqueurActBudgetEntity::getActBudgetCode, Function.identity()));
        //检查是否已完全核销，如果已完全核销则退还活动预算的剩余部分
        for (TpmLiqueurActRegisterDetailEntity actDetail : actRegisterDetailEntities) {
            actDetail.setIsAllAudit(GlobalWhetherEnum.YES.getCode());
            if (actDetail.getApplyAmount().compareTo(actDetail.getAuditAmount()) > 0) {
                AtomicReference<BigDecimal> needRollBackAmount = new AtomicReference<>(actDetail.getApplyAmount().subtract(actDetail.getAuditAmount()));
                if (needRollBackAmount.get().compareTo(BigDecimal.ZERO) == 0) {
                    continue;
                }
                TpmLiqueurAuditDetailsEntity auditDetailsEntity = auditDetailsEntityMap.get(actDetail.getActDetailCode());
                //申请金额大于已核销金额，退回预算给活动预算
                List<TpmLiqueurActBudgetTransactionEntity> transactions = transactionMap.get(actDetail.getActDetailCode());
                AssertUtils.isTrue(CollectionUtil.listNotEmptyNotSizeZero(transactions), "活动明细" + actDetail.getActDetailCode() + "没有找到对应的预算使用详情，无法退还金额！");
                //降序排列
                List<TpmLiqueurActBudgetTransactionEntity> transactionEntities = transactions.stream().filter(o -> o.getFeeAmount().compareTo(BigDecimal.ZERO) != 0).sorted(Comparator.comparing(TpmLiqueurActBudgetTransactionEntity::getReduceOrder).reversed()).collect(Collectors.toList());
                //降序排列
                for (TpmLiqueurActBudgetTransactionEntity transactionEntity : transactionEntities) {
                    if (needRollBackAmount.get().compareTo(BigDecimal.ZERO) == 0) {
                        break;
                    }
                    //获取transaction对应的预算使用明细
                    if (actBudgetEntityMap.containsKey(transactionEntity.getActBudgetCode())) {
                        BigDecimal used = transactionEntity.getFeeAmount().abs();
                        TpmLiqueurActBudgetTransactionEntity newTransaction = CrmBeanUtil.copy(transactionEntity, TpmLiqueurActBudgetTransactionEntity.class);
                        if (needRollBackAmount.get().compareTo(used) > 0) {
                            needRollBackAmount.set(needRollBackAmount.get().subtract(used));
                            newTransaction.setFeeAmount(used);
                        } else {
                            newTransaction.setFeeAmount(needRollBackAmount.get());
                            needRollBackAmount.set(BigDecimal.ZERO);
                        }
                        helper.setPublicParamsNull(newTransaction);
                        newTransaction.setTransactionType(FeeBudgetDetailTypeEnum.RETURN_BACK.getCode());
                        newTransaction.setTransactionTypeName(FeeBudgetDetailTypeEnum.RETURN_BACK.getDes());
                        newTransaction.setBusinessType(LiqueurActBudgetBusinessTypeEnum.AUDIT.getCode());
                        newTransaction.setBusinessRemarks(LiqueurActBudgetRemarkEnum.WRITE_OFF_AND_RETURN.getDes());
                        newTransaction.setRemarks("完全核销退回活动预算");
                        newTransaction.setBusinessCode(tpmAuditEntity.getAuditCode());
                        newTransaction.setBusinessCode(auditDetailsEntity.getAuditDetailCode());
                        addTransactions.add(newTransaction);
                        //修改活动预算信息
                        TpmLiqueurActBudgetEntity actBudgetEntity = actBudgetEntityMap.get(transactionEntity.getActBudgetCode());
                        actBudgetEntity.setCanUseAmount(actBudgetEntity.getCanUseAmount().add(newTransaction.getFeeAmount()));
                        tpmLiqueurActEntity.setCanUseAmount(tpmLiqueurActEntity.getCanUseAmount().add(newTransaction.getFeeAmount()));
                    }
                }
            }
        }
        //保存活动预算，新增预算使用明细
        tpmLiqueurActBudgetService.saveOrUpdateBatch(tpmLiqueurActBudgetEntities);
        liqueurActBudgetTransactionService.saveBatch(addTransactions);
        liqueurActMapper.updateById(tpmLiqueurActEntity);
        actRegisterDetailService.saveOrUpdateBatch(actRegisterDetailEntities);
        return tpmAuditEntity.getId();
    }

    /**
     * 流程驳回/撤销
     *
     * @param reqVo
     */
    @Transactional(rollbackFor = Exception.class)
    public void rejectAndInterrupt(TpmAuditReqVo reqVo) {
        //查询本次核销主表，修改状态
        AssertUtils.isNotEmpty(reqVo.getId(), "id不能为空");
        TpmLiqueurAuditEntity tpmAuditEntity = this.getById(reqVo.getId());
        //如果当前审批已经是审批驳回/撤销的状态，则直接返回
        if (Objects.isNull(tpmAuditEntity) || StringUtils.equals(ActApproveStatusEnum.REJECTED.getCode(), tpmAuditEntity.getApproveStatus()) || StringUtils.equals(ActApproveStatusEnum.INTERRUPT.getCode(), tpmAuditEntity.getApproveStatus())) {
            return;
        }
        AssertUtils.isTrue(StringUtils.equals(ActApproveStatusEnum.APPROVING.getCode(), tpmAuditEntity.getApproveStatus()), "此核销状态非审批中,无法驳回/撤销！");
        tpmAuditEntity.setApproveStatus(reqVo.getApproveStatus());
        this.updateById(tpmAuditEntity);
        LiqueurAuditVo auditVo = new LiqueurAuditVo();
        //查询所有核销明细
        List<TpmLiqueurAuditDetailsEntity> auditDetailsEntities = tpmLiqueurAuditDetailsService.getBaseMapper().selectList(new LambdaQueryWrapper<TpmLiqueurAuditDetailsEntity>()
                .eq(TpmLiqueurAuditDetailsEntity::getAuditCode, tpmAuditEntity.getAuditCode()));
        Set<String> actDetailCodes = auditDetailsEntities.stream().map(TpmLiqueurAuditDetailsEntity::getActDetailCode).collect(Collectors.toSet());
        Set<String> auditDetailCodes = auditDetailsEntities.stream().map(TpmLiqueurAuditDetailsEntity::getAuditDetailCode).collect(Collectors.toSet());
        helper.convertActRegisterDetail(actDetailCodes, auditVo);
        helper.convertTransactionMap(auditDetailCodes, auditVo);
        helper.convertActBudgetMap(auditVo.getTransactionEntities().stream().map(TpmLiqueurActBudgetTransactionEntity::getActBudgetCode).collect(Collectors.toSet()), auditVo);
        helper.convertFeeBudgetDetailMap(auditDetailCodes, auditVo);
        helper.convertFeeBudgetData(auditVo.getFeeBudgetDetailsEntities().stream().map(TpmFeeBudgetDetailsEntity::getFeeBudgetCode).collect(Collectors.toSet()), auditVo);
        //循环核销明细，进行费用回退
        List<TpmFeeBudgetDetailsEntity> newFeeBudgetDetailsEntityList=Lists.newArrayList();
        List<TpmLiqueurActBudgetTransactionEntity> newTransactionEntityList=Lists.newArrayList();
        for (TpmLiqueurAuditDetailsEntity auditDetail : auditDetailsEntities) {
            BigDecimal needBackAmount = auditDetail.getAmount();
            //查询该核销明细是否有占用过费用预算，如果有占用费用预算则退回费用预算，删除占用记录
            List<TpmFeeBudgetDetailsEntity> feeBudgetDetailsEntityList = auditVo.getFeeBudgetDetailMap().get(auditDetail.getAuditDetailCode());
            if (CollectionUtil.listNotEmptyNotSizeZero(feeBudgetDetailsEntityList)) {
                for (TpmFeeBudgetDetailsEntity feeDetail : feeBudgetDetailsEntityList) {
                    if(feeDetail.getFeeAmount().compareTo(BigDecimal.ZERO)!=0){
                        TpmFeeBudgetDetailsEntity copy = CrmBeanUtil.copy(feeDetail, TpmFeeBudgetDetailsEntity.class);
                        helper.setPublicParamsNull(copy);
                        TpmFeeBudgetEntity feeBudgetEntity = auditVo.getFeeBudgetEntityMap().get(feeDetail.getFeeBudgetCode());
                        copy.setBeforAmount(feeBudgetEntity.getCanUseAmount());
                        copy.setFeeAmount(feeDetail.getFeeAmount().abs());
                        copy.setAfterAmount(feeBudgetEntity.getCanUseAmount().add(feeDetail.getFeeAmount().abs()));
                        copy.setFeeBudgetDetailType(FeeBudgetDetailTypeEnum.RETURN_BACK.getCode());
                        copy.setFeeBudgetDetailTypeName(FeeBudgetDetailTypeEnum.RETURN_BACK.getDes());
                        copy.setBusinessRemarks(FeeBudgetRemarkEnum.WRITE_OFF_AND_RETURN.getDes());
                        AssertUtils.isNotNull(feeBudgetEntity, "核销明细" + auditDetail.getActDetailCode() + "需要退还的费用预算" + feeDetail.getFeeBudgetCode() + "不存在");
                        //退还费用预算金额，控制维度金额
                        feeBudgetEntity.setCanUseAmount(feeBudgetEntity.getCanUseAmount().add(feeDetail.getFeeAmount().abs()));
                        TpmFeeBudgetControlEntity feeBudgetControlEntity = auditVo.getFeeBudgetControlEntityMap().get(feeBudgetEntity.getControlId());
                        feeBudgetControlEntity.setCanUseAmount(feeBudgetControlEntity.getCanUseAmount().add(feeDetail.getFeeAmount().abs()));
                        needBackAmount = needBackAmount.subtract(feeDetail.getFeeAmount().abs());
                        feeDetail.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
                        newFeeBudgetDetailsEntityList.add(copy);
                    }
                }
            }
            //查询该核销明细是否有占用过活动预算，如果有占用活动预算则退回活动，删除占用记录
            List<TpmLiqueurActBudgetTransactionEntity> transactionEntityList = auditVo.getTransactionMap().get(auditDetail.getAuditDetailCode());
            if (CollectionUtil.listNotEmptyNotSizeZero(transactionEntityList)) {
                for (TpmLiqueurActBudgetTransactionEntity transactionEntity : transactionEntityList) {
                    TpmLiqueurActBudgetEntity actBudgetEntity = auditVo.getActBudgetEntityMap().get(transactionEntity.getActBudgetCode());
                    TpmLiqueurActBudgetTransactionEntity copy = CrmBeanUtil.copy(transactionEntity, TpmLiqueurActBudgetTransactionEntity.class);
                    helper.setPublicParamsNull(copy);
                    copy.setFeeAmount(transactionEntity.getFeeAmount().abs());
                    copy.setTransactionType(FeeBudgetDetailTypeEnum.RETURN_BACK.getCode());
                    copy.setTransactionTypeName(FeeBudgetDetailTypeEnum.RETURN_BACK.getDes());
                    copy.setBusinessType(LiqueurActBudgetBusinessTypeEnum.AUDIT.getCode());
                    copy.setBusinessRemarks(LiqueurActBudgetRemarkEnum.REJECT_AND_INTERRUPT_RETURN_BUDGET.getDes());
                    AssertUtils.isNotNull(actBudgetEntity, "核销明细" + auditDetail.getActDetailCode() + "需要退还的活动预算" + transactionEntity.getActBudgetCode() + "不存在");
                    TpmLiqueurActEntity actEntity = auditVo.getActEntityMap().get(actBudgetEntity.getActCode());
                    //退还活动预算金额
                    actBudgetEntity.setCanUseAmount(actBudgetEntity.getCanUseAmount().add(transactionEntity.getFeeAmount().abs()));
                    actBudgetEntity.setAuditAmount(actBudgetEntity.getAuditAmount().subtract(transactionEntity.getFeeAmount().abs()));
                    //退还活动详情可用余额
                    actEntity.setCanUseAmount(actEntity.getCanUseAmount().add(transactionEntity.getFeeAmount().abs()));
                    actEntity.setAuditTotalAmount(actEntity.getAuditTotalAmount().subtract(transactionEntity.getFeeAmount().abs()));
                    needBackAmount = needBackAmount.subtract(transactionEntity.getFeeAmount().abs());
                    transactionEntity.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
                    newTransactionEntityList.add(copy);
                }
            }
            //查询该核销明细对应的活动明细，退还金额到活动明细
            TpmLiqueurActRegisterDetailEntity actRegisterDetailEntity = auditVo.getActRegisterDetailEntityMap().get(auditDetail.getActDetailCode());
            AssertUtils.isNotNull(actRegisterDetailEntity, "核销明细" + auditDetail.getActDetailCode() + "需要退还的活动明细" + actRegisterDetailEntity.getActDetailCode() + "不存在");
            actRegisterDetailEntity.setAuditAmount(actRegisterDetailEntity.getAuditAmount().subtract(auditDetail.getAmount()));
        }
        //保存修改记录
        if(CollectionUtils.isNotEmpty(newTransactionEntityList)){
            auditVo.getTransactionEntities().addAll(newTransactionEntityList);
        }
        if(CollectionUtils.isNotEmpty(newFeeBudgetDetailsEntityList)){
            auditVo.getFeeBudgetDetailsEntities().addAll(newFeeBudgetDetailsEntityList);
        }
        tpmFeeBudgetDetailsService.saveOrUpdateBatch(auditVo.getFeeBudgetDetailsEntities());
        tpmFeeBudgetControlService.saveOrUpdateBatch(auditVo.getFeeBudgetControlEntities());
        tpmFeeBudgetService.saveOrUpdateBatch(auditVo.getFeeBudgetEntities());
        tpmLiqueurActBudgetService.saveOrUpdateBatch(auditVo.getTpmLiqueurActBudgetEntities());
        liqueurActBudgetTransactionService.saveOrUpdateBatch(auditVo.getTransactionEntities());
        actRegisterDetailService.saveOrUpdateBatch(auditVo.getActRegisterDetailEntities());
        tpmLiqueurActService.saveOrUpdateBatch(auditVo.getActEntities());
    }

    /**
     * 更新核销明细数据
     *
     * @param reqVo
     * @param tpmAuditEntity
     */
    public void updateAuditDetail(TpmLiqueurAuditReqVo reqVo, TpmLiqueurAuditEntity tpmAuditEntity) {
        List<TpmLiqueurAuditDetailsReqVo> detailVos = reqVo.getDetailsVos();
        //待保存核销明细数据
        List<TpmLiqueurAuditDetailsEntity> tpmAuditDetailEntities = Lists.newArrayList();
        //待保存核销资料数据
        List<TpmLiqueurAuditFileEntity> tpmLiqueurAuditFileEntities = Lists.newArrayList();
        List<String> auditDetailIds = Lists.newArrayList();
        List<String> fileIds = Lists.newArrayList();
        for (TpmLiqueurAuditDetailsReqVo o : detailVos) {
            AssertUtils.isNotNull(o.getActDetailCode(), "活动明细编码不存在");
            o.setAuditCode(tpmAuditEntity.getAuditCode());
            //生产核销明细编码
            o.setAuditDetailCode(CodeUtil.createOneCode(CrmCodeRuleConstants.AUDIT_DETAIL));
            if (Objects.isNull(o.getFeeUsed())) {
                o.setFeeUsed(BigDecimal.ZERO);
            }
            if (StringUtils.isBlank(o.getIsAllFeeUsed())) {
                o.setIsAllFeeUsed(GlobalWhetherEnum.NO.getCode());
            }
            if (StringUtils.isNotEmpty(o.getId())) {
                auditDetailIds.add(o.getId());
            }
            tpmAuditDetailEntities.add(CrmBeanUtil.copy(o, TpmLiqueurAuditDetailsEntity.class));
            //核销资料
            List<TpmLiqueurAuditFileRespVo> auditFileRespVos = o.getFileVos();
            if (CollectionUtil.listNotEmptyNotSizeZero(auditFileRespVos)) {
                for (TpmLiqueurAuditFileRespVo file : auditFileRespVos) {
                    AssertUtils.isNotNull(file.getAuditFileType(), "核销资料类型不能为空");
                    if (file.getAuditFileType() == 1) {
                        AssertUtils.isNotNull(file.getExampleCode(), "核销采集示例编码不能为空");
                    }
                    file.setAuditCode(tpmAuditEntity.getAuditCode());
                    file.setAuditDetailCode(o.getAuditDetailCode());
                    tpmLiqueurAuditFileEntities.add(CrmBeanUtil.copy(file, TpmLiqueurAuditFileEntity.class));
                    if (StringUtils.isNotEmpty(file.getId())) {
                        fileIds.add(file.getId());
                    }
                }
            }
        }
        //删除需要删除的核销明细
        tpmLiqueurAuditDetailsService.getBaseMapper().delete(new LambdaQueryWrapper<TpmLiqueurAuditDetailsEntity>()
                .eq(TpmLiqueurAuditDetailsEntity::getAuditCode, tpmAuditEntity.getAuditCode()).notIn(CollectionUtils.isNotEmpty(auditDetailIds), TpmLiqueurAuditDetailsEntity::getId, auditDetailIds));
        //删除需要删除的核销资料
        tpmLiqueurAuditFileService.getBaseMapper().delete(new LambdaQueryWrapper<TpmLiqueurAuditFileEntity>()
                .eq(TpmLiqueurAuditFileEntity::getAuditCode, tpmAuditEntity.getAuditCode()).notIn(CollectionUtils.isNotEmpty(fileIds), TpmLiqueurAuditFileEntity::getId, fileIds));
        tpmLiqueurAuditFileService.saveOrUpdateBatch(tpmLiqueurAuditFileEntities);
        tpmLiqueurAuditDetailsService.saveOrUpdateBatch(tpmAuditDetailEntities);
    }

    /**
     * 更新核销附加信息数据
     *
     * @param reqVo
     * @param entity
     */
    public void updateAuditAttach(TpmLiqueurAuditReqVo reqVo, TpmLiqueurAuditEntity entity) {
        List<TpmLiqueurAuditAttachReqVo> attachReqVos = reqVo.getAttachVos();
        Map<String, TpmLiqueurAuditDetailsReqVo> map = Maps.newHashMap();
        Map<String, String> payTypeTypeMap = helper.getPayTypeTypeMap(TpmGlobalDictConstants.PAY_TYPE, TpmGlobalDictConstants.PAY_TYPE_TYPE);
        reqVo.getDetailsVos().forEach(detail -> {
            map.put(detail.getActDetailCode(), detail);
        });
        //根据投入类型获取费用科目信息
        List<String> categories = Lists.newArrayList();
        attachReqVos.forEach(detail -> {
            if (StringUtils.isNotEmpty(detail.getCategoriesCode())) {
                categories.add(detail.getCategoriesCode());
            }
        });
        List<TpmCostTypeCategoriesRespVo> categoriesRespVos = categoriesService.getCategoriesSubjectInfo(categories);
        Map<String, TpmCostTypeCategoriesRespVo> categoriesRespVoHashMap = Maps.newHashMap();
        if (CollectionUtil.listNotEmptyNotSizeZero(categoriesRespVos)) {
            categoriesRespVos.forEach(cate -> {
                categoriesRespVoHashMap.put(cate.getCategoriesCode(), cate);
            });
        }
        if (CollectionUtils.isNotEmpty(attachReqVos)) {
            attachReqVos.forEach(attach -> {
                TpmLiqueurAuditDetailsReqVo detailsReqVo = map.get(attach.getActDetailCode());
                TpmCostTypeCategoriesRespVo tpmCostTypeCategoriesRespVo = categoriesRespVoHashMap.get(attach.getCategoriesCode());
                if(ObjectUtils.isNotNull(tpmCostTypeCategoriesRespVo)){
                    attach.setAuditSubjectCode(tpmCostTypeCategoriesRespVo.getBudgetSubjectsCode());
                    attach.setAuditSubjectName(tpmCostTypeCategoriesRespVo.getBudgetSubjectsName());
                }
                attach.setAuditCode(entity.getAuditCode());
                attach.setActCode(entity.getActCode());
                attach.setFineCode(entity.getFineCode());
                attach.setActName(reqVo.getActName());
                attach.setFineName(reqVo.getFineName());
                attach.setAccountAmount(BigDecimal.ZERO);
                attach.setAuditDetailCode(detailsReqVo.getAuditDetailCode());
                attach.setIsAllAudit(detailsReqVo.getIsAllAudit());
                attach.setIsAllFeeUsed(detailsReqVo.getIsAllFeeUsed());
                attach.setFeeUsed(detailsReqVo.getFeeUsed());
                attach.setCreateDate(detailsReqVo.getCreateDate());
                attach.setCreateDateSecond(detailsReqVo.getCreateDateSecond());
                attach.setEndDate(detailsReqVo.getEndData());
                attach.setEndDateSecond(detailsReqVo.getEndDateSecond());
                if (StringUtils.isEmpty(attach.getAuditDetailAttachCode())) {
                    attach.setAuditDetailAttachCode(CodeUtil.createOneCode(CrmCodeRuleConstants.AUDIT_DETAIL_ATTACH));
                }
                if (StringUtils.isNotEmpty(attach.getActDetailName())) {
                    attach.setActDetailName(detailsReqVo.getActDetailName());
                }
                //更新payTypeType
                if (StringUtils.isNotEmpty(attach.getPayType())) {
                    attach.setPayTypeType(payTypeTypeMap.get(attach.getPayType()));
                }
            });
            List<String> auditAttachIds = attachReqVos.stream().filter(o -> StringUtils.isNotEmpty(o.getId())).map(TpmLiqueurAuditAttachReqVo::getId).collect(Collectors.toList());
            //先将数据库需要删除数据删除
            auditAttachService.getBaseMapper().delete(Wrappers.<TpmLiqueurAuditAttachEntity>lambdaQuery()
                    .eq(TpmLiqueurAuditAttachEntity::getAuditCode, entity.getAuditCode())
                    .notIn(CollectionUtils.isNotEmpty(auditAttachIds), TpmLiqueurAuditAttachEntity::getId, auditAttachIds));
            auditAttachService.saveOrUpdateBatch(CrmBeanUtil.copyList(attachReqVos, TpmLiqueurAuditAttachEntity.class));
        } else {
            tpmLiqueurAuditFileService.getBaseMapper().delete(Wrappers.<TpmLiqueurAuditFileEntity>lambdaQuery()
                    .eq(TpmLiqueurAuditFileEntity::getAuditCode, reqVo.getAuditCode()));
        }
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveMaterials() {
    }
}
