package com.biz.crm.liqueuract.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.GlobalWhetherEnum;
import com.biz.crm.liqueuract.service.TpmLiqueurActService;
import com.biz.crm.nebular.activiti.act.ActivitiCallBackVo;
import com.biz.crm.nebular.mdm.common.BaseTreeRespVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.tpm.act.req.ActGetCategoriesByBudgetReqVo;
import com.biz.crm.nebular.tpm.act.req.ActGetCustomerCodeByOrgCodeReqVo;
import com.biz.crm.nebular.tpm.costtypefine.req.TpmCostDutyOrgReqVo;
import com.biz.crm.nebular.tpm.costtypefine.req.TpmCostTypeFineReqVo;
import com.biz.crm.nebular.tpm.costtypefine.resp.TpmCostTypeFineRespVo;
import com.biz.crm.nebular.tpm.feebudget.resp.TpmFeeBudgetControlRespVo;
import com.biz.crm.nebular.tpm.liqueuract.req.TpmLiqueurActReqVo;
import com.biz.crm.nebular.tpm.liqueuract.resp.TpmLiqueurActRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.Result;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author maoshen
 * @date 2021/3/3.
 */
@Slf4j
@RestController
@RequestMapping("/tpmLiqueurActController")
@Api(tags = "酒类tpm 活动主表")
public class TpmLiqueurActController {

    @Autowired
    private TpmLiqueurActService tpmLiqueurActService;

    /**
     * 列表
     * @param tpmLiqueurActReqVo req
     * @return
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<TpmLiqueurActRespVo>> list(@RequestBody TpmLiqueurActReqVo tpmLiqueurActReqVo) {
        PageResult<TpmLiqueurActRespVo> result= tpmLiqueurActService.findList(tpmLiqueurActReqVo);
        return Result.ok(result);
    }

    /**
     * 查看
     * @param id id
     * @return
     */
    @ApiOperation(value = "查询")
    @GetMapping("/query")
    @CrmLog
    public Result<TpmLiqueurActRespVo> query(@RequestParam(value = "id", required = false) String id) {
        TpmLiqueurActRespVo tpmLiqueurActRespVo = tpmLiqueurActService.query(id);
        return Result.ok(tpmLiqueurActRespVo);
    }


    /**
     * 新增 活动
     * @param tpmLiqueurActReqVo
     * @return
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody TpmLiqueurActReqVo tpmLiqueurActReqVo){
        UserRedis user = UserUtils.getUser();
        tpmLiqueurActReqVo.setLockUserName(user.getUsername());
        tpmLiqueurActService.save(tpmLiqueurActReqVo);
        return Result.ok("操作成功");
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody TpmLiqueurActReqVo tpmLiqueurActReqVo) {
        UserRedis user = UserUtils.getUser();
        tpmLiqueurActReqVo.setLockUserName(user.getUsername());
        tpmLiqueurActService.update(tpmLiqueurActReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        tpmLiqueurActService.deleteBatch(ids);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody List<String> ids) {
        tpmLiqueurActService.enableBatch(ids);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody List<String> ids) {
        tpmLiqueurActService.disableBatch(ids);
        return Result.ok("禁用成功");
    }
    /**
     * 活动关闭
     */
    @ApiOperation(value = "活动关闭")
    @PostMapping("/closed")
    @CrmLog
    public Result closed(@RequestBody List<String> ids) {
        TpmLiqueurActReqVo tpmLiqueurActReqVo=new TpmLiqueurActReqVo();
        if(CollectionUtils.isNotEmpty(ids)){
            tpmLiqueurActReqVo.setIds(ids);
        }
        UserRedis user = UserUtils.getUser();
        tpmLiqueurActReqVo.setLockUserName(user.getUsername());
        tpmLiqueurActService.closed(tpmLiqueurActReqVo);
        return Result.ok("活动关闭成功");
    }

    /**
     * 提交审批
     */
    @ApiOperation(value = "提交审批")
    @PostMapping("/approve")
    @CrmLog
    public Result approve(@RequestBody TpmLiqueurActReqVo tpmLiqueurActReqVo) {
        UserRedis user = UserUtils.getUser();
        tpmLiqueurActReqVo.setLockUserName(user.getUsername());
        tpmLiqueurActService.approve(tpmLiqueurActReqVo);
        return Result.ok("提交审批成功");
    }
    /**
     * 审批通过
     */
    @ApiOperation(value = "审批通过")
    @PostMapping("/approved")
    @CrmLog
    public Result approved(@RequestBody  TpmLiqueurActReqVo tpmLiqueurActReqVo) {
        tpmLiqueurActService.approved(tpmLiqueurActReqVo);
        return Result.ok("审批通过操作成功");
    }

    /**
     * 审批驳回
     */
    @ApiOperation(value = "审批驳回")
    @PostMapping("/reject")
    @CrmLog
    public Result reject(@RequestBody  TpmLiqueurActReqVo tpmLiqueurActReqVo) {
        tpmLiqueurActService.reject(tpmLiqueurActReqVo);
        return Result.ok("审批驳回操作成功");
    }

    /**
     * 审批驳回
     */
    @ApiOperation(value = "流程追回")
    @PostMapping("/interrupt")
    @CrmLog
    public Result interrupt(@RequestBody  TpmLiqueurActReqVo tpmLiqueurActReqVo) {
        tpmLiqueurActService.interrupt(tpmLiqueurActReqVo);
        return Result.ok("流程追回操作成功");
    }







    /**
     * 根据 登录 人 和是否选择 跨组织 来 获取组织List
     */
    @ApiOperation(value = "据 登录 人 和是否选择 跨组织 来 获取组织List")
    @PostMapping("/findOrgMapByCodeAndIsCross")
    @CrmLog
    public Result<List> findOrgMapByCodeAndIsCross(@RequestBody TpmCostDutyOrgReqVo tpmCostDutyOrgReqVo){
        AssertUtils.isNotEmpty(tpmCostDutyOrgReqVo.getFineCode(),"活动类型编码不能为空");
        AssertUtils.isNotEmpty(tpmCostDutyOrgReqVo.getIsQueryOrgTree(),"是否查询组织树不能为空");
        if(StringUtils.equals(GlobalWhetherEnum.YES.getCode(),tpmCostDutyOrgReqVo.getIsQueryOrgTree())){
            //如果前端需要查询树结构
            List<BaseTreeRespVo> treeList = tpmLiqueurActService.getOrgTree(tpmCostDutyOrgReqVo);
            return Result.ok(treeList);
        }
        List<MdmOrgRespVo> orgList = tpmLiqueurActService.getOrgList(tpmCostDutyOrgReqVo);
        return Result.ok(orgList);
    }

    @ApiOperation(value = "活动管理新增下拉选择活动类型接口")
    @PostMapping("/getFineList")
    @CrmLog
    public Result<List<TpmCostTypeFineRespVo>> getFineList(@RequestBody ActGetCategoriesByBudgetReqVo reqVo){
        List<TpmCostTypeFineRespVo> list = tpmLiqueurActService.getFineList(reqVo);
        return Result.ok(list);
    }

    @ApiOperation(value = "据组织 来 获取客户List")
    @PostMapping("/findCusMapByOrgCode")
    @CrmLog
    public Result<List<MdmCustomerMsgRespVo>>findCusMapByOrgCode(@RequestBody ActGetCustomerCodeByOrgCodeReqVo reqVo){
        List<MdmCustomerMsgRespVo> list = tpmLiqueurActService.getCustomerMsgByOrgCodes(reqVo);
        return Result.ok(list);
    }


    @ApiOperation(value = "活动新增可选预算控制维度")
    @PostMapping("/findBudgetController")
    @CrmLog
    public Result<PageResult<TpmFeeBudgetControlRespVo>> findBudgetController(@RequestBody TpmLiqueurActReqVo reqVo){
        PageResult<TpmFeeBudgetControlRespVo> result = tpmLiqueurActService.findBudgetController(reqVo);
        return Result.ok(result);
    }

    @ApiOperation(value = "工作流回调接口")
    @PostMapping("/activityCallBack")
    @CrmLog
    public Result callback(@RequestBody ActivitiCallBackVo activitiCallBackVo) {
        tpmLiqueurActService.activityCallBack(activitiCallBackVo);
        return Result.ok("活动审批回调成功");
    }
}
