package com.biz.crm.liqueuract.controller;

import com.biz.crm.liqueuract.service.ITpmLiqueurActRegisterService;
import com.biz.crm.nebular.activiti.act.ActivitiCallBackVo;
import com.biz.crm.nebular.tpm.costtypecategories.req.TpmCostTypeCategoriesReqVo;
import com.biz.crm.nebular.tpm.costtypecategories.resp.TpmCostTypeCategoriesRespVo;
import com.biz.crm.nebular.tpm.feebudget.resp.TpmFeeBudgetControlRespVo;
import com.biz.crm.nebular.tpm.liqueuract.req.TpmLiqueurActBudgetReqVo;
import com.biz.crm.nebular.tpm.liqueuract.req.TpmLiqueurActRegisterDetailReqVo;
import com.biz.crm.nebular.tpm.liqueuract.req.TpmLiqueurActRegisterReqVo;
import com.biz.crm.nebular.tpm.liqueuract.resp.TpmLiqueurActRegisterRespVo;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import com.biz.crm.aop.CrmLog;

import java.util.List;

/**
 * 酒类活动明细主表;
 *
 * @author lf
 * @date 2021-03-09 13:57:21
 */
@Slf4j
@RestController
@RequestMapping("/tpmLiqueurActRegisterController")
@Api(tags = "酒类活动登记api接口")
public class TpmLiqueurActRegisterController {
    @Autowired
    private ITpmLiqueurActRegisterService actRegisterService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<TpmLiqueurActRegisterRespVo>> list(@RequestBody TpmLiqueurActRegisterReqVo tpmLiqueurActRegisterReqVo) {
        PageResult<TpmLiqueurActRegisterRespVo> result= actRegisterService.findList(tpmLiqueurActRegisterReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @GetMapping("/query")
    @CrmLog
    public Result<TpmLiqueurActRegisterRespVo> query(@RequestParam(value = "id", required = true) String id) {
        TpmLiqueurActRegisterRespVo respVo= actRegisterService.query(id);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody TpmLiqueurActRegisterReqVo tpmLiqueurActRegisterReqVo) {
        UserRedis user = UserUtils.getUser();
        tpmLiqueurActRegisterReqVo.setLockUserName(user.getUsername());
        actRegisterService.save(tpmLiqueurActRegisterReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody TpmLiqueurActRegisterReqVo tpmLiqueurActRegisterReqVo) {
        UserRedis user = UserUtils.getUser();
        tpmLiqueurActRegisterReqVo.setLockUserName(user.getUsername());
        actRegisterService.update(tpmLiqueurActRegisterReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        actRegisterService.deleteBatch(ids);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody List<String> ids) {
        actRegisterService.enableBatch(ids);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody List<String> ids) {
        actRegisterService.disableBatch(ids);
        return Result.ok("禁用成功");
    }
    /**
     * 提交审批
     */
    @ApiOperation(value = "提交审批")
    @PostMapping("/approve")
    @CrmLog
    public Result approve(@RequestBody TpmLiqueurActRegisterReqVo reqVo) {
        UserRedis user = UserUtils.getUser();
        reqVo.setLockUserName(user.getUsername());
        actRegisterService.approve(reqVo);
        return Result.ok("提交审批成功");
    }
    @ApiOperation(value = "工作流回调接口")
    @PostMapping("/activityCallBack")
    @CrmLog
    public Result callback(@RequestBody ActivitiCallBackVo activitiCallBackVo) {
        actRegisterService.activityCallBack(activitiCallBackVo);
        return Result.ok("活动审批回调成功");
    }

    @ApiOperation(value = "活动登记-活动明细费用预算下拉选择接口(传入活动编码:actCode)")
    @PostMapping("/findBudgetByActCode")
    @CrmLog
    public Result<List<TpmFeeBudgetControlRespVo>> findBudgetByActCode(@RequestBody TpmLiqueurActBudgetReqVo reqVo) {
        //这里要过滤掉活动预算可用为零的预算(根据预算科目上的控制类型controlType判断,如果控制类型为不控制,可用余额小于零也可以返回给前端,其他必须大于零)
        List<TpmFeeBudgetControlRespVo> actBudgetRespVos = actRegisterService.findBudgetByActCode(reqVo);
        return Result.ok(actBudgetRespVos);
    }

    @ApiOperation(value = "活动登记-投入类型下拉选择接口(根据预算科目编码集合查询投入类型)")
    @PostMapping("/findCategoriesBySubjectCodes")
    @CrmLog
    public Result<PageResult<TpmCostTypeCategoriesRespVo>> findCategoriesBySubjectCodes(@RequestBody TpmLiqueurActRegisterDetailReqVo reqVo) {
        //分页返回投入类型(活动大类)集合
        PageResult<TpmCostTypeCategoriesRespVo> categoriesBySubjectCodes = actRegisterService.findCategoriesBySubjectCodes(reqVo);
        return Result.ok(categoriesBySubjectCodes);
    }
}
