package com.biz.crm.liqueuract.controller;

import com.biz.crm.liqueuract.service.ITpmLiqueurActRegisterDetailAttachService;
import com.biz.crm.nebular.tpm.liqueuract.req.TpmLiqueurActRegisterDetailAttachReqVo;
import com.biz.crm.nebular.tpm.liqueuract.resp.TpmLiqueurActRegisterDetailAttachRespVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;

import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import com.biz.crm.aop.CrmLog;

/**
 * 酒类活动附件信息;
 *
 * @author lf
 * @date 2021-03-08 18:33:23
 */
@Slf4j
@RestController
@RequestMapping("/tpmliqueuractdetailattach")
@Api(tags = "酒类活动附件信息;")
public class TpmLiqueurActRegisterDetailAttachController {
    @Autowired
    private ITpmLiqueurActRegisterDetailAttachService tpmLiqueurActDetailAttachService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<TpmLiqueurActRegisterDetailAttachRespVo>> list(@RequestBody TpmLiqueurActRegisterDetailAttachReqVo tpmLiqueurActRegisterDetailAttachReqVo) {
        PageResult<TpmLiqueurActRegisterDetailAttachRespVo> result=tpmLiqueurActDetailAttachService.findList(tpmLiqueurActRegisterDetailAttachReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    public Result<TpmLiqueurActRegisterDetailAttachRespVo> query(@RequestBody TpmLiqueurActRegisterDetailAttachReqVo tpmLiqueurActRegisterDetailAttachReqVo) {
        TpmLiqueurActRegisterDetailAttachRespVo respVo=tpmLiqueurActDetailAttachService.query(tpmLiqueurActRegisterDetailAttachReqVo);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody TpmLiqueurActRegisterDetailAttachReqVo tpmLiqueurActRegisterDetailAttachReqVo) {
        tpmLiqueurActDetailAttachService.save(tpmLiqueurActRegisterDetailAttachReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody TpmLiqueurActRegisterDetailAttachReqVo tpmLiqueurActRegisterDetailAttachReqVo) {
        tpmLiqueurActDetailAttachService.update(tpmLiqueurActRegisterDetailAttachReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody TpmLiqueurActRegisterDetailAttachReqVo tpmLiqueurActRegisterDetailAttachReqVo) {
        tpmLiqueurActDetailAttachService.deleteBatch(tpmLiqueurActRegisterDetailAttachReqVo);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody TpmLiqueurActRegisterDetailAttachReqVo tpmLiqueurActRegisterDetailAttachReqVo) {
        tpmLiqueurActDetailAttachService.enableBatch(tpmLiqueurActRegisterDetailAttachReqVo);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody TpmLiqueurActRegisterDetailAttachReqVo tpmLiqueurActRegisterDetailAttachReqVo) {
        tpmLiqueurActDetailAttachService.disableBatch(tpmLiqueurActRegisterDetailAttachReqVo);
        return Result.ok("禁用成功");
    }
}
