package com.biz.crm.liqueuract.controller;

import com.biz.crm.liqueuract.service.ITpmLiqueurActRegisterDetailService;
import com.biz.crm.nebular.tpm.liqueuract.req.TpmLiqueurActRegisterDetailReqVo;
import com.biz.crm.nebular.tpm.liqueuract.resp.TpmLiqueurActRegisterDetailRespVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import com.biz.crm.aop.CrmLog;

/**
 * 酒类活动附件信息;
 *
 * @author lf
 * @date 2021-03-08 18:06:17
 */
@Slf4j
@RestController
@RequestMapping("/tpmliqueuractdetail")
@Api(tags = "酒类活动明细信息;")
public class TpmLiqueurActRegisterDetailController {
    @Autowired
    private ITpmLiqueurActRegisterDetailService liqueurTpmActDetailService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<TpmLiqueurActRegisterDetailRespVo>> list(@RequestBody TpmLiqueurActRegisterDetailReqVo tpmLiqueurActRegisterDetailReqVo) {
        PageResult<TpmLiqueurActRegisterDetailRespVo> result=liqueurTpmActDetailService.findList(tpmLiqueurActRegisterDetailReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    public Result<TpmLiqueurActRegisterDetailRespVo> query(@RequestBody TpmLiqueurActRegisterDetailReqVo tpmLiqueurActRegisterDetailReqVo) {
        TpmLiqueurActRegisterDetailRespVo respVo=liqueurTpmActDetailService.query(tpmLiqueurActRegisterDetailReqVo);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody TpmLiqueurActRegisterDetailReqVo tpmLiqueurActRegisterDetailReqVo) {
        liqueurTpmActDetailService.save(tpmLiqueurActRegisterDetailReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody TpmLiqueurActRegisterDetailReqVo tpmLiqueurActRegisterDetailReqVo) {
        liqueurTpmActDetailService.update(tpmLiqueurActRegisterDetailReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody TpmLiqueurActRegisterDetailReqVo tpmLiqueurActRegisterDetailReqVo) {
        liqueurTpmActDetailService.deleteBatch(tpmLiqueurActRegisterDetailReqVo);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody TpmLiqueurActRegisterDetailReqVo tpmLiqueurActRegisterDetailReqVo) {
        liqueurTpmActDetailService.enableBatch(tpmLiqueurActRegisterDetailReqVo);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody TpmLiqueurActRegisterDetailReqVo tpmLiqueurActRegisterDetailReqVo) {
        liqueurTpmActDetailService.disableBatch(tpmLiqueurActRegisterDetailReqVo);
        return Result.ok("禁用成功");
    }
}
