package com.biz.crm.liqueuract.mapper;

import com.biz.crm.interceptor.SqlPrivilege;
import com.biz.crm.liqueuract.model.TpmLiqueurActRegisterEntity;
import com.biz.crm.nebular.tpm.act.req.TpmActReqVo;
import com.biz.crm.nebular.tpm.liqueuract.req.TpmLiqueurActRegisterReqVo;
import com.biz.crm.nebular.tpm.liqueuract.resp.TpmLiqueurActRegisterRespVo;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.ibatis.annotations.Param;
import java.util.List;

/**
 * 酒类活动明细主表;
 *
 * @author lf
 * @date 2021-03-09 13:57:21
 */
public interface TpmLiqueurActRegisterMapper extends BaseMapper<TpmLiqueurActRegisterEntity> {
    /**
     * 列表
     * @param page
     * @param tpmLiqueurActRegisterReqVo
     * @return
     */
    @SqlPrivilege(posCode = "create_pos_code",orgCode = "create_org_code")
    List<TpmLiqueurActRegisterRespVo> findList(Page<TpmLiqueurActRegisterRespVo> page, @Param("vo") TpmLiqueurActRegisterReqVo tpmLiqueurActRegisterReqVo);

    /**
     * 删除
     * @param ids
     */
    void deleteByParams(@Param("ids") List<String> ids);
}
