package com.biz.crm.liqueuract.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.Getter;
import lombok.Setter;
import lombok.EqualsAndHashCode;
import java.math.BigDecimal;
import com.biz.crm.base.CrmBaseEntity;
import java.util.Date;
import lombok.experimental.Accessors;

/**
 * 酒类活动预算使用明细表;实体类
 *
 * @author lf
 * @date 2021-03-10 11:35:16
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("tpm_liqueur_act_budget_transaction")
@CrmTable(name = "tpm_liqueur_act_budget_transaction",tableNote = "TPM-酒类活动预算使用明细表")
public class TpmLiqueurActBudgetTransactionEntity extends CrmExtEntity<TpmLiqueurActBudgetTransactionEntity> {

    /**
     * 业务编码(可能是活动申请编码,活动登记编码和核销登记编码)
     */
    @CrmColumn(name = "business_code", length = 32,note = "业务编码(可能是活动申请编码,活动登记编码和核销登记编码)")
    private String businessCode;

    /**
     * 业务名称
     */
    @CrmColumn(name = "business_name", length = 200,note = "业务名称")
    private String businessName;

    /**
     * 业务明细编码(活动明细和核销明细)
     */
    @CrmColumn(name = "business_line_code", length = 32,note = "业务名称")
    private String businessLineCode;

    /**
     * 业务明细名称
     */
    @CrmColumn(name = "business_line_name", length = 60,note = "业务明细名称")
    private String businessLineName;

    /**
     * 业务类型(活动申请,活动明细登记,活动核销)
     */
    @CrmColumn(name = "business_type", length = 32,note = "业务类型(活动申请,活动明细登记,活动核销)")
    private String businessType;

    /**
     * 操作明细类型(占用,use,退回,return_back)
     */
    @CrmColumn(name = "transaction_type", length = 32,note = "操作明细类型(占用,use,退回,return_back)")
    private String transactionType;

    /**
     * 操作明细类型名称
     */
    @CrmColumn(name = "transaction_type_name", length = 60,note = "操作明细类型名称")
    private String transactionTypeName;

    /**
     * 业务备注
     */
    @CrmColumn(name = "business_remarks", length = 200,note = "业务备注")
    private String businessRemarks;

    /**
     * 活动预算编码
     */
    @CrmColumn(name = "act_budget_code", length = 32,note = "活动预算编码")
    private String actBudgetCode;

    /**
     * 费用预算控制维度id
     */
    @CrmColumn(name = "control_id", length = 32,note = "费用预算控制维度id")
    private String controlId;

    /**
     * 费用预算编码
     */
    @CrmColumn(name = "fee_budget_code", length = 32,note = "费用预算编码")
    private String feeBudgetCode;

    /**
     * 操作金额(占用的时候为负数,退回占用的时候为正数)
     */
    @CrmColumn(name = "fee_amount",mysqlType = "decimal(16,6)",oracleType = "NUMBER(16, 6)",note = "操作金额(占用的时候为负数,退回占用的时候为正数)")
    private BigDecimal feeAmount;

    /**
     * 实际扣减顺序
     */
    @CrmColumn(name = "reduce_order",mysqlType = "int(10)", oracleType = "NUMBER(10,0)",note = "实际扣减顺序")
    private Integer reduceOrder;

}
