package com.biz.crm.liqueuract.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.EqualsAndHashCode;
import java.math.BigDecimal;
import com.biz.crm.base.CrmBaseEntity;
import java.util.Date;
import lombok.experimental.Accessors;

/**
 * 酒类活动明细关联的活动费用预算表实体类
 *
 * @author lf
 * @date 2021-03-10 13:41:58
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("tpm_liqueur_act_register_detail_budget")
@CrmTable(name = "tpm_liqueur_act_register_detail_budget",tableNote = "TPM-酒类活动明细关联的活动费用预算表实体类")
public class TpmLiqueurActRegisterDetailBudgetEntity extends CrmExtEntity<TpmLiqueurActRegisterDetailBudgetEntity> {
    /**
     * 活动申请单号
     */
    @CrmColumn(name = "act_code", length = 32,note = "活动申请单号")
    private String actCode;
    /**
     * 活动登记单号
     */
    @CrmColumn(name = "act_register_code", length = 32,note = "活动登记单号")
    private String actRegisterCode;
    /**
     * 活动明细编码
     */
    @CrmColumn(name = "act_detail_code", length = 32,note = "活动明细编码")
    private String actDetailCode;

    /**
     * 活动预算编码
     */
    @CrmColumn(name = "act_budget_code", length = 32,note = "活动预算编码")
    private String actBudgetCode;

    /**
     * 费用预算控制维度id
     */
    @CrmColumn(name = "control_id", length = 32,note = "费用预算控制维度id")
    private String controlId;

    /**
     * 费用预算编码
     */
    @CrmColumn(name = "fee_budget_code", length = 32,note = "费用预算编码")
    private String feeBudgetCode;

    /**
     * 当前活动明细使用活动预算的金额
     */
    @CrmColumn(name = "used_amount", length = 32,note = "当前活动明细使用活动预算的金额")
    private BigDecimal usedAmount;

    /**
     * 预算科目编码
     */
    @CrmColumn(name = "budget_subjects_code", length = 32,note = "预算科目编码")
    private String budgetSubjectsCode;

}
