package com.biz.crm.liqueuract.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.EqualsAndHashCode;
import java.math.BigDecimal;

import lombok.experimental.Accessors;

/**
 * 酒类活动登记主表;实体类
 *
 * @author lf
 * @date 2021-03-09 13:57:21
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("tpm_liqueur_act_register")
@CrmTable(name = "tpm_liqueur_act_register",tableNote = "TPM-酒类活动登记主表")
public class TpmLiqueurActRegisterEntity extends CrmExtEntity<TpmLiqueurActRegisterEntity> {

    /**
     * 活动登记单号
     */
    @CrmColumn(name = "act_register_code", length = 32,note = "活动登记单号")
    private String actRegisterCode;
    /**
     * 活动编码
     */
    @CrmColumn(name = "act_code", length = 32,note = "活动编码")
    private String actCode;

    /**
     * 活动名称
     */
    @CrmColumn(name = "act_name", length = 60,note = "活动名称")
    private String actName;

    /**
     * 登记总金额
     */
    @CrmColumn(name = "total_amount",mysqlType = "decimal(16,6)",oracleType = "NUMBER(16, 6)",note = "登记总金额")
    private BigDecimal totalAmount;

    /**
     * 流程编号
     */
    @CrmColumn(name = "process_code", length = 32,note = "流程编号")
    private String processCode;

    /**
     * 审批状态
     */
    @CrmColumn(name = "approve_status", length = 32,note = "审批状态")
    private String approveStatus;

    /**
     * 工作流key
     */
    @CrmColumn(name = "work_flow_key", length = 32,note = "工作流key")
    private String workFlowKey;

    /**
     * 工作流名称
     */
    @CrmColumn(name = "work_flow_name", length = 60,note = "工作流名称")
    private String workFlowName;

    /**
     * 活动类型表单
     */
    @CrmColumn(name = "cost_form_code", length = 64,note = "活动类型表单")
    private String costFormCode;

    /**
     * 核销表单编码
     */
    @CrmColumn(name = "audit_form_code", length = 64,note = "核销表单编码")
    private String auditFormCode;
}
