package com.biz.crm.liqueuract.service;

import com.biz.crm.liqueuract.model.TpmLiqueurActBudgetTransactionEntity;
import com.biz.crm.nebular.tpm.liqueuract.req.TpmLiqueurActBudgetTransactionReqVo;
import com.biz.crm.nebular.tpm.liqueuract.resp.TpmLiqueurActBudgetTransactionRespVo;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.service.IService;

import java.util.Map;

/**
 * 酒类活动预算使用明细表;接口
 *
 * @author lf
 * @date 2021-03-10 11:35:16
 */
public interface ITpmLiqueurActBudgetTransactionService extends IService<TpmLiqueurActBudgetTransactionEntity> {

    /**
     * 列表
     * @param tpmLiqueurActBudgetTransactionReqVo
     * @return PageResult<TpmLiqueurActBudgetTransactionRespVo>
     */
    PageResult<TpmLiqueurActBudgetTransactionRespVo> findList(TpmLiqueurActBudgetTransactionReqVo tpmLiqueurActBudgetTransactionReqVo);

    /**
     * 查询
     * @param tpmLiqueurActBudgetTransactionReqVo
     * @return TpmLiqueurActBudgetTransactionRespVo
     */
    TpmLiqueurActBudgetTransactionRespVo query(TpmLiqueurActBudgetTransactionReqVo tpmLiqueurActBudgetTransactionReqVo);

    /**
     * 新增
     * @param tpmLiqueurActBudgetTransactionReqVo
     * @return
     */
    void save(TpmLiqueurActBudgetTransactionReqVo tpmLiqueurActBudgetTransactionReqVo);

    /**
     * 更新
     * @param tpmLiqueurActBudgetTransactionReqVo
     * @return
     */
    void update(TpmLiqueurActBudgetTransactionReqVo tpmLiqueurActBudgetTransactionReqVo);

    /**
     * 删除
     * @param tpmLiqueurActBudgetTransactionReqVo
     * @return
     */
    void deleteBatch(TpmLiqueurActBudgetTransactionReqVo tpmLiqueurActBudgetTransactionReqVo);

    /**
     * 启用
     * @param tpmLiqueurActBudgetTransactionReqVo
     * @return
     */
    void enableBatch(TpmLiqueurActBudgetTransactionReqVo tpmLiqueurActBudgetTransactionReqVo);

    /**
     * 禁用
     * @param tpmLiqueurActBudgetTransactionReqVo
     * @return
     */
    void disableBatch(TpmLiqueurActBudgetTransactionReqVo tpmLiqueurActBudgetTransactionReqVo);
}

