package com.biz.crm.liqueuract.service;

import com.biz.crm.liqueuract.model.TpmLiqueurActRegisterEntity;
import com.biz.crm.nebular.activiti.act.ActivitiCallBackVo;
import com.biz.crm.nebular.tpm.costtypecategories.req.TpmCostTypeCategoriesReqVo;
import com.biz.crm.nebular.tpm.costtypecategories.resp.TpmCostTypeCategoriesRespVo;
import com.biz.crm.nebular.tpm.feebudget.resp.TpmFeeBudgetControlRespVo;
import com.biz.crm.nebular.tpm.liqueuract.req.TpmLiqueurActBudgetReqVo;
import com.biz.crm.nebular.tpm.liqueuract.req.TpmLiqueurActRegisterDetailReqVo;
import com.biz.crm.nebular.tpm.liqueuract.req.TpmLiqueurActRegisterReqVo;
import com.biz.crm.nebular.tpm.liqueuract.resp.TpmLiqueurActBudgetRespVo;
import com.biz.crm.nebular.tpm.liqueuract.resp.TpmLiqueurActRegisterRespVo;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.service.IService;

import java.util.List;

/**
 * 酒类活动明细主表;接口
 *
 * @author lf
 * @date 2021-03-09 13:57:21
 */
public interface ITpmLiqueurActRegisterService extends IService<TpmLiqueurActRegisterEntity> {

    /**
     * 列表
     * @param tpmLiqueurActRegisterReqVo
     * @return PageResult<TpmLiqueurActRegisterRespVo>
     */
    PageResult<TpmLiqueurActRegisterRespVo> findList(TpmLiqueurActRegisterReqVo tpmLiqueurActRegisterReqVo);

    /**
     * 查询
     * @param id
     * @return TpmLiqueurActRegisterRespVo
     */
    TpmLiqueurActRegisterRespVo query(String id);

    /**
     * 新增
     * @param tpmLiqueurActRegisterReqVo
     * @return
     */
    void save(TpmLiqueurActRegisterReqVo tpmLiqueurActRegisterReqVo);

    /**
     * 更新
     * @param tpmLiqueurActRegisterReqVo
     * @return
     */
    void update(TpmLiqueurActRegisterReqVo tpmLiqueurActRegisterReqVo);

    /**
     * 删除
     * @param ids id集合
     */
    void deleteBatch(List<String> ids);

    /**
     * 启用
     * @param ids id集合
     */
    void enableBatch(List<String> ids);

    /**
     * 禁用
     * @param ids id 集合
     */
    void disableBatch(List<String> ids);

    /**
     * 提交审批
     * @param reqVo
     */
    void approve(TpmLiqueurActRegisterReqVo reqVo);

    /**
     * 工作流审批回调
     * @param activitiCallBackVo
     */
    void activityCallBack(ActivitiCallBackVo activitiCallBackVo);

    void approved(TpmLiqueurActRegisterReqVo reqVo);

    void rejectAndInterrupt(TpmLiqueurActRegisterReqVo reqVo);

    /**
     * 根据actCode查询酒类活动预算信息
     * @param reqVo
     * @return  List<TpmLiqueurActBudgetRespVo>
     */
    List<TpmFeeBudgetControlRespVo> findBudgetByActCode(TpmLiqueurActBudgetReqVo reqVo);

    /**
     * 根据预算科目编码集合查询投入类型
     * @param reqVo
     * @return  List<TpmCostTypeCategoriesRespVo>
     */
    PageResult<TpmCostTypeCategoriesRespVo> findCategoriesBySubjectCodes(TpmLiqueurActRegisterDetailReqVo reqVo);
}

