package com.biz.crm.liqueuract.service.impl;

import com.biz.crm.liqueuract.mapper.TpmLiqueurActBudgetTransactionMapper;
import com.biz.crm.liqueuract.model.TpmLiqueurActBudgetTransactionEntity;
import com.biz.crm.liqueuract.service.ITpmLiqueurActBudgetTransactionService;
import com.biz.crm.nebular.tpm.liqueuract.req.TpmLiqueurActBudgetTransactionReqVo;
import com.biz.crm.nebular.tpm.liqueuract.resp.TpmLiqueurActBudgetTransactionRespVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.util.CrmBeanUtil;
import org.apache.commons.collections4.CollectionUtils;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.transaction.annotation.Transactional;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import javax.annotation.Resource;

/**
 * 酒类活动预算使用明细表;接口实现
 *
 * @author lf
 * @date 2021-03-10 11:35:16
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="TpmLiqueurActBudgetTransactionServiceExpandImpl")
public class TpmLiqueurActBudgetTransactionServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<TpmLiqueurActBudgetTransactionMapper, TpmLiqueurActBudgetTransactionEntity> implements ITpmLiqueurActBudgetTransactionService {

    @Resource
    private TpmLiqueurActBudgetTransactionMapper tpmLiqueurActBudgetTransactionMapper;

    /**
     * 列表
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<TpmLiqueurActBudgetTransactionRespVo> findList(TpmLiqueurActBudgetTransactionReqVo reqVo){
        Page<TpmLiqueurActBudgetTransactionRespVo> page = new Page<>(reqVo.getPageNum(), reqVo.getPageSize());
        List<TpmLiqueurActBudgetTransactionRespVo> list = tpmLiqueurActBudgetTransactionMapper.findList(page, reqVo);
        return PageResult.<TpmLiqueurActBudgetTransactionRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     * @param reqVo
     * @return tpmLiqueurActBudgetTransactionRespVo
     */
    @Override
    public TpmLiqueurActBudgetTransactionRespVo query(TpmLiqueurActBudgetTransactionReqVo reqVo){
        return null;
    }

    /**
     * 新增
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(TpmLiqueurActBudgetTransactionReqVo reqVo){
        TpmLiqueurActBudgetTransactionEntity entity = CrmBeanUtil.copy(reqVo,TpmLiqueurActBudgetTransactionEntity.class);
        this.save(entity);
    }

    /**
     * 更新
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(TpmLiqueurActBudgetTransactionReqVo reqVo){
        TpmLiqueurActBudgetTransactionEntity entity = this.getById(reqVo.getId());
        this.updateById(entity);
    }

    /**
     * 删除
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(TpmLiqueurActBudgetTransactionReqVo reqVo){
        List<TpmLiqueurActBudgetTransactionEntity> tpmLiqueurActBudgetTransactionEntities = tpmLiqueurActBudgetTransactionMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(tpmLiqueurActBudgetTransactionEntities)){
            tpmLiqueurActBudgetTransactionEntities.forEach(o -> {
                 o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(tpmLiqueurActBudgetTransactionEntities);
    }

    /**
     * 启用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(TpmLiqueurActBudgetTransactionReqVo reqVo){
        //设置状态为启用
        List<TpmLiqueurActBudgetTransactionEntity> tpmLiqueurActBudgetTransactionEntities = tpmLiqueurActBudgetTransactionMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(tpmLiqueurActBudgetTransactionEntities)){
            tpmLiqueurActBudgetTransactionEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(tpmLiqueurActBudgetTransactionEntities);
    }

    /**
     * 禁用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(TpmLiqueurActBudgetTransactionReqVo reqVo){
        //设置状态为禁用
        List<TpmLiqueurActBudgetTransactionEntity> tpmLiqueurActBudgetTransactionEntities = tpmLiqueurActBudgetTransactionMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(tpmLiqueurActBudgetTransactionEntities)){
                tpmLiqueurActBudgetTransactionEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(tpmLiqueurActBudgetTransactionEntities);
    }
}
