package com.biz.crm.liqueuract.service.impl;

import com.biz.crm.liqueuract.mapper.TpmLiqueurActRegisterDetailAttachMapper;
import com.biz.crm.liqueuract.model.TpmLiqueurActRegisterDetailAttachEntity;
import com.biz.crm.liqueuract.service.ITpmLiqueurActRegisterDetailAttachService;
import com.biz.crm.nebular.tpm.liqueuract.req.TpmLiqueurActRegisterDetailAttachReqVo;
import com.biz.crm.nebular.tpm.liqueuract.resp.TpmLiqueurActRegisterDetailAttachRespVo;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.util.CrmBeanUtil;
import org.apache.commons.collections4.CollectionUtils;
import java.util.List;

import lombok.extern.slf4j.Slf4j;
import org.springframework.transaction.annotation.Transactional;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import javax.annotation.Resource;

/**
 * 酒类活动附件信息;接口实现
 *
 * @author lf
 * @date 2021-03-08 18:33:23
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="TpmLiqueurActDetailAttachServiceExpandImpl")
public class TpmLiqueurActRegisterDetailAttachServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<TpmLiqueurActRegisterDetailAttachMapper, TpmLiqueurActRegisterDetailAttachEntity> implements ITpmLiqueurActRegisterDetailAttachService {

    @Resource
    private TpmLiqueurActRegisterDetailAttachMapper tpmLiqueurActRegisterDetailAttachMapper;

    /**
     * 列表
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<TpmLiqueurActRegisterDetailAttachRespVo> findList(TpmLiqueurActRegisterDetailAttachReqVo reqVo){
        Page<TpmLiqueurActRegisterDetailAttachRespVo> page = new Page<>(reqVo.getPageNum(), reqVo.getPageSize());
        List<TpmLiqueurActRegisterDetailAttachRespVo> list = tpmLiqueurActRegisterDetailAttachMapper.findList(page, reqVo);
        return PageResult.<TpmLiqueurActRegisterDetailAttachRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     * @param reqVo
     * @return tpmLiqueurActDetailAttachRespVo
     */
    @Override
    public TpmLiqueurActRegisterDetailAttachRespVo query(TpmLiqueurActRegisterDetailAttachReqVo reqVo){
        return null;
    }

    /**
     * 新增
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(TpmLiqueurActRegisterDetailAttachReqVo reqVo){
        TpmLiqueurActRegisterDetailAttachEntity entity = CrmBeanUtil.copy(reqVo, TpmLiqueurActRegisterDetailAttachEntity.class);
        this.save(entity);
    }

    /**
     * 更新
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(TpmLiqueurActRegisterDetailAttachReqVo reqVo){
        TpmLiqueurActRegisterDetailAttachEntity entity = this.getById(reqVo.getId());
        this.updateById(entity);
    }

    /**
     * 删除
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(TpmLiqueurActRegisterDetailAttachReqVo reqVo){
        List<TpmLiqueurActRegisterDetailAttachEntity> tpmLiqueurActDetailAttachEntities = tpmLiqueurActRegisterDetailAttachMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(tpmLiqueurActDetailAttachEntities)){
            tpmLiqueurActDetailAttachEntities.forEach(o -> {
                 o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(tpmLiqueurActDetailAttachEntities);
    }

    /**
     * 启用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(TpmLiqueurActRegisterDetailAttachReqVo reqVo){
        //设置状态为启用
        List<TpmLiqueurActRegisterDetailAttachEntity> tpmLiqueurActDetailAttachEntities = tpmLiqueurActRegisterDetailAttachMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(tpmLiqueurActDetailAttachEntities)){
            tpmLiqueurActDetailAttachEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(tpmLiqueurActDetailAttachEntities);
    }

    /**
     * 禁用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(TpmLiqueurActRegisterDetailAttachReqVo reqVo){
        //设置状态为禁用
        List<TpmLiqueurActRegisterDetailAttachEntity> tpmLiqueurActDetailAttachEntities = tpmLiqueurActRegisterDetailAttachMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(tpmLiqueurActDetailAttachEntities)){
                tpmLiqueurActDetailAttachEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(tpmLiqueurActDetailAttachEntities);
    }
}
