package com.biz.crm.liqueuract.service.impl;

import com.biz.crm.liqueuract.mapper.TpmLiqueurActRegisterDetailMapper;
import com.biz.crm.liqueuract.model.TpmLiqueurActRegisterDetailEntity;
import com.biz.crm.liqueuract.service.ITpmLiqueurActRegisterDetailService;
import com.biz.crm.nebular.tpm.liqueuract.req.TpmLiqueurActRegisterDetailReqVo;
import com.biz.crm.nebular.tpm.liqueuract.resp.TpmLiqueurActRegisterDetailRespVo;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.util.CrmBeanUtil;
import org.apache.commons.collections4.CollectionUtils;
import java.util.List;

import lombok.extern.slf4j.Slf4j;
import org.springframework.transaction.annotation.Transactional;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import javax.annotation.Resource;

/**
 * 酒类活动明细信息;接口实现
 *
 * @author lf
 * @date 2021-03-08 18:06:17
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="TpmLiqueurTpmActDetailServiceExpandImpl")
public class TpmLiqueurActRegisterDetailServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<TpmLiqueurActRegisterDetailMapper, TpmLiqueurActRegisterDetailEntity> implements ITpmLiqueurActRegisterDetailService {

    @Resource
    private TpmLiqueurActRegisterDetailMapper tpmLiqueurActRegisterDetailMapper;

    /**
     * 列表
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<TpmLiqueurActRegisterDetailRespVo> findList(TpmLiqueurActRegisterDetailReqVo reqVo){
        Page<TpmLiqueurActRegisterDetailRespVo> page = new Page<>(reqVo.getPageNum(), reqVo.getPageSize());
        List<TpmLiqueurActRegisterDetailRespVo> list = tpmLiqueurActRegisterDetailMapper.findList(page, reqVo);
        return PageResult.<TpmLiqueurActRegisterDetailRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     * @param reqVo
     * @return liqueurTpmActDetailRespVo
     */
    @Override
    public TpmLiqueurActRegisterDetailRespVo query(TpmLiqueurActRegisterDetailReqVo reqVo){
        return null;
    }

    /**
     * 新增
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(TpmLiqueurActRegisterDetailReqVo reqVo){
        TpmLiqueurActRegisterDetailEntity entity = CrmBeanUtil.copy(reqVo, TpmLiqueurActRegisterDetailEntity.class);
        this.save(entity);
    }

    /**
     * 更新
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(TpmLiqueurActRegisterDetailReqVo reqVo){
        TpmLiqueurActRegisterDetailEntity entity = this.getById(reqVo.getId());
        this.updateById(entity);
    }

    /**
     * 删除
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(TpmLiqueurActRegisterDetailReqVo reqVo){
        List<TpmLiqueurActRegisterDetailEntity> liqueurTpmActDetailEntities = tpmLiqueurActRegisterDetailMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(liqueurTpmActDetailEntities)){
            liqueurTpmActDetailEntities.forEach(o -> {
                 o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(liqueurTpmActDetailEntities);
    }

    /**
     * 启用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(TpmLiqueurActRegisterDetailReqVo reqVo){
        //设置状态为启用
        List<TpmLiqueurActRegisterDetailEntity> liqueurTpmActDetailEntities = tpmLiqueurActRegisterDetailMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(liqueurTpmActDetailEntities)){
            liqueurTpmActDetailEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(liqueurTpmActDetailEntities);
    }

    /**
     * 禁用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(TpmLiqueurActRegisterDetailReqVo reqVo){
        //设置状态为禁用
        List<TpmLiqueurActRegisterDetailEntity> liqueurTpmActDetailEntities = tpmLiqueurActRegisterDetailMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(liqueurTpmActDetailEntities)){
                liqueurTpmActDetailEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(liqueurTpmActDetailEntities);
    }

}
