package com.biz.crm.liqueuract.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.act.service.impl.ActServiceHelper;
import com.biz.crm.activiti.act.TaActBaseFeign;
import com.biz.crm.advancepay.model.TpmActAdvancePayEntity;
import com.biz.crm.annotation.Klock;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.budgetsubjects.mapper.TpmBudgetSubjectsMapper;
import com.biz.crm.budgetsubjects.model.TpmBudgetSubjectsEntity;
import com.biz.crm.common.DictItemVo;
import com.biz.crm.common.GlobalParam;
import com.biz.crm.common.TpmGlobalDictConstants;
import com.biz.crm.costtypecategories.mapper.TpmCostTypeCategoriesMapper;
import com.biz.crm.costtypecategories.model.TpmCostTypeCategoriesEntity;
import com.biz.crm.costtypecategories.service.impl.CostTypeCategoriesServiceHelper;
import com.biz.crm.crmlog.handle.util.CrmLogSendUtil;
import com.biz.crm.eunm.activiti.Indicator;
import com.biz.crm.eunm.tpm.ActApproveStatusEnum;
import com.biz.crm.eunm.tpm.ActSendMessageTypeEnum;
import com.biz.crm.eunm.tpm.BudgetSubjectsControlTypeEnum;
import com.biz.crm.eunm.tpm.TpmProjectNameEnum;
import com.biz.crm.exception.CommonException;
import com.biz.crm.exception.tpm.FeeBudgetException;
import com.biz.crm.feebudget.mapper.TpmFeeBudgetControlMapper;
import com.biz.crm.feebudget.mapper.TpmFeeBudgetMapper;
import com.biz.crm.feebudget.model.TpmFeeBudgetControlEntity;
import com.biz.crm.feebudget.model.TpmFeeBudgetEntity;
import com.biz.crm.liqueuract.mapper.*;
import com.biz.crm.liqueuract.model.*;
import com.biz.crm.liqueuract.service.ITpmLiqueurActRegisterService;
import com.biz.crm.liqueuract.service.impl.actbuilder.ActRegisterBaseBuilder;
import com.biz.crm.liqueuract.service.impl.actbuilder.ActRegisterBuilder;
import com.biz.crm.mdm.customer.MdmCustomerMsgFeign;
import com.biz.crm.mdm.product.MdmProductFeign;
import com.biz.crm.mq.RocketMQConstant;
import com.biz.crm.mq.RocketMQMessageBody;
import com.biz.crm.mq.RocketMQProducer;
import com.biz.crm.nebular.activiti.act.ActivitiCallBackVo;
import com.biz.crm.nebular.activiti.act.req.StartProcessReqVo;
import com.biz.crm.nebular.activiti.common.ProcessCommonVo;
import com.biz.crm.nebular.dms.order.OrderDetailVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductRespVo;
import com.biz.crm.nebular.tpm.act.req.TpmActSendMessageVo;
import com.biz.crm.nebular.tpm.costtypecategories.resp.TpmCostTypeCategoriesRespVo;
import com.biz.crm.nebular.tpm.feebudget.resp.TpmFeeBudgetControlRespVo;
import com.biz.crm.nebular.tpm.feebudget.resp.TpmFeeBudgetRespVo;
import com.biz.crm.nebular.tpm.liqueuract.req.TpmLiqueurActBudgetReqVo;
import com.biz.crm.nebular.tpm.liqueuract.req.TpmLiqueurActRegisterDetailReqVo;
import com.biz.crm.nebular.tpm.liqueuract.req.TpmLiqueurActRegisterReqVo;
import com.biz.crm.nebular.tpm.liqueuract.resp.*;
import com.biz.crm.util.*;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.auth.AUTH;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.commons.collections4.CollectionUtils;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

import lombok.extern.slf4j.Slf4j;
import org.springframework.transaction.annotation.Transactional;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import javax.annotation.Resource;

/**
 * 酒类活动明细主表;接口实现
 *
 * @author lf
 * @date 2021-03-09 13:57:21
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="TpmLiqueurDetailServiceExpandImpl")
public class TpmLiqueurActRegisterServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<TpmLiqueurActRegisterMapper, TpmLiqueurActRegisterEntity> implements ITpmLiqueurActRegisterService {

    @Autowired
    private TaActBaseFeign activityFeign;

    @Resource
    private TpmLiqueurActRegisterMapper tpmLiqueurActRegisterMapper;

    @Resource
    private TpmLiqueurActBudgetMapper budgetMapper;

    @Resource
    private TpmFeeBudgetControlMapper budgetControlMapper;

    @Resource
    private TpmBudgetSubjectsMapper budgetSubjectsMapper;

    @Resource
    private TpmCostTypeCategoriesMapper costTypeCategoriesMapper;

    @Autowired
    private CostTypeCategoriesServiceHelper categoriesServiceHelper;

    @Resource
    private TpmLiqueurActRegisterDetailBudgetMapper detailBudgetMapper;

    @Resource
    private TpmLiqueurActRegisterDetailAttachMapper attachMapper;

    @Resource
    private TpmLiqueurActRegisterDetailMapper detailMapper;

    @Resource
    private TpmLiqueurActMapper liqueurActMapper;

    @Autowired
    private TpmLiqueurActRegisterServiceHelper helper;

    @Autowired
    private RocketMQProducer rocketMQProducer;

    @Autowired
    private TpmLiqueurServiceHelper liqueurServiceHelper;

    @Value("${rocketmq.topic}" + "${rocketmq.environment-variable}")
    private String topic;

    @Autowired
    private CrmLogSendUtil crmLogSendUtil;
    @Autowired
    private MdmProductFeign mdmProductFeign;
    @Autowired
    private MdmCustomerMsgFeign mdmCustomerMsgFeign;

    /**
     * 列表
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<TpmLiqueurActRegisterRespVo> findList(TpmLiqueurActRegisterReqVo reqVo){
        Page<TpmLiqueurActRegisterRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        List<TpmLiqueurActRegisterRespVo> list = tpmLiqueurActRegisterMapper.findList(page, reqVo);
        helper.convertListDate(list);
        return PageResult.<TpmLiqueurActRegisterRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     * @param id
     * @return tpmLiqueurDetailRespVo
     */
    @Override
    public TpmLiqueurActRegisterRespVo query(String id){
        //校验参数
        AssertUtils.isNotEmpty(id,"id不能为空");
        //得到主表数据
        TpmLiqueurActRegisterReqVo tpmLiqueurActRegisterReqVo = new TpmLiqueurActRegisterReqVo();
        tpmLiqueurActRegisterReqVo.setId(id);
        List<TpmLiqueurActRegisterRespVo> list = this.findList(tpmLiqueurActRegisterReqVo).getData();
        AssertUtils.isNotEmpty(list, "您选择的数据不存在");
        TpmLiqueurActRegisterRespVo respVo = list.get(0);
        AssertUtils.isNotEmpty(respVo.getActRegisterCode(),"该数据活动登记单号为空");
        TpmLiqueurActEntity tpmLiqueurActEntity = liqueurActMapper.selectOne(Wrappers.lambdaQuery(TpmLiqueurActEntity.class).eq(TpmLiqueurActEntity::getActCode, respVo.getActCode()));
        respVo.setFineCode(tpmLiqueurActEntity.getFineCode());
        respVo.setFineName(tpmLiqueurActEntity.getFineName());
        respVo.setBeginDate(tpmLiqueurActEntity.getBeginDate());
        respVo.setBeginDateSecond(tpmLiqueurActEntity.getBeginDateSecond());
        respVo.setEndDate(tpmLiqueurActEntity.getEndDate());
        respVo.setEndDateSecond(tpmLiqueurActEntity.getEndDateSecond());

        //添加活动预算费用数据
        //获取活动预算信息集合
        List<TpmLiqueurActBudgetEntity> budgetEntities = budgetMapper.selectList(new LambdaQueryWrapper<TpmLiqueurActBudgetEntity>().eq(TpmLiqueurActBudgetEntity::getActCode, respVo.getActCode()));
        if (CollectionUtils.isNotEmpty(budgetEntities)) {
            //用于保存控制维度
            Set<String> controlIds = Sets.newHashSet();
            //map的key是控制维度id
            Map<String, List<TpmLiqueurActBudgetEntity>> controlIdMap = Maps.newHashMap();
            //map的key是控制维度id,0位存放控制维度的applyAmount,1位存放控制维度的canUseAmount
            Map<String, List<BigDecimal>> amountMap = Maps.newHashMap();
            budgetEntities.stream().forEach(actBudgetEntity -> {
                //以控制维度id把budgetEntities分组
                if (controlIdMap.containsKey(actBudgetEntity.getControlId())){
                    //map中存在此控制维度id，将数据存放到当前key中
                    controlIdMap.get(actBudgetEntity.getControlId()).add(actBudgetEntity);
                    //计算空控制维度的申请金额和可用金额
                    List<BigDecimal> amountList = amountMap.get(actBudgetEntity.getControlId());
                    BigDecimal applyAmount = amountList.get(0);
                    BigDecimal canUserAmount = amountList.get(1);
                    if (actBudgetEntity.getApplyAmount()!=null){
                        applyAmount = applyAmount.add(actBudgetEntity.getApplyAmount());
                    }
                    if (actBudgetEntity.getCanUseAmount()!=null){
                        canUserAmount = canUserAmount.add(actBudgetEntity.getCanUseAmount());
                    }
                    amountList.set(0,applyAmount);
                    amountList.set(1,canUserAmount);
                    amountMap.put(actBudgetEntity.getControlId(),amountList);
                }else {
                    //map中不存在此控制维度id，新建key来存放
                    List<TpmLiqueurActBudgetEntity> liqueurActBudgetEntitiesByControlId = Lists.newArrayList();
                    liqueurActBudgetEntitiesByControlId.add(actBudgetEntity);
                    controlIdMap.put(actBudgetEntity.getControlId(),liqueurActBudgetEntitiesByControlId);
                    //新建Key来存放控制维度的applyAmount（0）,存放控制维度的canUseAmount（1）
                    List<BigDecimal> amountList = Lists.newArrayList();
                    if (actBudgetEntity.getApplyAmount()!=null){
                        amountList.add(0,actBudgetEntity.getApplyAmount());
                    }else {
                        amountList.add(0,BigDecimal.ZERO);
                    }
                    if (actBudgetEntity.getCanUseAmount()!=null){
                        amountList.add(1,actBudgetEntity.getCanUseAmount());
                    }else {
                        amountList.add(1,BigDecimal.ZERO);
                    }
                    amountMap.put(actBudgetEntity.getControlId(),amountList);
                }
                controlIds.add(actBudgetEntity.getControlId());
            });
            //查询控制维度集合
            List<TpmFeeBudgetControlRespVo> budgetControlRespVos = CrmBeanUtil.copyList(budgetControlMapper.selectList(Wrappers.lambdaQuery(TpmFeeBudgetControlEntity.class).in(TpmFeeBudgetControlEntity::getId,controlIds)), TpmFeeBudgetControlRespVo.class);
            if (CollectionUtils.isNotEmpty(budgetControlRespVos)){
                budgetControlRespVos.stream().forEach(budgetControl ->{
                    //为控制维度赋值（申请金额、可用余额、酒类费用预算集合）
                    budgetControl.setApplyAmount(amountMap.get(budgetControl.getId()).get(0));
                    budgetControl.setCanUseAmount(amountMap.get(budgetControl.getId()).get(1));
                    budgetControl.setLiqueurBudgetVos(CrmBeanUtil.copyList(controlIdMap.get(budgetControl.getId()),TpmLiqueurActBudgetRespVo.class));
                });
            }
            respVo.setEditBudgetVos(budgetControlRespVos);
        }

        //添加活动细明登记表集合
        List<TpmLiqueurActRegisterDetailEntity> detailEntities = detailMapper.selectList(new LambdaQueryWrapper<TpmLiqueurActRegisterDetailEntity>().eq(TpmLiqueurActRegisterDetailEntity::getActRegisterCode, respVo.getActRegisterCode()));
        List<TpmLiqueurActRegisterDetailRespVo> detailRespVos = CrmBeanUtil.copyList(detailEntities, TpmLiqueurActRegisterDetailRespVo.class);
        //根据主数据的actRegisterCode查询活动明细登记的 关联预算 和 附加信息
        List<TpmLiqueurActRegisterDetailBudgetEntity> detailBudgetEntities = detailBudgetMapper.selectList(Wrappers.lambdaQuery(TpmLiqueurActRegisterDetailBudgetEntity.class).eq(TpmLiqueurActRegisterDetailBudgetEntity::getActRegisterCode, respVo.getActRegisterCode())).stream().sorted(Comparator.comparing(TpmLiqueurActRegisterDetailBudgetEntity::getExt21)).collect(Collectors.toList());
        List<TpmLiqueurActRegisterDetailAttachEntity> detailAttachEntities = attachMapper.selectList(Wrappers.lambdaQuery(TpmLiqueurActRegisterDetailAttachEntity.class).eq(TpmLiqueurActRegisterDetailAttachEntity::getActRegisterCode,respVo.getActRegisterCode()));
        //以actDetailCode为key分组关联预算
        Map<String,List<TpmLiqueurActRegisterDetailBudgetEntity>> detailBudgetMap = detailBudgetEntities.stream()
                .collect(Collectors.groupingBy(TpmLiqueurActRegisterDetailBudgetEntity::getActDetailCode));
        //以actDetailCode为key分组附加信息
        Map<String,List<TpmLiqueurActRegisterDetailAttachEntity>> detailAttachMap = detailAttachEntities.stream()
                .collect(Collectors.groupingBy(TpmLiqueurActRegisterDetailAttachEntity::getActDetailCode));
        //为活动细明登记赋值
        if (CollectionUtils.isNotEmpty(detailRespVos)){
            detailRespVos.stream().forEach(detailRespVo ->{
                //将其所属的登记细类预算通过ControlId分组
                Map<String, List<TpmLiqueurActRegisterDetailBudgetEntity>> collect = detailBudgetMap.get(detailRespVo.getActDetailCode()).stream()
                        .collect(Collectors.groupingBy(TpmLiqueurActRegisterDetailBudgetEntity::getControlId));
                List<TpmLiqueurActRegisterDetailBudgetEntity> tpmLiqueurActRegisterDetailBudgetEntities = detailBudgetMap.get(detailRespVo.getActDetailCode());
                List<String> collect1 = tpmLiqueurActRegisterDetailBudgetEntities.stream().map(TpmLiqueurActRegisterDetailBudgetEntity::getControlId).collect(Collectors.toList());
                for(String key:collect1){
                    List<TpmLiqueurActRegisterDetailBudgetEntity> detailBudgetEntityList = collect.get(key);
                    if (CollectionUtils.isNotEmpty(detailBudgetEntityList)){
                        TpmLiqueurActRegisterDetailBudgetRespVo copy = CrmBeanUtil.copy(detailBudgetEntityList.get(0), TpmLiqueurActRegisterDetailBudgetRespVo.class);
                        copy.setFeeBudgetCodes(copy.getFeeBudgetCode());
                        detailBudgetEntityList.stream().forEach(o->{
                            if (!copy.getFeeBudgetCode().contains(o.getFeeBudgetCode())){
                                copy.setFeeBudgetCodes(copy.getFeeBudgetCode()+","+o.getFeeBudgetCode());
                            }
                        });
                        if (CollectionUtils.isEmpty(detailRespVo.getDetailBudgetVos())){
                            List<TpmLiqueurActRegisterDetailBudgetRespVo> detailBudgetVos = Lists.newArrayList();
                            detailRespVo.setDetailBudgetVos(detailBudgetVos);
                        }
                        detailRespVo.getDetailBudgetVos().add(copy);
                    }
                }
//                detailRespVo.setDetailBudgetVos(CrmBeanUtil.copyList(detailBudgetMap.get(detailRespVo.getActDetailCode()),TpmLiqueurActRegisterDetailBudgetRespVo.class));
                List<TpmLiqueurActRegisterDetailAttachRespVo> tpmLiqueurActRegisterDetailAttachRespVos = CrmBeanUtil.copyList(detailAttachMap.get(detailRespVo.getActDetailCode()), TpmLiqueurActRegisterDetailAttachRespVo.class);
                liqueurServiceHelper.setAttachPayTypes(tpmLiqueurActRegisterDetailAttachRespVos);
                detailRespVo.setAttachVos(tpmLiqueurActRegisterDetailAttachRespVos);
            });
        }
        respVo.setDetailVos(detailRespVos);
        liqueurServiceHelper.convertLiqueurActRegisterRespVo(respVo);
        return respVo;
    }

    /**
     * 新增
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    @Klock(keys = {"liqueurActRegister","#reqVo.lockUserName"},waitTime = 0,leaseTime = 5)
    public void save(TpmLiqueurActRegisterReqVo reqVo){
        reqVo.setId(null);
        reqVo.setApproveStatus(null);
        ActRegisterBaseBuilder builder = new ActRegisterBuilder(helper,reqVo);
        TpmLiqueurActRegisterEntity entity = builder.init()
                .check()
                .convert()
                .save();
        this.sendToActivity(entity,reqVo);
        //日志
        Object menuCodeObj = ThreadLocalUtil.getObj(GlobalParam.MENU_CODE);
        TpmLiqueurActRegisterRespVo newData = CrmBeanUtil.copy(entity, TpmLiqueurActRegisterRespVo.class);
        crmLogSendUtil.sendForAdd(menuCodeObj.toString(),newData.getId(),newData.getActRegisterCode(),newData);
    }

    /**
     * 更新
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    @Klock(keys = {"liqueurActRegister","#reqVo.lockUserName"},waitTime = 0,leaseTime = 5)
    public void update(TpmLiqueurActRegisterReqVo reqVo){
        //修改校验
        helper.updateCheck(reqVo);
        //日志老数据
        TpmLiqueurActRegisterEntity oldEntity = this.getById(reqVo.getId());
        TpmLiqueurActRegisterRespVo oldData = CrmBeanUtil.copy(oldEntity, TpmLiqueurActRegisterRespVo.class);
        AssertUtils.isNotNull(oldEntity, FeeBudgetException.DATA_NOT_EXIST);
        ActRegisterBaseBuilder builder = new ActRegisterBuilder(helper,reqVo);
        TpmLiqueurActRegisterEntity entity = builder.init()
                .check()
                .convert()
                .update();
        this.sendToActivity(entity,reqVo);
        Object menuCodeObj = ThreadLocalUtil.getObj(GlobalParam.MENU_CODE);
        TpmLiqueurActRegisterRespVo newData = CrmBeanUtil.copy(entity, TpmLiqueurActRegisterRespVo.class);
        //发送修改日志
        crmLogSendUtil.sendForUpdate(menuCodeObj.toString(),newData.getId(),newData.getActRegisterCode(),oldData,newData);

    }

    /**
     * 删除
     * @param ids
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(List<String> ids){
        AssertUtils.isNotEmpty(ids, CommonException.IDS_NULL);
        helper.deleteCheck(ids);
        List<TpmLiqueurActRegisterEntity> registerEntities = tpmLiqueurActRegisterMapper.selectBatchIds(ids);
        if(CollectionUtils.isNotEmpty(registerEntities)){
            //删除时需要做联表删除,left join
            tpmLiqueurActRegisterMapper.deleteBatchIds(ids);
            List<String> codes = registerEntities.stream().map(TpmLiqueurActRegisterEntity::getActRegisterCode).collect(Collectors.toList());
            detailMapper.delete(Wrappers.lambdaQuery(TpmLiqueurActRegisterDetailEntity.class).in(TpmLiqueurActRegisterDetailEntity::getActRegisterCode,codes));
            attachMapper.delete(Wrappers.lambdaQuery(TpmLiqueurActRegisterDetailAttachEntity.class).in(TpmLiqueurActRegisterDetailAttachEntity::getActRegisterCode,codes));
            detailBudgetMapper.delete(Wrappers.lambdaQuery(TpmLiqueurActRegisterDetailBudgetEntity.class).in(TpmLiqueurActRegisterDetailBudgetEntity::getActRegisterCode,codes));
            //日志
            Object menuCodeObj = ThreadLocalUtil.getObj(GlobalParam.MENU_CODE);
            for (TpmLiqueurActRegisterEntity oldData:registerEntities) {
                crmLogSendUtil.sendForDel(menuCodeObj.toString(),oldData.getId(),oldData.getActCode(),oldData);
            }
        }
    }

    /**
     * 启用
     * @param ids
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(List<String> ids){
        //设置状态为启用
        List<TpmLiqueurActRegisterEntity> tpmLiqueurActRegisterEntities = tpmLiqueurActRegisterMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty(tpmLiqueurActRegisterEntities)) {
            tpmLiqueurActRegisterEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(tpmLiqueurActRegisterEntities);
    }

    /**
     * 禁用
     * @param ids
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(List<String> ids){
        //设置状态为启用
        List<TpmLiqueurActRegisterEntity> tpmLiqueurActRegisterEntities = tpmLiqueurActRegisterMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty(tpmLiqueurActRegisterEntities)) {
            tpmLiqueurActRegisterEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(tpmLiqueurActRegisterEntities);
    }
    /**
     * 活动提交审批到工作流
     * @param entity
     * @param reqVo
     */
    @Transactional(rollbackFor = Exception.class)
    public void sendToActivity(TpmLiqueurActRegisterEntity entity , TpmLiqueurActRegisterReqVo reqVo){
        if(StringUtils.equals(ActApproveStatusEnum.APPROVING.getCode(),entity.getApproveStatus())){
            //提交审批
            StartProcessReqVo processReqVo=helper.buildStartProcessData(entity,reqVo);
            String processNo = ActivityUtils.startProcess(processReqVo);
            entity.setProcessCode(processNo);
            this.saveOrUpdate(entity);
        }
    }

    /**
     * 提交审批
     * @param reqVo
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    @Klock(keys = {"liqueurActRegister","#reqVo.lockUserName"},waitTime = 0,leaseTime = 5)
    public void approve(TpmLiqueurActRegisterReqVo reqVo) {
        //提交审批校验
        helper.approveCheck(reqVo);
        this.update(reqVo);
    }

    /**
     * 工作流审批回调
     * @param activitiCallBackVo
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void activityCallBack(ActivitiCallBackVo activitiCallBackVo) {
        TpmLiqueurActRegisterReqVo reqVo=new TpmLiqueurActRegisterReqVo();
        reqVo.setId(activitiCallBackVo.getFormNo());
        TpmActSendMessageVo actSendMessageVo = TpmActSendMessageVo.builder().actId(reqVo.getId()).actSystemType(TpmProjectNameEnum.LIQUEUR_TPM.getCode()).build();
        RocketMQMessageBody rocketMQMessageBody = RocketMQMessageBody.builder().topic(topic)
                .tag(RocketMQConstant.CRM_MQ_TAG.TPM_ACT_APPROVED_AND_CLOSED)
                .bizKey("tpm")
                .msgBody(JSON.toJSONString(actSendMessageVo)).build();
        //审批通过
        if(Indicator.CON_BPM_DOING.getCode()==activitiCallBackVo.getProcessState()){
            this.approved(reqVo);
            //发送活动审批通过的消息
            actSendMessageVo.setType(ActSendMessageTypeEnum.APPROVED.getCode());
            log.info("活动审批通过,发送MQ消息,messageBody={}",rocketMQMessageBody.getMsgBody());
            rocketMQProducer.convertAndSend(rocketMQMessageBody);
        }
        //审批驳回
        if(Indicator.CON_BPM_PASS.getCode()==activitiCallBackVo.getProcessState()){
            reqVo.setApproveStatus(ActApproveStatusEnum.REJECTED.getCode());
            this.rejectAndInterrupt(reqVo);
        }
        //流程追回
        if(Indicator.CON_BPM_REJECT.getCode()==activitiCallBackVo.getProcessState()){
            reqVo.setApproveStatus(ActApproveStatusEnum.INTERRUPT.getCode());
            this.rejectAndInterrupt(reqVo);
        }
    }

    /**
     * 审批通过
     * @param reqVo
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void approved(TpmLiqueurActRegisterReqVo reqVo) {
        helper.approved(reqVo);
    }

    /**
     * 审批驳回
     * @param reqVo
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void rejectAndInterrupt(TpmLiqueurActRegisterReqVo reqVo) {
        helper.rejectAndInterrupt(reqVo);
    }

    /**
     * 根据actCode查询酒类活动预算信息
     * @param reqVo
     * @return  List<TpmLiqueurActBudgetRespVo>
     */
    @Override
    public List<TpmFeeBudgetControlRespVo> findBudgetByActCode(TpmLiqueurActBudgetReqVo reqVo) {
        AssertUtils.isNotEmpty(reqVo.getActCode(), "活动编码不能为空");
        //当前活动状态为审批通过才继续，否则抛出错误信息
        TpmLiqueurActEntity tpmLiqueurActEntity = liqueurActMapper.selectOne(Wrappers.lambdaQuery(TpmLiqueurActEntity.class).eq(TpmLiqueurActEntity::getActCode, reqVo.getActCode()));
        AssertUtils.isNotNull(tpmLiqueurActEntity, "当前活动不存在");
        if (!StringUtils.equals(ActApproveStatusEnum.APPROVED.getCode(), tpmLiqueurActEntity.getApproveStatus())) {
            throw new BusinessException("活动编码：" + reqVo.getActCode() + "的活动，未通过审批");
        }
        List<TpmLiqueurActBudgetEntity> budgetEntities = budgetMapper.selectList(Wrappers.lambdaQuery(TpmLiqueurActBudgetEntity.class).eq(TpmLiqueurActBudgetEntity::getActCode, reqVo.getActCode()));
        AssertUtils.isNotEmpty(budgetEntities, "数据异常，活动预算为空");
        //map的key是控制维度id
        Map<String, List<TpmLiqueurActBudgetEntity>> controlIdMap = Maps.newHashMap();
        //map的key是控制维度id,存放控制维度的canUseAmount
        Map<String, BigDecimal> amountMap = Maps.newHashMap();
        //用于保存控制维度
        Set<String> controlIds = Sets.newHashSet();
        Set<String> budgetSubjectsCodes = Sets.newHashSet();
        budgetEntities.stream().forEach(budgetEntity -> {
            //以控制维度id把budgetEntities分组
            if (controlIdMap.containsKey(budgetEntity.getControlId())) {
                //map中存在此控制维度id，将数据存放到当前key中
                controlIdMap.get(budgetEntity.getControlId()).add(budgetEntity);
                //计算空控制维度的可用金额
                if (budgetEntity.getCanUseAmount() != null) {
                    BigDecimal canUseAmount = amountMap.get(budgetEntity.getControlId());
                    canUseAmount = canUseAmount.add(budgetEntity.getCanUseAmount());
                    amountMap.put(budgetEntity.getControlId(), canUseAmount);
                }
            } else {
                //map中不存在此控制维度id，新建key来存放
                List<TpmLiqueurActBudgetEntity> liqueurActBudgetEntitiesByControlId = Lists.newArrayList();
                liqueurActBudgetEntitiesByControlId.add(budgetEntity);
                controlIdMap.put(budgetEntity.getControlId(), liqueurActBudgetEntitiesByControlId);
                //新建Key来存放控制维度的canUseAmount
                BigDecimal canUseAmount = BigDecimal.ZERO;
                if (budgetEntity.getCanUseAmount() != null) {
                    canUseAmount = canUseAmount.add(budgetEntity.getCanUseAmount());
                }
                amountMap.put(budgetEntity.getControlId(), canUseAmount);
            }
            budgetSubjectsCodes.add(budgetEntity.getBudgetSubjectsCode());
            controlIds.add(budgetEntity.getControlId());
        });
        //budgetSubjectsCode以为key
        Map<String, TpmBudgetSubjectsEntity> budgetSubjectsMap = budgetSubjectsMapper.selectList(Wrappers.lambdaQuery(TpmBudgetSubjectsEntity.class).in(TpmBudgetSubjectsEntity::getBudgetSubjectsCode, budgetSubjectsCodes))
                .stream()
                .collect(Collectors.toMap(TpmBudgetSubjectsEntity::getBudgetSubjectsCode, Function.identity()));
        //查询控制维度集合
        List<TpmFeeBudgetControlRespVo> budgetControlRespVos = CrmBeanUtil.copyList(budgetControlMapper.selectList(Wrappers.lambdaQuery(TpmFeeBudgetControlEntity.class).in(TpmFeeBudgetControlEntity::getId, controlIds)), TpmFeeBudgetControlRespVo.class);
        Map<String, String> dictYear = DictUtil.dictMap(TpmGlobalDictConstants.BUDGET_YEAR);
        Map<String, String> dictQuater = DictUtil.dictMap(TpmGlobalDictConstants.BUDGET_QUATER);
        if (CollectionUtils.isNotEmpty(budgetControlRespVos)) {
            budgetControlRespVos.stream().forEach(budgetControl -> {
                //为控制维度赋值（可用余额、酒类费用预算集合）
                budgetControl.setCanUseAmount(amountMap.get(budgetControl.getId()));
                budgetControl.setLiqueurBudgetVos(CrmBeanUtil.copyList(controlIdMap.get(budgetControl.getId()), TpmLiqueurActBudgetRespVo.class));
                budgetControl.setBudgetYearName(com.biz.crm.util.StringUtils.isEmpty(budgetControl.getBudgetYear()) ? null : dictYear.get(budgetControl.getBudgetYear()));
                budgetControl.setBudgetQuaterName(com.biz.crm.util.StringUtils.isEmpty(budgetControl.getBudgetQuater()) ? null : dictQuater.get(budgetControl.getBudgetQuater()));
                //获取客户信息
                if (com.biz.crm.util.StringUtils.isNotEmpty(budgetControl.getCustomerCode())) {
                    Result<MdmCustomerMsgRespVo> customerMsgRespVoResult = mdmCustomerMsgFeign.query(null, budgetControl.getCustomerCode());
                    AssertUtils.isTrue(customerMsgRespVoResult.isSuccess(), "获取客户信息失败");
                    budgetControl.setCustomerName(customerMsgRespVoResult.getResult().getCustomerName());
                }
                //获取产品信息
                if (com.biz.crm.util.StringUtils.isNotEmpty(budgetControl.getProductCode())) {
                    Result<MdmProductRespVo> productRespVoResult = mdmProductFeign.detail(null,budgetControl.getProductCode());
                    AssertUtils.isTrue(productRespVoResult.isSuccess(), "获取产品信息失败");
                    budgetControl.setCustomerName(productRespVoResult.getResult().getProductName());
                }
            });
        }
        //过滤掉活动预算可用为零的预算(根据controlType判断,如果控制类型为不控制,可用余额小于零也可以返回给前端,其他必须大于零)
        budgetControlRespVos = budgetControlRespVos.stream().filter(budgetControlRespVo -> {
            TpmBudgetSubjectsEntity budgetSubjectsEntity = budgetSubjectsMap.get(budgetControlRespVo.getBudgetSubjectsCode());
            AssertUtils.isTrue(ObjectUtils.isNotEmpty(budgetSubjectsEntity), "数据异常,未找到对应的预算科目");
            AssertUtils.isNotEmpty(budgetSubjectsEntity.getControlType(), "数据异常,对应预算科目控制类型未空");
            budgetControlRespVo.setBudgetSubjectsName(budgetSubjectsEntity.getBudgetSubjectsName());
            budgetControlRespVo.setControlType(budgetSubjectsEntity.getControlType());
            //控制类型为不控制
            if (BudgetSubjectsControlTypeEnum.NON.getCode().equals(budgetControlRespVo.getControlType())) {
                return true;
                //可用金额大于0
            } else if (budgetControlRespVo.getCanUseAmount().compareTo(BigDecimal.ZERO) == 1) {
                return true;
            }
            return false;
        }).collect(Collectors.toList());
        return budgetControlRespVos;
    }

    @Override
    public PageResult<TpmCostTypeCategoriesRespVo> findCategoriesBySubjectCodes(TpmLiqueurActRegisterDetailReqVo reqVo) {
        AssertUtils.isNotEmpty(reqVo.getBudgetSubjectsCodes(),"请先选择费用预算");
        List<String> subjectCodes = reqVo.getBudgetSubjectsCodes();
        Page<TpmCostTypeCategoriesEntity> page = PageUtil.buildPage(reqVo.getPageNum(),reqVo.getPageSize());
        page = costTypeCategoriesMapper.selectPage(page, Wrappers.lambdaQuery(TpmCostTypeCategoriesEntity.class).in(TpmCostTypeCategoriesEntity::getBudgetSubjectsCode, subjectCodes));
        List<TpmCostTypeCategoriesRespVo> respVos = CrmBeanUtil.copyList(page.getRecords(), TpmCostTypeCategoriesRespVo.class);
        categoriesServiceHelper.convertListDate(respVos);
        return PageResult.<TpmCostTypeCategoriesRespVo>builder()
                .data(respVos)
                .count(page.getTotal())
                .build();
    }
}
