package com.biz.crm.liqueuract.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.act.service.impl.ActServiceHelper;
import com.biz.crm.activiti.act.TaActBaseFeign;
import com.biz.crm.annotation.Klock;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.budgetsubjects.mapper.TpmBudgetSubjectsMapper;
import com.biz.crm.budgetsubjects.model.TpmBudgetSubjectsEntity;
import com.biz.crm.common.GlobalParam;
import com.biz.crm.common.PageResult;
import com.biz.crm.costtypecategories.mapper.TpmCostTypeCategoriesFineMapper;
import com.biz.crm.costtypecategories.mapper.TpmCostTypeCategoriesMapper;
import com.biz.crm.costtypecategories.model.TpmCostTypeCategoriesEntity;
import com.biz.crm.costtypecategories.model.TpmCostTypeCategoriesFineEntity;
import com.biz.crm.costtypefine.mapper.TpmCostTypeFineMapper;
import com.biz.crm.costtypefine.service.ITpmCostTypeFineService;
import com.biz.crm.crmlog.handle.util.CrmLogSendUtil;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.GlobalWhetherEnum;
import com.biz.crm.eunm.activiti.Indicator;
import com.biz.crm.eunm.tpm.ActApproveStatusEnum;
import com.biz.crm.eunm.tpm.ActSaveTypeEnum;
import com.biz.crm.eunm.tpm.ActSendMessageTypeEnum;
import com.biz.crm.eunm.tpm.TpmProjectNameEnum;
import com.biz.crm.exception.CommonException;
import com.biz.crm.exception.tpm.FeeBudgetException;
import com.biz.crm.feebudget.mapper.TpmFeeBudgetControlMapper;
import com.biz.crm.feebudget.service.impl.TpmFeeBudgetControlServiceImpl;
import com.biz.crm.liqueuract.mapper.TpmLiqueurActBudgetMapper;
import com.biz.crm.liqueuract.mapper.TpmLiqueurActBudgetTransactionMapper;
import com.biz.crm.liqueuract.mapper.TpmLiqueurActFileMapper;
import com.biz.crm.liqueuract.mapper.TpmLiqueurActMapper;
import com.biz.crm.liqueuract.model.*;
import com.biz.crm.liqueuract.service.TpmLiqueurActService;
import com.biz.crm.liqueuract.service.impl.actbuilder.ActBaseBuilder;
import com.biz.crm.liqueuract.service.impl.actbuilder.LiqueurActBuilder;
import com.biz.crm.mdm.customer.MdmCustomerMsgFeign;
import com.biz.crm.mdm.org.MdmOrgFeign;
import com.biz.crm.mq.RocketMQConstant;
import com.biz.crm.mq.RocketMQMessageBody;
import com.biz.crm.mq.RocketMQProducer;
import com.biz.crm.nebular.activiti.act.ActivitiCallBackVo;
import com.biz.crm.nebular.activiti.act.req.StartProcessReqVo;
import com.biz.crm.nebular.activiti.common.ProcessCommonVo;
import com.biz.crm.nebular.mdm.common.BaseTreeRespVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.humanarea.MdmCustomerOrgSearchReqVo;
import com.biz.crm.nebular.mdm.org.req.BaseOrgTreeReqVo;
import com.biz.crm.nebular.mdm.org.req.MdmOrgReqVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.tpm.act.req.ActGetCategoriesByBudgetReqVo;
import com.biz.crm.nebular.tpm.act.req.ActGetCustomerCodeByOrgCodeReqVo;
import com.biz.crm.nebular.tpm.act.req.TpmActReqVo;
import com.biz.crm.nebular.tpm.act.req.TpmActSendMessageVo;
import com.biz.crm.nebular.tpm.costtypefine.req.TpmCostDutyOrgReqVo;
import com.biz.crm.nebular.tpm.costtypefine.req.TpmCostTypeFineReqVo;
import com.biz.crm.nebular.tpm.costtypefine.resp.TpmCostTypeFineRespVo;
import com.biz.crm.nebular.tpm.feebudget.req.TpmFeeBudgetControlReqVo;
import com.biz.crm.nebular.tpm.feebudget.resp.TpmFeeBudgetControlRespVo;
import com.biz.crm.nebular.tpm.feebudget.resp.TpmFeeBudgetRespVo;
import com.biz.crm.nebular.tpm.liqueuract.req.TpmLiqueurActReqVo;
import com.biz.crm.nebular.tpm.liqueuract.resp.TpmLiqueurActRespVo;
import com.biz.crm.util.*;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

import static java.util.stream.Stream.builder;

/**
 * @author maoshen
 * @date 2021/3/3.
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="TpmLiqueurActServiceExpandImpl")
public class TpmLiqueurActServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<TpmLiqueurActMapper, TpmLiqueurActEntity> implements TpmLiqueurActService {
    @Resource
    private TpmLiqueurActMapper tpmLiqueurActMapper;
    @Autowired
    private TpmLiqueurServiceHelper helper;
    @Resource
    private TaActBaseFeign activityFeign;
    @Resource
    private MdmCustomerMsgFeign customerMsgFeign;

    @Resource
    private TpmBudgetSubjectsMapper budgetSubjectsMapper;
    @Resource
    private TpmCostTypeCategoriesFineMapper categoriesFineMapper;

    @Resource
    private TpmCostTypeCategoriesMapper costTypeCategoriesMapper;
    @Resource
    private MdmOrgFeign orgFeign;

    @Autowired
    private ITpmCostTypeFineService costTypeFineService;

    @Autowired
    private TpmFeeBudgetControlServiceImpl feeBudgetControlService;

    @Resource
    private TpmFeeBudgetControlMapper controlMapper;

    @Resource
    private RocketMQProducer rocketMQProducer;

    @Autowired
    private CrmLogSendUtil crmLogSendUtil;

    @Resource
    private TpmCostTypeFineMapper fineMapper;
    @Resource
    private TpmLiqueurActFileMapper actFileMapper;
    @Resource
    private TpmLiqueurActBudgetTransactionMapper actBudgetTransactionMapper;
    @Resource
    private TpmLiqueurActBudgetMapper actBudgetMapper;

    @Value("${rocketmq.topic}" + "${rocketmq.environment-variable}")
    private String topic;
    /**
     *
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<TpmLiqueurActRespVo> findList(TpmLiqueurActReqVo reqVo) {
        Page<TpmLiqueurActRespVo> page = new Page<>(reqVo.getPageNum(), reqVo.getPageSize());
        List<TpmLiqueurActRespVo> list = tpmLiqueurActMapper.findList(page, reqVo);
        if (CollectionUtils.isNotEmpty(list)){
            helper.setRespVoData(list);
        }
        return PageResult.<TpmLiqueurActRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }


    /**
     * 查看
     * @param id
     * @return
     */
    @Override
    public TpmLiqueurActRespVo query(String id) {
        AssertUtils.isNotEmpty(id, CommonException.IDS_NULL);
        TpmLiqueurActReqVo reqVo = new TpmLiqueurActReqVo();
        reqVo.setId(id);
        List<TpmLiqueurActRespVo> actRespVoList = this.findList(reqVo).getData();
        if (CollectionUtils.isEmpty(actRespVoList)){
            throw new BusinessException("查询数据不存在");
        }
        TpmLiqueurActRespVo actRespVo = actRespVoList.get(0);
        helper.convertCusAndOrgData(actRespVo);
        // 查询活动预算
        helper.setBudgetData(actRespVo);
        // 设置 附件
        helper.setActFileData(actRespVo);
        return actRespVo;
    }

    /**
     * 新增
     * @param tpmLiqueurActReqVo
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    @Klock(keys = {"liqueurAct","#tpmLiqueurActReqVo.lockUserName"},waitTime = 0,leaseTime = 5)
    public void save(TpmLiqueurActReqVo tpmLiqueurActReqVo) {
        ActBaseBuilder actOperateBuilder = new LiqueurActBuilder(helper,tpmLiqueurActReqVo);
        TpmLiqueurActEntity liqueurActEntity = actOperateBuilder.init()
                .check()
                .convert()
                .save();
        this.sendToActivity(liqueurActEntity,tpmLiqueurActReqVo);
        //日志
        Object menuCodeObj = ThreadLocalUtil.getObj(GlobalParam.MENU_CODE);
        TpmLiqueurActRespVo newData = CrmBeanUtil.copy(liqueurActEntity, TpmLiqueurActRespVo.class);
        crmLogSendUtil.sendForAdd(Objects.isNull(menuCodeObj) ? "":menuCodeObj.toString(),newData.getId(),newData.getActCode(),newData);
    }

    /**
     * 活动提交审批
     * @param liqueurActEntity
     * @param tpmLiqueurActReqVo
     */
    private void sendToActivity(TpmLiqueurActEntity liqueurActEntity, TpmLiqueurActReqVo tpmLiqueurActReqVo) {

        if(StringUtils.equals(ActApproveStatusEnum.APPROVING.getCode(),liqueurActEntity.getApproveStatus())){
            //提交审批
            StartProcessReqVo processReqVo=helper.buildStartProcessData(liqueurActEntity,tpmLiqueurActReqVo);
            String processNo = ActivityUtils.startProcess(processReqVo);
            liqueurActEntity.setProcessCode(processNo);
            this.saveOrUpdate(liqueurActEntity);
            }
    }

    /**
     * 根据 登录 人 和是否选择 跨组织 来 获取组织List
     * @param tpmCostDutyOrgReqVo
     * @return
     */
    @Override
    public List<MdmOrgRespVo> getOrgList(TpmCostDutyOrgReqVo tpmCostDutyOrgReqVo) {
        //得到当前登陆人
        UserRedis userRedis = UserUtils.getUser();
        MdmOrgReqVo mdmOrgReqVo = new MdmOrgReqVo();
        //当前登陆人的所属组织
        mdmOrgReqVo.setOrgCode(userRedis.getOrgcode());
        mdmOrgReqVo.setPageNum(tpmCostDutyOrgReqVo.getPageNum());
        mdmOrgReqVo.setPageSize(tpmCostDutyOrgReqVo.getPageSize());
        mdmOrgReqVo.setOrgName(tpmCostDutyOrgReqVo.getOrgName());
        Result<List<MdmOrgRespVo>> respVos = null;
        //查询fineCode对应的活动
        List<TpmCostTypeFineRespVo> data = costTypeFineService.findList(new TpmCostTypeFineReqVo().setFineCode(tpmCostDutyOrgReqVo.getFineCode())).getData();
        AssertUtils.isNotEmpty(data,"您选择的活动类型数据不存在["+tpmCostDutyOrgReqVo.getFineCode()+"]");
        //得到是否跨组织运算标记
        String isSpanOrgBudget = data.get(0).getIsSpanOrgBudget();
        MdmOrgRespVo parentOrg = new MdmOrgRespVo();
        //不允许跨组织占用预算
        if (StringUtils.equals(isSpanOrgBudget, GlobalWhetherEnum.NO.getCode()) || StringUtils.isBlank(isSpanOrgBudget)) {
            try {
                respVos = orgFeign.findAllChildrenOrgList(mdmOrgReqVo);
            } catch (Exception e) {
                log.error("{}", e);
                throw new BusinessException("调用mdm接口失败");
            }
            return ApiResultUtil.objResult(respVos);
        }
        //允许跨组织占用预算
        try {
            //查询当前登陆人所在组织的上级组织
             parentOrg = ApiResultUtil.objResult(orgFeign.findSingleParentOrg(mdmOrgReqVo), true);
            if (parentOrg != null){
                mdmOrgReqVo.setOrgCode(parentOrg.getOrgCode());
            }
            //得到所在组织层级及以下的所有组织(包含一个直接上级组织)
            respVos = orgFeign.findAllChildrenOrgList(mdmOrgReqVo);
        } catch (Exception e) {
            log.error("{}", e);
            throw new BusinessException("调用mdm接口失败");
        }
        //过滤掉直接直接上次组织
        List<MdmOrgRespVo> list = Lists.newArrayList();
        if (parentOrg ==null){
             return ApiResultUtil.objResult(respVos);
        }
        list = ApiResultUtil.objResult(respVos).stream()
                .filter(org -> !org.getOrgCode().equals(mdmOrgReqVo.getOrgCode()))
                .collect(Collectors.toList());
        return list;
    }

    /**
     * 活动新增查询责任组织树
     * @param tpmCostDutyOrgReqVo
     * @return
     */
    @Override
    public List<BaseTreeRespVo> getOrgTree(TpmCostDutyOrgReqVo tpmCostDutyOrgReqVo) {
        //得到当前登陆人
        UserRedis userRedis = UserUtils.getUser();
        BaseOrgTreeReqVo treeReqVo = new BaseOrgTreeReqVo();
        //查询fineCode对应的活动
        List<TpmCostTypeFineRespVo> data = costTypeFineService.findList(new TpmCostTypeFineReqVo().setFineCode(tpmCostDutyOrgReqVo.getFineCode())).getData();
        AssertUtils.isNotEmpty(data,"您选择的活动类型数据不存在["+tpmCostDutyOrgReqVo.getFineCode()+"]");
        //得到是否跨组织运算标记
        String isSpanOrgBudget = data.get(0).getIsSpanOrgBudget();
        if (StringUtils.equals(isSpanOrgBudget, GlobalWhetherEnum.NO.getCode()) || StringUtils.isBlank(isSpanOrgBudget)) {
            //如果不允许跨组织的时候查登录人的所有下级组织树
            treeReqVo.setIncludeCodeAndChildren(userRedis.getOrgcode());
        }else {
            //如果允许跨组织,则获取登录人的上级组织
            MdmOrgRespVo orgByCode = OrgUtil.getOrgByCode(userRedis.getOrgcode());
            treeReqVo.setIncludeCodeAndChildren(orgByCode.getParentCode());
        }
        Result<List<BaseTreeRespVo>> listResult = orgFeign.orgTree(treeReqVo);
        List<BaseTreeRespVo> baseTreeRespVos = ApiResultUtil.objResult(listResult, true);
        return baseTreeRespVos;
    }

    /**
     * 活动新增根据组织获取客户列表
     *
     * @param reqVo
     * @return
     */
    @Override
    public List<MdmCustomerMsgRespVo> getCustomerMsgByOrgCodes(ActGetCustomerCodeByOrgCodeReqVo reqVo) {
        AssertUtils.isNotEmpty(reqVo.getOrgCodeList(), "请选择组织");
        MdmCustomerOrgSearchReqVo mdmCustomerOrgSearchReqVo = new MdmCustomerOrgSearchReqVo();
        mdmCustomerOrgSearchReqVo.setCustomerCodeOrName(reqVo.getCustomerCodeOrName());
        mdmCustomerOrgSearchReqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        mdmCustomerOrgSearchReqVo.setLockState(CrmEnableStatusEnum.ENABLE.getCode());
        mdmCustomerOrgSearchReqVo.setPageSize(reqVo.getPageSize());
        mdmCustomerOrgSearchReqVo.setOrgCodeList(reqVo.getOrgCodeList());
        Result<List<MdmCustomerMsgRespVo>> currentAndSubCustomerList = null;
        try {
            currentAndSubCustomerList = customerMsgFeign.findCurrentAndSubCustomerList(mdmCustomerOrgSearchReqVo);
        } catch (Exception e) {
            log.error("{}", e);
            throw new BusinessException("活动新增根据组织获取客户列表,调用mdm接口失败");
        }
        List<MdmCustomerMsgRespVo> respVos =  ApiResultUtil.objResult(currentAndSubCustomerList, true);
        return respVos;
    }

    /**
     * 活动类型、活动时间、责任组织、所属客户
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<TpmFeeBudgetControlRespVo> findBudgetController(TpmLiqueurActReqVo reqVo) {
        AssertUtils.isNotEmpty(reqVo.getBeginDate(),"活动开始时间不能为空");
        AssertUtils.isNotEmpty(reqVo.getEndDate(),"活动结束时间不能为空");
        TpmFeeBudgetControlReqVo tpmFeeBudgetControlReqVo = new TpmFeeBudgetControlReqVo();
        Page<TpmFeeBudgetControlRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        tpmFeeBudgetControlReqVo.setActBeginDate(reqVo.getBeginDate());
        tpmFeeBudgetControlReqVo.setActEndDate(reqVo.getEndDate());
        Set<String> selectKeys = feeBudgetControlService.getSelectKeys(tpmFeeBudgetControlReqVo);
        tpmFeeBudgetControlReqVo.setSelectKeys(selectKeys);
        List<TpmCostTypeCategoriesFineEntity> categoriesFineEntities =categoriesFineMapper.selectList(Wrappers.<TpmCostTypeCategoriesFineEntity>lambdaQuery()
                .eq(TpmCostTypeCategoriesFineEntity::getFineCode,reqVo.getFineCode()));
        AssertUtils.isNotEmpty(categoriesFineEntities,"活动类型没有关联信息");
        Set<String> categoriesCodes = categoriesFineEntities.stream().map(TpmCostTypeCategoriesFineEntity::getCategoriesCode).collect(Collectors.toSet());
        List<TpmCostTypeCategoriesEntity> categoriesEntities = costTypeCategoriesMapper.selectList(Wrappers.<TpmCostTypeCategoriesEntity>lambdaQuery()
                .in(TpmCostTypeCategoriesEntity::getCategoriesCode,categoriesCodes)
                .eq(TpmCostTypeCategoriesEntity::getEnableStatus,CrmEnableStatusEnum.ENABLE.getCode()));
        AssertUtils.isNotEmpty(categoriesEntities,"关联投入类型数据不存在或被禁用");
        Set<String> budgetSubjectsSet = categoriesEntities.stream().map(TpmCostTypeCategoriesEntity::getBudgetSubjectsCode).collect(Collectors.toSet());
        AssertUtils.isNotEmpty(budgetSubjectsSet,"投入类型没有关联预算科目，无法选择预算");
        List<TpmBudgetSubjectsEntity> subjectsEntities = budgetSubjectsMapper.selectList(Wrappers.<TpmBudgetSubjectsEntity>lambdaQuery()
                .in(TpmBudgetSubjectsEntity::getBudgetSubjectsCode,budgetSubjectsSet)
                .eq(TpmBudgetSubjectsEntity::getEnableStatus,CrmEnableStatusEnum.ENABLE.getCode()));
        AssertUtils.isNotEmpty(subjectsEntities,"预算科目数据不存在或被禁用");
        Set<String> budgetSubjectCodes = subjectsEntities.stream().map(TpmBudgetSubjectsEntity::getBudgetSubjectsCode).collect(Collectors.toSet());
        tpmFeeBudgetControlReqVo.setOrgCodeList(reqVo.getOrgCodeList());
        tpmFeeBudgetControlReqVo.setCustomerCodeList(reqVo.getCustomerCodeList());
        tpmFeeBudgetControlReqVo.setBudgetSubjectsCodeList(Lists.newArrayList(budgetSubjectCodes));
        List<TpmFeeBudgetControlRespVo> respVoList = controlMapper.findControlList(page,tpmFeeBudgetControlReqVo);
        feeBudgetControlService.convertListData(respVoList);
        return PageResult.<TpmFeeBudgetControlRespVo>builder()
                .data(respVoList)
                .count(page.getTotal())
                .build();
    }



    /**
     * 修改
     * @param tpmLiqueurActReqVo
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    @Klock(keys = {"liqueurAct","#tpmLiqueurActReqVo.lockUserName"},waitTime = 0,leaseTime = 5)
    public void update(TpmLiqueurActReqVo tpmLiqueurActReqVo) {
        helper.checkUpdate(tpmLiqueurActReqVo);
        ActBaseBuilder actOperateBuilder = new LiqueurActBuilder(helper,tpmLiqueurActReqVo);
        //日志老数据
        TpmLiqueurActEntity entity = this.getById(tpmLiqueurActReqVo.getId());
        TpmLiqueurActRespVo oldData = CrmBeanUtil.copy(entity, TpmLiqueurActRespVo.class);
        AssertUtils.isNotNull(entity, FeeBudgetException.DATA_NOT_EXIST);
        TpmLiqueurActEntity liqueurActEntity = actOperateBuilder.init()
                .check()
                .convert()
                .update();
        this.sendToActivity(liqueurActEntity,tpmLiqueurActReqVo);
        Object menuCodeObj = ThreadLocalUtil.getObj(GlobalParam.MENU_CODE);
        TpmLiqueurActRespVo newData = CrmBeanUtil.copy(liqueurActEntity, TpmLiqueurActRespVo.class);
        //发送修改日志
        crmLogSendUtil.sendForUpdate(Objects.isNull(menuCodeObj) ? "":menuCodeObj.toString(),newData.getId(),newData.getActCode(),oldData,newData);
    }

    /**
     * 物理删除
     *    只有暂存的才可以删除
     * @param ids
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void deleteBatch(List<String> ids) {
        AssertUtils.isNotEmpty(ids,CommonException.IDS_NULL);
        List<TpmLiqueurActEntity> entities = tpmLiqueurActMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty(entities)){
            List<String> needDeleteIds = Lists.newArrayList();
            List<String> cannotDeleteCodes = Lists.newArrayList();
            List<String> actCodes = Lists.newArrayList();
            entities.forEach(o->{
                if (o.getApproveStatus().equals(ActApproveStatusEnum.CREATE.getCode()) || StringUtils.isBlank(o.getApproveStatus())){
                   needDeleteIds.add(o.getId());
                }else {
                    cannotDeleteCodes.add(o.getActCode());
                }
                actCodes.add(o.getActCode());
            });
            if (CollectionUtils.isNotEmpty(cannotDeleteCodes)){
                throw new BusinessException("活动申请编码为"+cannotDeleteCodes.toString()+"的活动不为待提交状态,不可删除");
            }
            this.removeByIds(needDeleteIds);
            actBudgetMapper.delete(Wrappers.lambdaQuery(TpmLiqueurActBudgetEntity.class).in(TpmLiqueurActBudgetEntity::getActCode,actCodes));
            actBudgetTransactionMapper.delete(Wrappers.lambdaQuery(TpmLiqueurActBudgetTransactionEntity.class).in(TpmLiqueurActBudgetTransactionEntity::getBusinessCode,actCodes));
            actFileMapper.delete(Wrappers.lambdaQuery(TpmLiqueurActFileEntity.class).in(TpmLiqueurActFileEntity::getActCode,actCodes));
            //日志
            Object menuCodeObj = ThreadLocalUtil.getObj(GlobalParam.MENU_CODE);
            for (TpmLiqueurActEntity oldData:entities) {
                crmLogSendUtil.sendForDel(Objects.isNull(menuCodeObj) ? "":menuCodeObj.toString(),oldData.getId(),oldData.getActCode(),oldData);
            }
        }
    }

    /**
     * 启用
     * @param ids
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void enableBatch(List<String> ids) {
        AssertUtils.isNotEmpty(ids,CommonException.IDS_NULL);
        List<TpmLiqueurActEntity> entities = tpmLiqueurActMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty(entities)){
            entities.forEach(x->{
                x.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
            this.updateBatchById(entities);
        }

    }

    /**
     * 禁用
     * @param ids
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void disableBatch(List<String> ids) {
        AssertUtils.isNotEmpty(ids,CommonException.IDS_NULL);
        List<TpmLiqueurActEntity> entities = tpmLiqueurActMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty(entities)){
            entities.forEach(x->{
                x.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
            this.updateBatchById(entities);
        }
    }

    /**
     * 活动关闭
     * @param tpmLiqueurActReqVo
     */
    @Klock(keys = {"liqueurAct","#tpmLiqueurActReqVo.lockUserName"},waitTime = 0,leaseTime = 5)
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void closed(TpmLiqueurActReqVo tpmLiqueurActReqVo) {
        List<TpmLiqueurActEntity> entities = helper.closed(tpmLiqueurActReqVo);
        this.updateBatchById(entities);
    }

    /**
     * 提交审批
     * @param tpmLiqueurActReqVo
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    @Klock(keys = {"liqueurAct","#tpmLiqueurActReqVo.lockUserName"},waitTime = 0,leaseTime = 5)
    public void approve(TpmLiqueurActReqVo tpmLiqueurActReqVo) {
        helper.approve(tpmLiqueurActReqVo);
        this.update(tpmLiqueurActReqVo);
    }

    /**
     * 审批通过
     * @param tpmLiqueurActReqVo
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void approved(TpmLiqueurActReqVo tpmLiqueurActReqVo) {
        helper.approved(tpmLiqueurActReqVo);
    }

    /**
     * 审批驳回
     * @param tpmLiqueurActReqVo
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void reject(TpmLiqueurActReqVo tpmLiqueurActReqVo) {
        tpmLiqueurActReqVo.setSaveType(ActSaveTypeEnum.REJECT.getCode());
        helper.reject(tpmLiqueurActReqVo);
    }

    /**
     * 流程追回
     * @param tpmLiqueurActReqVo
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void interrupt(TpmLiqueurActReqVo tpmLiqueurActReqVo) {
        tpmLiqueurActReqVo.setSaveType(ActSaveTypeEnum.INTERRUPT.getCode());
        helper.interrupt(tpmLiqueurActReqVo);
    }

    /**
     * 回退
     * @param activitiCallBackVo
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void activityCallBack(ActivitiCallBackVo activitiCallBackVo) {
        TpmLiqueurActReqVo reqVo=new TpmLiqueurActReqVo();
        reqVo.setId(activitiCallBackVo.getFormNo());
        TpmActSendMessageVo actSendMessageVo = TpmActSendMessageVo.builder().actId(reqVo.getId()).actSystemType(TpmProjectNameEnum.LIQUEUR_TPM.getCode()).build();
        RocketMQMessageBody rocketMQMessageBody = RocketMQMessageBody.builder().topic(topic)
                .tag(RocketMQConstant.CRM_MQ_TAG.TPM_ACT_APPROVED_AND_CLOSED)
                .bizKey("liqueurTpm")
                .msgBody(JSON.toJSONString(actSendMessageVo)).build();
        //审批通过
        if(Indicator.CON_BPM_DOING.getCode()==activitiCallBackVo.getProcessState()){
            this.approved(reqVo);
            //发送活动审批通过的消息
            actSendMessageVo.setType(ActSendMessageTypeEnum.APPROVED.getCode());
            log.info("活动审批通过,发送MQ消息,messageBody={}",rocketMQMessageBody.getMsgBody());
            rocketMQProducer.convertAndSend(rocketMQMessageBody);
        }
        //审批驳回
        if(Indicator.CON_BPM_PASS.getCode()==activitiCallBackVo.getProcessState()){
            reqVo.setApproveStatus(ActApproveStatusEnum.REJECTED.getCode());
            this.reject(reqVo);
        }
        //流程追回
        if(Indicator.CON_BPM_REJECT.getCode()==activitiCallBackVo.getProcessState()){
            reqVo.setApproveStatus(ActApproveStatusEnum.INTERRUPT.getCode());
            this.interrupt(reqVo);
        }
    }

    /**
     * 活动管理新增下拉选择活动类型接口
     * @param reqVo
     * @return
     */
    @Override
    public List<TpmCostTypeFineRespVo> getFineList(ActGetCategoriesByBudgetReqVo reqVo) {
        UserRedis user = UserUtils.getUser();
        if (Objects.nonNull(user)) {
//            AssertUtils.isTrue(StringUtils.isEmpty(user.getOrgcode())|| Objects.isNull(user.getType()),"当前登录人组织信息不完整");
            List<String> rangeCodes = Lists.newArrayList();
            //由于组织类型和组织的编码本身就不一样,所以直接放到集合去匹配范围就行了
            if (StringUtils.isNotEmpty(user.getOrgcode())) {
                rangeCodes.add(user.getOrgcode());
                MdmOrgRespVo orgByCode = OrgUtil.getOrgByCode(user.getOrgcode());
                AssertUtils.isNotNull(orgByCode, "当前用户的组织不存在");
                if (StringUtils.isNotEmpty(orgByCode.getOrgType())) {
                    rangeCodes.add(orgByCode.getOrgType());
                }
            }
            reqVo.setRangeCodes(rangeCodes);
        }
        List<TpmCostTypeFineRespVo> respVos=fineMapper.liqueurGetFineList(reqVo);
        return respVos;
    }
}
