package com.biz.crm.sale.mapper;

import com.biz.crm.interceptor.SqlPrivilege;
import com.biz.crm.nebular.tpm.sale.req.TpmSalesDataReqVo;
import com.biz.crm.nebular.tpm.sale.resp.TpmSalesDataRespVo;
import com.biz.crm.sale.model.TpmSalesDataEntity;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.ibatis.annotations.Param;
import java.util.List;

/**
 * 实际销售数据 
 * 
 * @author jerry7
 * @date 2021-04-28 15:32:39
 */
public interface TpmSalesDataMapper extends BaseMapper<TpmSalesDataEntity> {
    /**
     * 列表
     * @param page
     * @param tpmSalesDataReqVo
     * @return
     */
    @SqlPrivilege(posCode = "create_pos_code",orgCode = "create_org_code")
    List<TpmSalesDataRespVo> findList(Page<TpmSalesDataRespVo> page, @Param("vo") TpmSalesDataReqVo tpmSalesDataReqVo);

}
