package com.biz.crm.sale.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExt20Entity;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.Getter;
import lombok.Setter;
import lombok.EqualsAndHashCode;
import com.biz.crm.base.CrmBaseEntity;

import java.math.BigDecimal;
import java.util.Date;

import lombok.experimental.Accessors;

/**
 * 实际销售数据 实体类
 *
 * @author jerry7
 * @date 2021-04-28 15:32:39
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("tpm_sales_data")
@CrmTable(name = "tpm_sales_data", tableNote = "实际销售数据 ")
public class TpmSalesDataEntity extends CrmExt20Entity<TpmSalesDataEntity> {




    /**
     * 岗位编码
     */
    @CrmColumn(name = "position_code", length = 32, note = "岗位编码")
    private String positionCode;


    /**
     * 岗位名称
     */
    @CrmColumn(name = "position_name", length = 64, note = "岗位名称")
    private String positionName;


    /**
     * 订单编号
     */
    @CrmColumn(name = "order_sn", length = 32, note = "订单编号")
    private String orderSn;


    /**
     * 年份
     */
    @CrmColumn(name = "rs_year", length = 32, note = "年份")
    private String rsYear;


    /**
     * 月份
     */
    @CrmColumn(name = "rs_month", length = 32, note = "月份")
    private String rsMonth;


    /**
     * 客户编码
     */
    @CrmColumn(name = "customer_code", length = 32, note = "客户编码")
    private String customerCode;


    /**
     * 客户名称
     */
    @CrmColumn(name = "customer_name", length = 64, note = "客户名称")
    private String customerName;


    /**
     * 门店编码
     */
    @CrmColumn(name = "terminal_code", length = 32, note = "门店编码")
    private String terminalCode;


    /**
     * 门店名称
     */
    @CrmColumn(name = "terminal_name", length = 32, note = "门店名称")
    private String terminalName;


    /**
     * 产品编码
     */
    @CrmColumn(name = "product_code", length = 32, note = "产品编码")
    private String productCode;


    /**
     * 产品名称
     */
    @CrmColumn(name = "product_name", length = 64, note = "产品名称")
    private String productName;


    /**
     * 数量
     */
    @CrmColumn(name = "num", mysqlType = "int(10)", oracleType = "NUMBER(10,0)", note = "数量")
    private Integer num;


    /**
     * 单价
     */
    @CrmColumn(name = "price", mysqlType = "decimal(32,2)", oracleType = "NUMBER(32,2)", note = "单价")
    private BigDecimal price;


    /**
     * 金额小计
     */
    @CrmColumn(name = "total_amount", mysqlType = "decimal(32,2)", oracleType = "NUMBER(32,2)", note = "金额小计")
    private BigDecimal totalAmount;


    /**
     * 下单日期
     */
    @CrmColumn(name = "order_date", length = 32, note = "下单日期")
    private String orderDate;

}
