package com.biz.crm.sale.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExt20Entity;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.EqualsAndHashCode;
import com.biz.crm.base.CrmBaseEntity;

import java.math.BigDecimal;
import java.util.Date;

import lombok.experimental.Accessors;

import javax.swing.text.Position;

/**
 * 销售计划 实体类
 *
 * @author jerry7
 * @date 2021-04-28 15:32:39
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("tpm_sales_plans")
@CrmTable(name = "tpm_sales_plans", tableNote = "销售计划 ")
public class TpmSalesPlansEntity extends CrmExt20Entity<TpmSalesPlansEntity> {




    /**
     * 岗位编码
     */
    @CrmColumn(name = "position_code", length = 32, note = "岗位编码")
    private String positionCode;


    /**
     * 岗位名称
     */
    @CrmColumn(name = "position_name", length = 64, note = "岗位名称")
    private String positionName;


    /**
     * 年
     */
    @CrmColumn(name = "sp_year", length = 32, note = "年")
    private String spYear;


    /**
     * 月
     */
    @CrmColumn(name = "sp_month", length = 32, note = "月")
    private String spMonth;


    /**
     * 类型
     */
    @CrmColumn(name = "sp_type", length = 32, note = "类型")
    private String spType;


    /**
     * 组织编码
     */
    @CrmColumn(name = "org_code", length = 32, note = "组织编码")
    private String orgCode;


    /**
     * 组织名称
     */
    @CrmColumn(name = "org_name", length = 64, note = "组织名称")
    private String orgName;


    /**
     * 渠道编码
     */
    @CrmColumn(name = "channel_code", length = 32, note = "渠道编码")
    private String channelCode;


    /**
     * 渠道名称
     */
    @CrmColumn(name = "channel_name", length = 32, note = "渠道名称")
    private String channelName;


    /**
     * 客户编码
     */
    @CrmColumn(name = "customer_code", length = 32, note = "客户编码")
    private String customerCode;


    /**
     * 客户名称
     */
    @CrmColumn(name = "customer_name", length = 64, note = "客户名称")
    private String customerName;


    /**
     * 产品层级编码
     */
    @CrmColumn(name = "product_level_code", length = 32, note = "产品层级编码")
    private String productLevelCode;


    /**
     * 产品层级名称
     */
    @CrmColumn(name = "product_level_name", length = 32, note = "产品层级名称")
    private String productLevelName;


    /**
     * 产品编码
     */
    @CrmColumn(name = "product_code", length = 32, note = "产品编码")
    private String productCode;


    /**
     * 产品名称
     */
    @CrmColumn(name = "product_name", length = 32, note = "产品名称")
    private String productName;


    /**
     * 金额
     */
    @CrmColumn(name = "amount", mysqlType = "decimal(16,6)",oracleType = "NUMBER(16, 6)", note = "金额")
    private BigDecimal amount;


    /**
     * 币种
     */
    @CrmColumn(name = "currency_types", length = 32, note = "币种")
    private String currencyTypes;


    /**
     * 销售计划id
     */
    @CrmColumn(name = "sale_plans_id", length = 64, note = "销售计划id")
    private String salePlansId;



}
