/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.account.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.account.mapper.TpmAccountDetailMapper;
import com.biz.crm.account.model.TpmAccountDetailEntity;
import com.biz.crm.account.model.TpmAccountInvoiceEntity;
import com.biz.crm.audit.mapper.TpmAuditDetailCustomerMapper;
import com.biz.crm.audit.mapper.TpmAuditDetailMapper;
import com.biz.crm.audit.mapper.TpmAuditMapper;
import com.biz.crm.audit.model.TpmAuditDetailCustomerEntity;
import com.biz.crm.audit.model.TpmAuditDetailEntity;
import com.biz.crm.audit.model.TpmAuditEntity;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BaseServiceHelper;
import com.biz.crm.base.BusinessException;
import com.biz.crm.costtypefine.mapper.TpmCostTypeFineMapper;
import com.biz.crm.costtypefine.model.TpmCostTypeFineEntity;
import com.biz.crm.eunm.GlobalWhetherEnum;
import com.biz.crm.eunm.tpm.AccountStatusEnum;
import com.biz.crm.eunm.tpm.ActAdvancePayApproveStatusEnum;
import com.biz.crm.eunm.tpm.ActPayTypeEnum;
import com.biz.crm.eunm.tpm.ActPayTypeTypeEnum;
import com.biz.crm.eunm.tpm.TpmProjectNameEnum;
import com.biz.crm.exception.CrmExceptionType;
import com.biz.crm.exception.tpm.AccountException;
import com.biz.crm.exception.tpm.AuditException;
import com.biz.crm.liqueraudit.mapper.TpmLiqueurAuditAttachMapper;
import com.biz.crm.liqueraudit.mapper.TpmLiqueurAuditMapper;
import com.biz.crm.liqueraudit.model.TpmLiqueurAuditAttachEntity;
import com.biz.crm.liqueraudit.model.TpmLiqueurAuditEntity;
import com.biz.crm.nebular.tpm.account.req.TpmAccountDetailMainReqVo;
import com.biz.crm.nebular.tpm.account.req.TpmAccountDetailReqVo;
import com.biz.crm.nebular.tpm.account.req.TpmAccountInvoiceReqVo;
import com.biz.crm.nebular.tpm.account.req.TpmAccountUpdatePayTypeReqVo;
import com.biz.crm.nebular.tpm.account.resp.TpmAccountDetailRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.DictUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AccountServiceHelper
extends BaseServiceHelper {
    private static final Logger log = LoggerFactory.getLogger(AccountServiceHelper.class);
    @Resource
    private TpmAuditDetailMapper tpmAuditDetailMapper;
    @Resource
    private TpmAuditMapper tpmAuditMapper;
    @Resource
    private TpmAccountDetailMapper tpmAccountDetailMapper;
    @Resource
    private TpmLiqueurAuditMapper tpmLiqueurAuditMapper;
    @Resource
    private TpmAuditDetailCustomerMapper tpmAuditDetailCustomerMapper;
    @Resource
    private TpmLiqueurAuditAttachMapper tpmLiqueurAuditAttachMapper;
    @Resource
    private TpmCostTypeFineMapper fineMapper;

    public Map<String, Map<String, String>> getDicts() {
        ArrayList dictCodes = Lists.newArrayList();
        dictCodes.add("account_status");
        dictCodes.add("pay_type_type");
        return DictUtil.getDictValueMapsByCodes((List)dictCodes);
    }

    public void convertListDate(List<TpmAccountDetailRespVo> list) {
        if (CollectionUtils.isNotEmpty(list)) {
            Map<String, Map<String, String>> map = this.getDicts();
            list.forEach(o -> {
                if (StringUtils.isNotEmpty((CharSequence)o.getApproveStatus())) {
                    o.setApproveStatusName((String)((Map)Optional.ofNullable(map.get("account_status")).orElse(Maps.newHashMap())).get(o.getApproveStatus()));
                }
                if (StringUtils.isNotEmpty((CharSequence)o.getPayTypeType())) {
                    o.setPayTypeTypeName((String)((Map)Optional.ofNullable(map.get("pay_type_type")).orElse(Maps.newHashMap())).get(o.getPayTypeType()));
                }
            });
        }
    }

    public void saveCheck(TpmAccountDetailMainReqVo accountDetailMainReqVo) {
        AssertUtils.isNotEmpty((String)accountDetailMainReqVo.getSaveType(), (String)"\u4fdd\u5b58\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        if (StringUtils.isNotEmpty((CharSequence)accountDetailMainReqVo.getTpmProjectName()) && TpmProjectNameEnum.LIQUEUR_TPM.getCode().equals(accountDetailMainReqVo.getTpmProjectName())) {
            this.liqueurCheckAuditInfo(accountDetailMainReqVo);
        } else {
            this.checkAuditInfo(accountDetailMainReqVo);
        }
        this.checkProductInfo(accountDetailMainReqVo);
        this.checkInvoice(accountDetailMainReqVo);
    }

    private void checkAuditInfo(TpmAccountDetailMainReqVo accountDetailMainReqVo) {
        List accountDetailReqVos = accountDetailMainReqVo.getAccountDetailVos();
        AssertUtils.isNotEmpty((Collection)accountDetailReqVos, (String)"\u4e0a\u8d26\u660e\u7ec6\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        HashSet payTypeTypes = Sets.newHashSet();
        HashSet auditCodes = Sets.newHashSet();
        HashMap auditDetailCodeMap = Maps.newHashMap();
        HashSet<String> repeatCheck = new HashSet<String>();
        HashSet accountCodes = Sets.newHashSet();
        HashSet fineCodes = Sets.newHashSet();
        if (StringUtils.isNotEmpty((CharSequence)accountDetailMainReqVo.getGroupId())) {
            List accountDetailEntities = this.tpmAccountDetailMapper.selectList((Wrapper)Wrappers.lambdaQuery(TpmAccountDetailEntity.class).eq(TpmAccountDetailEntity::getGroupId, (Object)accountDetailMainReqVo.getGroupId()));
            AssertUtils.isNotEmpty((Collection)accountDetailEntities, (String)"\u60a8\u7f16\u8f91\u7684\u6570\u636e\u5df2\u88ab\u5220\u9664");
            AssertUtils.isTrue((boolean)StringUtils.equals((CharSequence)AccountStatusEnum.TEMP.getCode(), (CharSequence)((TpmAccountDetailEntity)((Object)accountDetailEntities.get(0))).getApproveStatus()), (String)"\u5f53\u524d\u6570\u636e\u4e0d\u5141\u8bb8\u7f16\u8f91");
        }
        String approveStatus = "";
        if (StringUtils.equals((CharSequence)AccountStatusEnum.TEMP.getCode(), (CharSequence)accountDetailMainReqVo.getSaveType())) {
            approveStatus = AccountStatusEnum.TEMP.getCode();
        }
        if (StringUtils.equals((CharSequence)AccountStatusEnum.SUBMIT.getCode(), (CharSequence)accountDetailMainReqVo.getSaveType())) {
            approveStatus = AccountStatusEnum.SUBMIT.getCode();
        }
        for (TpmAccountDetailReqVo vo : accountDetailReqVos) {
            AssertUtils.isNotEmpty((String)vo.getPayTypeType(), (String)"\u652f\u4ed8\u65b9\u5f0f\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            payTypeTypes.add(vo.getPayTypeType());
            AssertUtils.isTrue((!repeatCheck.contains(vo.getUniqueKey()) ? 1 : 0) != 0, (String)"\u8bf7\u52ff\u9009\u62e9\u91cd\u590d\u7684\u6838\u9500\u660e\u7ec6\u6570\u636e");
            repeatCheck.add(vo.getUniqueKey());
            List customerCodes = auditDetailCodeMap.computeIfAbsent(vo.getAuditDetailCode(), k -> new ArrayList());
            customerCodes.add(vo.getCustomerCode());
            auditCodes.add(vo.getAuditCode());
            accountCodes.add(vo.getAccountCode());
            vo.setApproveStatus(approveStatus);
            if (approveStatus.equals(AccountStatusEnum.SUBMIT.getCode())) {
                vo.setSubmitTime(DateUtil.dateNowHms());
            }
            fineCodes.add(vo.getFineCode());
        }
        AssertUtils.isTrue((accountDetailReqVos.size() == accountCodes.size() ? 1 : 0) != 0, (String)"\u8d39\u7528\u4e0a\u8d26\u7f16\u7801\u91cd\u590d");
        AssertUtils.isTrue((payTypeTypes.size() == 1 ? 1 : 0) != 0, (String)"\u53ea\u80fd\u9009\u62e9\u540c\u4e00\u652f\u4ed8\u65b9\u5f0f\u7c7b\u578b\u7684\u6838\u9500\u660e\u7ec6");
        List tpmAuditEntities = this.tpmAuditMapper.selectList((Wrapper)Wrappers.lambdaQuery(TpmAuditEntity.class).in(TpmAuditEntity::getAuditCode, (Collection)auditCodes));
        AssertUtils.isTrue((auditCodes.size() == CollectionUtils.size((Object)tpmAuditEntities) ? 1 : 0) != 0, (String)"\u6838\u9500\u4e3b\u8868\u6570\u636e\u5f02\u5e38");
        Map auditEntityMap = tpmAuditEntities.stream().collect(Collectors.toMap(TpmAuditEntity::getAuditCode, Function.identity()));
        List tpmAuditDetailEntities = this.tpmAuditDetailMapper.selectList((Wrapper)Wrappers.lambdaQuery(TpmAuditDetailEntity.class).in(TpmAuditDetailEntity::getAuditDetailCode, auditDetailCodeMap.keySet()));
        AssertUtils.isTrue((auditDetailCodeMap.size() == CollectionUtils.size((Object)tpmAuditDetailEntities) ? 1 : 0) != 0, (String)"\u6838\u9500\u660e\u7ec6\u6570\u636e\u5f02\u5e38");
        Map fineEntityMap = this.fineMapper.selectList((Wrapper)Wrappers.lambdaQuery(TpmCostTypeFineEntity.class).in(TpmCostTypeFineEntity::getFineCode, (Collection)fineCodes)).stream().collect(Collectors.toMap(TpmCostTypeFineEntity::getFineCode, Function.identity()));
        Map auditDetailEntityMap = tpmAuditDetailEntities.stream().collect(Collectors.toMap(TpmAuditDetailEntity::getAuditDetailCode, Function.identity()));
        List customerCodes = accountDetailReqVos.stream().filter(o -> StringUtils.isNotBlank((CharSequence)o.getCustomerCode())).map(TpmAccountDetailReqVo::getCustomerCode).collect(Collectors.toList());
        List allCustomerEntities = this.tpmAuditDetailCustomerMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(TpmAuditDetailCustomerEntity.class).in(TpmAuditDetailCustomerEntity::getAuditDetailCode, (Collection)accountDetailReqVos.stream().map(TpmAccountDetailReqVo::getAuditDetailCode).distinct().collect(Collectors.toList()))).in(CollectionUtils.isNotEmpty(customerCodes), TpmAuditDetailCustomerEntity::getCustomerCode, customerCodes));
        Map<String, TpmAuditDetailCustomerEntity> auditDetailCustomerEntityMap = allCustomerEntities.stream().collect(Collectors.toMap(o1 -> o1.getAuditDetailCode() + "-" + o1.getCustomerCode(), o2 -> o2));
        accountDetailReqVos.forEach(tpmAccountDetailReqVo -> {
            TpmAuditEntity tpmAuditEntity = (TpmAuditEntity)((Object)((Object)auditEntityMap.get(tpmAccountDetailReqVo.getAuditCode())));
            TpmCostTypeFineEntity tpmCostTypeFineEntity = (TpmCostTypeFineEntity)((Object)((Object)fineEntityMap.get(tpmAccountDetailReqVo.getFineCode())));
            if (Objects.nonNull((Object)tpmCostTypeFineEntity)) {
                tpmAccountDetailReqVo.setFinanceSubjectsErpCode(tpmCostTypeFineEntity.getFinanceSubjectsErpCode());
                tpmAccountDetailReqVo.setFinanceSubjectsErpName(tpmCostTypeFineEntity.getFinanceSubjectsErpName());
            }
            AssertUtils.isNotNull((Object)((Object)tpmAuditEntity), (CrmExceptionType)AuditException.DATA_NOT_EXIST, (String[])new String[0]);
            AssertUtils.isTrue((boolean)StringUtils.equals((CharSequence)ActAdvancePayApproveStatusEnum.APPROVED.getCode(), (CharSequence)tpmAuditEntity.getApproveStatus()), (String)"\u5ba1\u6279\u901a\u8fc7\u6838\u9500\u624d\u80fd\u4e0a\u8d26");
            TpmAuditDetailEntity auditDetailEntity = (TpmAuditDetailEntity)((Object)((Object)auditDetailEntityMap.get(tpmAccountDetailReqVo.getAuditDetailCode())));
            AssertUtils.isNotNull((Object)((Object)auditDetailEntity), (CrmExceptionType)AuditException.DATA_NOT_EXIST, (String[])new String[0]);
            AssertUtils.isNotNull((Object)tpmAccountDetailReqVo.getAccountAmount(), (String)"\u672c\u6b21\u4e0a\u8d26\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.isTrue((tpmAccountDetailReqVo.getAccountAmount().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u672c\u6b21\u4e0a\u8d26\u91d1\u989d\u5fc5\u987b\u5927\u4e8e\u96f6");
            if (this.isSpecial(auditDetailEntity)) {
                AssertUtils.isNotEmpty((String)tpmAccountDetailReqVo.getCustomerCode(), (String)"\u4e0a\u8d26\u6570\u636e\u9519\u8bef\uff0c\u5e94\u4e0a\u8d26\u5230\u5ba2\u6237");
                TpmAuditDetailCustomerEntity auditDetailCustomerEntity = (TpmAuditDetailCustomerEntity)((Object)((Object)auditDetailCustomerEntityMap.get(tpmAccountDetailReqVo.getAuditDetailCode() + "-" + tpmAccountDetailReqVo.getCustomerCode())));
                AssertUtils.isNotNull((Object)((Object)auditDetailCustomerEntity), (String)"\u672a\u627e\u5230\u4e0a\u8d26\u6838\u9500\u5ba2\u6237\u4fe1\u606f");
                AssertUtils.isTrue((boolean)StringUtils.equals((CharSequence)GlobalWhetherEnum.NO.getCode(), (CharSequence)auditDetailCustomerEntity.getIsAllFeeUsed()), (String)"\u5b8c\u5168\u4e0a\u8d26\u7684\u6838\u9500\u5ba2\u6237\u4e0d\u80fd\u4e0a\u8d26");
                AssertUtils.isTrue((tpmAccountDetailReqVo.getAccountAmount().compareTo(auditDetailEntity.getAuditApplyAmount().subtract(Optional.ofNullable(auditDetailCustomerEntity.getFeeUsed()).orElse(BigDecimal.ZERO))) < 1 ? 1 : 0) != 0, (String)"\u672c\u6b21\u4e0a\u8d26\u91d1\u989d\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e\u5ba2\u6237\u53ef\u4e0a\u8d26\u91d1\u989d");
                tpmAccountDetailReqVo.setCurrentAllowAmount(auditDetailCustomerEntity.getAuditApplyAmount().subtract(Optional.ofNullable(auditDetailCustomerEntity.getFeeUsed()).orElse(BigDecimal.ZERO)));
                tpmAccountDetailReqVo.setAuditAmount(auditDetailCustomerEntity.getAuditApplyAmount());
            } else {
                AssertUtils.isTrue((boolean)StringUtils.equals((CharSequence)GlobalWhetherEnum.NO.getCode(), (CharSequence)auditDetailEntity.getIsAllFeeUsed()), (String)"\u5b8c\u5168\u4e0a\u8d26\u7684\u6838\u9500\u4e0d\u80fd\u4e0a\u8d26");
                AssertUtils.isTrue((tpmAccountDetailReqVo.getAccountAmount().compareTo(auditDetailEntity.getAuditApplyAmount().subtract(Optional.ofNullable(auditDetailEntity.getFeeUsed()).orElse(BigDecimal.ZERO))) < 1 ? 1 : 0) != 0, (String)"\u672c\u6b21\u4e0a\u8d26\u91d1\u989d\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e\u53ef\u4e0a\u8d26\u91d1\u989d");
                tpmAccountDetailReqVo.setCurrentAllowAmount(auditDetailEntity.getAuditApplyAmount().subtract(Optional.ofNullable(auditDetailEntity.getFeeUsed()).orElse(BigDecimal.ZERO)));
                tpmAccountDetailReqVo.setAuditAmount(auditDetailEntity.getAuditApplyAmount());
            }
        });
    }

    public boolean isSpecial(TpmAuditDetailEntity auditDetailEntity) {
        return auditDetailEntity.getCustomerCode() == null && (ActPayTypeEnum.FORWARD_PAYMENT.getCode().equals(auditDetailEntity.getPayType()) || ActPayTypeEnum.REPLENISHMENT.getCode().equals(auditDetailEntity.getPayType()) || ActPayTypeEnum.DISCOUNT.getCode().equals(auditDetailEntity.getPayType()));
    }

    private void liqueurCheckAuditInfo(TpmAccountDetailMainReqVo accountDetailMainReqVo) {
        List accountDetailReqVos = accountDetailMainReqVo.getAccountDetailVos();
        AssertUtils.isNotEmpty((Collection)accountDetailReqVos, (String)"\u4e0a\u8d26\u660e\u7ec6\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        HashSet payTypeTypes = Sets.newHashSet();
        HashSet auditCodes = Sets.newHashSet();
        HashSet accountCodes = Sets.newHashSet();
        HashSet auditDetailAttachCodes = Sets.newHashSet();
        if (StringUtils.isNotEmpty((CharSequence)accountDetailMainReqVo.getGroupId())) {
            List accountDetailEntities = this.tpmAccountDetailMapper.selectList((Wrapper)Wrappers.lambdaQuery(TpmAccountDetailEntity.class).eq(TpmAccountDetailEntity::getGroupId, (Object)accountDetailMainReqVo.getGroupId()));
            AssertUtils.isNotEmpty((Collection)accountDetailEntities, (String)"\u60a8\u7f16\u8f91\u7684\u6570\u636e\u5df2\u88ab\u5220\u9664");
            AssertUtils.isTrue((boolean)StringUtils.equals((CharSequence)AccountStatusEnum.TEMP.getCode(), (CharSequence)((TpmAccountDetailEntity)((Object)accountDetailEntities.get(0))).getApproveStatus()), (String)"\u5f53\u524d\u6570\u636e\u4e0d\u5141\u8bb8\u7f16\u8f91");
        }
        String approveStatus = "";
        if (StringUtils.equals((CharSequence)AccountStatusEnum.TEMP.getCode(), (CharSequence)accountDetailMainReqVo.getSaveType())) {
            approveStatus = AccountStatusEnum.TEMP.getCode();
        }
        if (StringUtils.equals((CharSequence)AccountStatusEnum.SUBMIT.getCode(), (CharSequence)accountDetailMainReqVo.getSaveType())) {
            approveStatus = AccountStatusEnum.SUBMIT.getCode();
        }
        for (TpmAccountDetailReqVo vo : accountDetailReqVos) {
            AssertUtils.isNotEmpty((String)vo.getPayTypeType(), (String)"\u652f\u4ed8\u65b9\u5f0f\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            payTypeTypes.add(vo.getPayTypeType());
            AssertUtils.isTrue((!auditDetailAttachCodes.contains(vo.getAuditDetailAttachCode()) ? 1 : 0) != 0, (String)"\u8bf7\u52ff\u9009\u62e9\u91cd\u590d\u7684\u6838\u9500\u9644\u52a0\u4fe1\u606f\u6570\u636e");
            auditDetailAttachCodes.add(vo.getAuditDetailAttachCode());
            auditCodes.add(vo.getAuditCode());
            accountCodes.add(vo.getAccountCode());
            vo.setApproveStatus(approveStatus);
        }
        AssertUtils.isTrue((accountDetailReqVos.size() == accountCodes.size() ? 1 : 0) != 0, (String)"\u8d39\u7528\u4e0a\u8d26\u7f16\u7801\u91cd\u590d");
        AssertUtils.isTrue((payTypeTypes.size() == 1 ? 1 : 0) != 0, (String)"\u53ea\u80fd\u9009\u62e9\u540c\u4e00\u652f\u4ed8\u65b9\u5f0f\u7c7b\u578b\u7684\u6838\u9500\u660e\u7ec6");
        List tpmLiqueurAuditEntities = this.tpmLiqueurAuditMapper.selectList((Wrapper)Wrappers.lambdaQuery(TpmLiqueurAuditEntity.class).in(TpmLiqueurAuditEntity::getAuditCode, (Collection)auditCodes));
        AssertUtils.isTrue((auditCodes.size() == CollectionUtils.size((Object)tpmLiqueurAuditEntities) ? 1 : 0) != 0, (String)"\u6838\u9500\u4e3b\u8868\u6570\u636e\u5f02\u5e38");
        Map auditEntityMap = tpmLiqueurAuditEntities.stream().collect(Collectors.toMap(TpmLiqueurAuditEntity::getAuditCode, Function.identity()));
        List tpmLiqueurAuditAttachEntities = this.tpmLiqueurAuditAttachMapper.selectList((Wrapper)Wrappers.lambdaQuery(TpmLiqueurAuditAttachEntity.class).in(TpmLiqueurAuditAttachEntity::getAuditDetailAttachCode, (Collection)auditDetailAttachCodes));
        AssertUtils.isTrue((auditDetailAttachCodes.size() == CollectionUtils.size((Object)tpmLiqueurAuditAttachEntities) ? 1 : 0) != 0, (String)"\u6838\u9500\u9644\u52a0\u4fe1\u606f\u6570\u636e\u5f02\u5e38");
        Map auditAttachMap = tpmLiqueurAuditAttachEntities.stream().collect(Collectors.toMap(TpmLiqueurAuditAttachEntity::getAttachCode, Function.identity()));
        accountDetailReqVos.forEach(tpmAccountDetailReqVo -> {
            TpmLiqueurAuditEntity tpmLiqueurAuditEntity = (TpmLiqueurAuditEntity)((Object)((Object)auditEntityMap.get(tpmAccountDetailReqVo.getAuditCode())));
            AssertUtils.isNotNull((Object)((Object)tpmLiqueurAuditEntity), (CrmExceptionType)AuditException.DATA_NOT_EXIST, (String[])new String[0]);
            AssertUtils.isTrue((boolean)StringUtils.equals((CharSequence)ActAdvancePayApproveStatusEnum.APPROVED.getCode(), (CharSequence)tpmLiqueurAuditEntity.getApproveStatus()), (String)"\u5ba1\u6279\u901a\u8fc7\u6838\u9500\u624d\u80fd\u4e0a\u8d26");
            TpmLiqueurAuditAttachEntity auditAttachEntity = (TpmLiqueurAuditAttachEntity)((Object)((Object)auditAttachMap.get(tpmAccountDetailReqVo.getAttachCode())));
            AssertUtils.isNotNull((Object)((Object)auditAttachEntity), (CrmExceptionType)AuditException.DATA_NOT_EXIST, (String[])new String[0]);
            AssertUtils.isTrue((boolean)StringUtils.equals((CharSequence)GlobalWhetherEnum.NO.getCode(), (CharSequence)auditAttachEntity.getIsAllFeeUsed()), (String)"\u5b8c\u5168\u4e0a\u8d26\u7684\u6838\u9500\u4e0d\u80fd\u4e0a\u8d26");
            AssertUtils.isNotNull((Object)tpmAccountDetailReqVo.getAccountAmount(), (String)"\u672c\u6b21\u4e0a\u8d26\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.isTrue((tpmAccountDetailReqVo.getAccountAmount().compareTo(BigDecimal.ZERO) == 1 ? 1 : 0) != 0, (String)"\u672c\u6b21\u4e0a\u8d26\u91d1\u989d\u5fc5\u987b\u5927\u4e8e\u96f6");
            AssertUtils.isTrue((tpmAccountDetailReqVo.getAccountAmount().compareTo(auditAttachEntity.getAuditAmount().subtract(Optional.ofNullable(auditAttachEntity.getFeeUsed()).orElse(BigDecimal.ZERO))) < 1 ? 1 : 0) != 0, (String)"\u672c\u6b21\u4e0a\u8d26\u91d1\u989d\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e\u53ef\u4e0a\u8d26\u91d1\u989d");
            tpmAccountDetailReqVo.setCurrentAllowAmount(auditAttachEntity.getAuditAmount().subtract(Optional.ofNullable(auditAttachEntity.getFeeUsed()).orElse(BigDecimal.ZERO)));
        });
    }

    private void checkProductInfo(TpmAccountDetailMainReqVo accountDetailMainReqVo) {
        ArrayList needSaveProductList = Lists.newArrayList();
        accountDetailMainReqVo.getAccountDetailVos().forEach(tpmAccountDetailReqVo -> {
            if (StringUtils.equals((CharSequence)ActPayTypeEnum.REPLENISHMENT.getCode(), (CharSequence)tpmAccountDetailReqVo.getPayType())) {
                List productInfoReqVos;
                if (StringUtils.isEmpty((CharSequence)tpmAccountDetailReqVo.getProductLevelCode()) && CollectionUtils.isEmpty((Collection)tpmAccountDetailReqVo.getReplenishmentProductList())) {
                    throw new BusinessException("\u652f\u4ed8\u65b9\u5f0f\u4e3a\u8d27\u8865\u7684\u4e0a\u8d26\u660e\u7ec6,\u8d27\u8865\u4ea7\u54c1\u5c42\u7ea7\u548c\u8d27\u8865\u4ea7\u54c1\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
                }
                HashSet productLevelCodes = Sets.newHashSet();
                if (StringUtils.isNotEmpty((CharSequence)tpmAccountDetailReqVo.getProductLevelCode())) {
                    productLevelCodes.add(tpmAccountDetailReqVo.getProductLevelCode());
                }
                if (CollectionUtils.isNotEmpty((Collection)(productInfoReqVos = tpmAccountDetailReqVo.getReplenishmentProductList()))) {
                    HashSet collect = Sets.newHashSet();
                    productInfoReqVos.forEach(o -> {
                        AssertUtils.isNotEmpty((String)o.getProductCode(), (String)("\u4e0a\u8d26\u660e\u7ec6\u7f16\u7801:" + tpmAccountDetailReqVo.getAccountCode() + "\u8d27\u8865\u4ea7\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a"));
                        AssertUtils.isNotEmpty((String)o.getProductCode(), (String)("\u4e0a\u8d26\u660e\u7ec6\u7f16\u7801:" + tpmAccountDetailReqVo.getAccountCode() + "\u8d27\u8865\u4ea7\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a"));
                        o.setAccountCode(tpmAccountDetailReqVo.getAccountCode());
                        AssertUtils.isTrue((!collect.contains(o.getProductCode()) ? 1 : 0) != 0, (String)("\u4e0a\u8d26\u660e\u7ec6\u7f16\u7801:" + tpmAccountDetailReqVo.getAccountCode() + "\u8d27\u8865\u4ea7\u54c1\u91cd\u590d"));
                        collect.add(o.getProductCode());
                    });
                    needSaveProductList.addAll(productInfoReqVos);
                }
            } else if (StringUtils.isNotEmpty((CharSequence)tpmAccountDetailReqVo.getProductLevelCode()) || CollectionUtils.isNotEmpty((Collection)tpmAccountDetailReqVo.getReplenishmentProductList())) {
                throw new BusinessException("\u4e0a\u8d26\u660e\u7ec6\u7f16\u7801:" + tpmAccountDetailReqVo.getAccountCode() + "\u4e0d\u80fd\u9009\u62e9\u8d27\u8865\u4ea7\u54c1\u5c42\u7ea7\u6216\u8005\u8d27\u8865\u4ea7\u54c1");
            }
        });
        accountDetailMainReqVo.setNeedSaveProductList((List)needSaveProductList);
    }

    private void checkInvoice(TpmAccountDetailMainReqVo accountDetailMainReqVo) {
        List accountDetailReqVos = accountDetailMainReqVo.getAccountDetailVos();
        List accountInvoiceReqVos = accountDetailMainReqVo.getAccountInvoiceVos();
        TpmAccountDetailReqVo detailReqVo = (TpmAccountDetailReqVo)accountDetailReqVos.get(0);
        if (StringUtils.equals((CharSequence)ActPayTypeTypeEnum.NEED_INVOICE.getCode(), (CharSequence)detailReqVo.getPayTypeType()) && CollectionUtils.isNotEmpty((Collection)accountInvoiceReqVos)) {
            Map detailMap = accountDetailReqVos.stream().collect(Collectors.toMap(TpmAccountDetailReqVo::getAccountCode, Function.identity()));
            for (TpmAccountInvoiceReqVo invoiceReqVo : accountInvoiceReqVos) {
                AssertUtils.isNotEmpty((String)invoiceReqVo.getInvoiceCode(), (String)"\u53d1\u7968\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                AssertUtils.isNotNull((Object)invoiceReqVo.getInvoiceAmount(), (String)"\u53d1\u7968\u91d1\u989d(\u4e0d\u542b\u7a0e)\u4e0d\u80fd\u4e3a\u7a7a");
                AssertUtils.isNotEmpty((Collection)invoiceReqVo.getAccountCodeList(), (String)"\u53d1\u7968\u5bf9\u5e94\u7684\u4e0a\u8d26\u5355\u53f7\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
                HashSet accountCodes = Sets.newHashSet((Iterable)invoiceReqVo.getAccountCodeList());
                AssertUtils.isTrue((accountCodes.size() == invoiceReqVo.getAccountCodeList().size() ? 1 : 0) != 0, (String)"\u53d1\u7968\u5173\u8054\u7684\u4e0a\u8d26\u5355\u91cd\u590d");
                HashSet customerCodes = Sets.newHashSet();
                accountCodes.forEach(o -> {
                    TpmAccountDetailReqVo tpmAccountDetailReqVo = (TpmAccountDetailReqVo)detailMap.get(o);
                    AssertUtils.isNotNull((Object)tpmAccountDetailReqVo, (String)"\u53d1\u7968\u5173\u8054\u7684\u4e0a\u8d26\u5355\u4e0d\u5b58\u5728");
                    customerCodes.add(Optional.ofNullable(tpmAccountDetailReqVo.getCustomerCode()).orElse(""));
                });
                AssertUtils.isTrue((CollectionUtils.size((Object)customerCodes) == 1 ? 1 : 0) != 0, (String)"\u540c\u4e00\u5f20\u53d1\u7968\u5173\u8054\u7684\u4e0a\u8d26\u5355\u7684\u5ba2\u6237\u5fc5\u987b\u4e00\u81f4");
                invoiceReqVo.setAccountCodes(JSON.toJSONString((Object)accountCodes));
            }
        } else {
            AssertUtils.isTrue((boolean)CollectionUtils.isEmpty((Collection)accountInvoiceReqVos), (String)"\u5f53\u524d\u4e0a\u8d26\u5355\u4e0d\u5141\u8bb8\u586b\u5199\u53d1\u7968\u6570\u636e");
        }
    }

    private void checkDataExist(TpmAccountDetailMainReqVo accountDetailMainReqVo) {
        List accountDetailReqVos = accountDetailMainReqVo.getAccountDetailVos();
        for (TpmAccountDetailReqVo accountDetailReqVo : accountDetailReqVos) {
            LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(TpmAccountDetailEntity::getAuditCode, (Object)accountDetailReqVo.getAccountCode());
            if (StringUtils.isNotEmpty((CharSequence)accountDetailReqVo.getId())) {
                wrapper.ne(BaseIdEntity::getId, (Object)accountDetailReqVo.getId());
            }
            TpmAccountDetailEntity entity = (TpmAccountDetailEntity)((Object)this.tpmAccountDetailMapper.selectOne((Wrapper)wrapper));
            AssertUtils.isTrue((boolean)Objects.isNull((Object)entity), (CrmExceptionType)AccountException.DATA_CODE_DUPLICATE, (String[])new String[0]);
        }
    }

    public void batchUpdatePayTypeCheck(TpmAccountUpdatePayTypeReqVo accountDetailMainReqVo) {
        AssertUtils.isNotEmpty((Collection)accountDetailMainReqVo.getIds(), (String)"\u7f16\u7801\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)accountDetailMainReqVo.getPayType(), (String)"\u652f\u4ed8\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
    }

    public Boolean judgeInvoiceContain(TpmAccountInvoiceEntity entity, List<String> AccountCodes) {
        return Boolean.FALSE;
    }
}

