/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.act.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.act.mapper.TpmActDetailMapper;
import com.biz.crm.act.model.TpmActDetailEntity;
import com.biz.crm.act.service.ITpmActDetailService;
import com.biz.crm.act.service.impl.ActServiceHelper;
import com.biz.crm.advancepay.service.impl.ActAdvancePayServiceHelper;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.tpm.ActAdvancePayTypeEnum;
import com.biz.crm.nebular.tpm.act.req.TpmActDetailReportReqVo;
import com.biz.crm.nebular.tpm.act.req.TpmActDetailReqVo;
import com.biz.crm.nebular.tpm.act.resp.TpmActDetailReportRespVo;
import com.biz.crm.nebular.tpm.act.resp.TpmActDetailRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.PageUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"TpmActDetailServiceExpandImpl"})
public class TpmActDetailServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<TpmActDetailMapper, TpmActDetailEntity>
implements ITpmActDetailService {
    private static final Logger log = LoggerFactory.getLogger(TpmActDetailServiceImpl.class);
    @Resource
    private TpmActDetailMapper tpmActDetailMapper;
    @Autowired
    private ActAdvancePayServiceHelper advancePayServiceHelper;
    @Resource
    private ActServiceHelper serviceHelper;

    @Override
    public PageResult<TpmActDetailRespVo> findList(TpmActDetailReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        reqVo.setSelectedCodeList(this.serviceHelper.dealSelectedCodeList(reqVo.getSelectedCode(), reqVo.getSelectedCodeList()));
        List<TpmActDetailRespVo> list = this.tpmActDetailMapper.findList((Page<TpmActDetailRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public TpmActDetailRespVo query(String id) {
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(TpmActDetailReqVo reqVo) {
        TpmActDetailEntity entity = (TpmActDetailEntity)((Object)CrmBeanUtil.copy((Object)reqVo, TpmActDetailEntity.class));
        this.save((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(TpmActDetailReqVo reqVo) {
        TpmActDetailEntity entity = (TpmActDetailEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        this.updateById((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<String> ids) {
        List tpmActDetailEntities = this.tpmActDetailMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)tpmActDetailEntities)) {
            tpmActDetailEntities.forEach(o -> o.setDelFlag(CrmDelFlagEnum.DELETE.getCode()));
        }
        this.updateBatchById(tpmActDetailEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(List<String> ids) {
        List tpmActDetailEntities = this.tpmActDetailMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)tpmActDetailEntities)) {
            tpmActDetailEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(tpmActDetailEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(List<String> ids) {
        List tpmActDetailEntities = this.tpmActDetailMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)tpmActDetailEntities)) {
            tpmActDetailEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(tpmActDetailEntities);
    }

    @Override
    public PageResult<TpmActDetailRespVo> pageForAdvancePay(TpmActDetailReqVo reqVo) {
        Page page;
        List<TpmActDetailRespVo> data;
        AssertUtils.isNotEmpty((String)reqVo.getAdvanceType(), (String)"\u6d3b\u52a8\u9884\u4ed8\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        if (StringUtils.equals((CharSequence)ActAdvancePayTypeEnum.ACT.getCode(), (CharSequence)reqVo.getAdvanceType())) {
            AssertUtils.isNotEmpty((String)reqVo.getActCode(), (String)"\u8bf7\u5148\u9009\u62e9\u6d3b\u52a8");
        }
        if (StringUtils.equals((CharSequence)ActAdvancePayTypeEnum.CUSTOMER.getCode(), (CharSequence)reqVo.getAdvanceType())) {
            AssertUtils.isNotEmpty((String)reqVo.getCustomerCode(), (String)"\u8bf7\u5148\u9009\u62e9\u5ba2\u6237");
        }
        if ((data = this.tpmActDetailMapper.pageForAdvancePay((Page<TpmActDetailRespVo>)(page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize())), reqVo)).size() > 0) {
            List<String> codes = data.stream().map(TpmActDetailRespVo::getActDetailCode).collect(Collectors.toList());
            Map<String, BigDecimal> map = this.advancePayServiceHelper.getActDetailsAdvanceAmount(codes);
            data.forEach(o -> o.setAlreadyApplyAdvanceTotalAmount(Optional.ofNullable(map.get(o.getActDetailCode())).orElse(BigDecimal.ZERO)));
        }
        return PageResult.builder().data(data).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public PageResult<TpmActDetailReportRespVo> actDetailReport(TpmActDetailReportReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<TpmActDetailReportRespVo> data = this.tpmActDetailMapper.actDetailReport((Page<TpmActDetailReportRespVo>)page, reqVo);
        this.convertData(data);
        return PageResult.builder().data(data).count(Long.valueOf(page.getTotal())).build();
    }

    private void convertData(List<TpmActDetailReportRespVo> data) {
        if (CollectionUtil.listNotEmpty(data)) {
            Map map = DictUtil.getDictValueMapsByCodes((List)Lists.newArrayList((Object[])new String[]{"act_approve_status", "account_status"}));
            data.forEach(o -> {
                o.setApproveStatus((String)((Map)Optional.ofNullable(map.get("act_approve_status")).orElse(Maps.newHashMap())).get(o.getApproveStatus()));
                o.setAuditApproveStatus((String)((Map)Optional.ofNullable(map.get("act_approve_status")).orElse(Maps.newHashMap())).get(o.getAuditApproveStatus()));
                o.setAccountStatus((String)((Map)Optional.ofNullable(map.get("account_status")).orElse(Maps.newHashMap())).get(o.getAccountStatus()));
            });
        }
    }
}

