/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.budgetgeneraterule.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.budgetgeneraterule.mapper.TpmBudgetGenerateRuleMapper;
import com.biz.crm.budgetgeneraterule.model.TpmBudgetGenerateRuleEntity;
import com.biz.crm.budgetsubjects.mapper.TpmBudgetSubjectsMapper;
import com.biz.crm.budgetsubjects.model.TpmBudgetSubjectsEntity;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.tpm.FeeBudgetTypeEnum;
import com.biz.crm.mdm.customer.MdmCustomerMsgFeign;
import com.biz.crm.mdm.org.MdmOrgFeign;
import com.biz.crm.mdm.terminal.MdmTerminalFeign;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.humanarea.MdmCustomerOrgSearchReqVo;
import com.biz.crm.nebular.mdm.org.req.MdmOrgReqVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.mdm.terminal.MdmCustomerTerminalVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.biz.crm.nebular.tpm.budgetgeneraterule.req.TpmBudgetGenerateRuleReqVo;
import com.biz.crm.nebular.tpm.budgetgeneraterule.resp.TpmBudgetGenerateRuleRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.UserUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TpmBudgetGenerateRuleHelper {
    @Resource
    private TpmBudgetGenerateRuleMapper tpmBudgetGenerateRuleMapper;
    @Autowired
    private MdmOrgFeign mdmOrgFeign;
    @Resource
    private MdmCustomerMsgFeign mdmCustomerMsgFeign;
    @Autowired
    private MdmTerminalFeign terminalFeign;
    @Resource
    private TpmBudgetSubjectsMapper budgetSubjectsMapper;

    public Map<String, Map<String, String>> getDicts() {
        ArrayList dictCodes = Lists.newArrayList();
        dictCodes.add("budget_year");
        dictCodes.add("budget_month");
        dictCodes.add("channel");
        dictCodes.add("fee_budget_type");
        dictCodes.add("yesOrNo");
        return DictUtil.getDictValueMapsByCodes((List)dictCodes);
    }

    public void convertListDate(List<TpmBudgetGenerateRuleRespVo> list) {
        if (CollectionUtils.isNotEmpty(list)) {
            Map<String, Map<String, String>> map = this.getDicts();
            list.forEach(o -> {
                if (StringUtils.isNotEmpty((CharSequence)o.getEnableStatus())) {
                    o.setEnableStatusName((String)((Map)Optional.ofNullable(map.get("enable_status")).orElse(Maps.newHashMap())).get(o.getEnableStatus()));
                }
                if (StringUtils.isNotEmpty((CharSequence)o.getYear())) {
                    o.setYearName((String)((Map)Optional.ofNullable(map.get("budget_year")).orElse(Maps.newHashMap())).get(o.getYear()));
                }
                if (StringUtils.isNotEmpty((CharSequence)o.getMonth())) {
                    o.setMonthName((String)((Map)Optional.ofNullable(map.get("budget_month")).orElse(Maps.newHashMap())).get(o.getMonth()));
                }
                if (StringUtils.isNotEmpty((CharSequence)o.getChannel())) {
                    o.setChannelName((String)((Map)Optional.ofNullable(map.get("channel")).orElse(Maps.newHashMap())).get(o.getChannel()));
                }
                if (StringUtils.isNotEmpty((CharSequence)o.getFeeBudgetType())) {
                    o.setFeeBudgetTypeName((String)((Map)Optional.ofNullable(map.get("fee_budget_type")).orElse(Maps.newHashMap())).get(o.getFeeBudgetType()));
                }
                if (o.getIsGenerate() != null) {
                    o.setIsGenerateName((String)((Map)Optional.ofNullable(map.get("yesOrNo")).orElse(Maps.newHashMap())).get(o.getIsGenerate()));
                }
            });
        }
    }

    public void checkData(TpmBudgetGenerateRuleReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getRatio().toString(), (String)"\u6bd4\u4f8b\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getYear(), (String)"\u5e74\u4efd\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getMonth(), (String)"\u6708\u4efd\u4e0d\u80fd\u4e3a\u7a7a");
        if (reqVo.getRatio().compareTo(BigDecimal.ZERO) < 0 || reqVo.getRatio().compareTo(new BigDecimal(100)) > 0) {
            throw new BusinessException("\u6bd4\u4f8b\u5e94\u57280~100\u4e4b\u95f4");
        }
        AssertUtils.isNotEmpty((String)reqVo.getFeeBudgetType(), (String)"\u9884\u7b97\u751f\u6210\u7ef4\u5ea6\u4e0d\u80fd\u4e3a\u7a7a");
        TpmBudgetSubjectsEntity subjectsEntity = (TpmBudgetSubjectsEntity)((Object)this.budgetSubjectsMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(TpmBudgetSubjectsEntity::getBudgetSubjectsCode, (Object)reqVo.getBudgetSubjectCode())));
        AssertUtils.isNotNull((Object)((Object)subjectsEntity), (String)"\u9884\u7b97\u79d1\u76ee\u6570\u636e\u4e0d\u5b58\u5728");
        AssertUtils.isTrue((boolean)StringUtils.equals((CharSequence)CrmEnableStatusEnum.ENABLE.getCode(), (CharSequence)subjectsEntity.getEnableStatus()), (String)"\u60a8\u9009\u62e9\u9884\u7b97\u79d1\u76ee\u5df2\u88ab\u7981\u7528");
        reqVo.setBudgetSubjectName(subjectsEntity.getBudgetSubjectsName());
        if (StringUtils.equals((CharSequence)reqVo.getFeeBudgetType(), (CharSequence)FeeBudgetTypeEnum.CHANNEL.getCode())) {
            if (reqVo.getChannel() != null && !Optional.ofNullable(this.getDicts().get("channel")).orElse(Maps.newHashMap()).containsKey(reqVo.getChannel())) {
                throw new BusinessException("\u6e20\u9053\u7c7b\u578b\u4e0d\u6b63\u786e");
            }
            this.clearCustomerInfo(reqVo);
            this.clearTerminalInfo(reqVo);
        } else if (StringUtils.equals((CharSequence)reqVo.getFeeBudgetType(), (CharSequence)FeeBudgetTypeEnum.CUSTOMER.getCode())) {
            if (reqVo.getCustomerCode() != null) {
                this.checkCustomer(reqVo);
            }
            this.clearTerminalInfo(reqVo);
            this.clearChannelInfo(reqVo);
        } else if (StringUtils.equals((CharSequence)reqVo.getFeeBudgetType(), (CharSequence)FeeBudgetTypeEnum.TERMINAL.getCode())) {
            if (reqVo.getTerminalCode() != null) {
                AssertUtils.isNotEmpty((String)reqVo.getCustomerCode(), (String)"\u5ba2\u6237\u4e0d\u80fd\u4e3a\u7a7a");
                this.checkCustomer(reqVo);
                MdmCustomerTerminalVo mdmCustomerTerminalVo = new MdmCustomerTerminalVo();
                mdmCustomerTerminalVo.setCustomerCodeList((List)Lists.newArrayList((Object[])new String[]{reqVo.getCustomerCode()}));
                MdmTerminalVo mdmTerminalVo = (MdmTerminalVo)ApiResultUtil.objResult((Result)this.terminalFeign.query("", reqVo.getTerminalCode()));
                AssertUtils.isNotNull((Object)mdmTerminalVo, (String)"\u95e8\u5e97\u4e0d\u5b58\u5728");
                List mdmTerminalVos = (List)ApiResultUtil.objResult((Result)this.terminalFeign.customerTerminalList(mdmCustomerTerminalVo));
                Map mdmTerminalVoMap = mdmTerminalVos.stream().collect(Collectors.toMap(MdmTerminalVo::getTerminalCode, Function.identity()));
                if (!mdmTerminalVoMap.containsKey(reqVo.getTerminalCode())) {
                    throw new BusinessException("\u95e8\u5e97\u4e0d\u5c5e\u4e8e\u6240\u9009\u5ba2\u6237");
                }
                reqVo.setTerminalName(((MdmTerminalVo)mdmTerminalVoMap.get(reqVo.getTerminalCode())).getTerminalName());
            }
        } else {
            if (reqVo.getOrgCode() != null) {
                this.checkOrg(reqVo);
            }
            this.clearCustomerInfo(reqVo);
            this.clearTerminalInfo(reqVo);
            this.clearChannelInfo(reqVo);
        }
        this.checkIsExist(reqVo);
    }

    private void checkOrg(TpmBudgetGenerateRuleReqVo reqVo) {
        MdmOrgRespVo mdmOrgRespVo = (MdmOrgRespVo)ApiResultUtil.objResult((Result)this.mdmOrgFeign.detail(reqVo.getOrgCode()));
        AssertUtils.isNotNull((Object)mdmOrgRespVo, (String)"\u7ec4\u7ec7\u4e0d\u5b58\u5728");
        MdmOrgReqVo mdmOrgReqVo = new MdmOrgReqVo();
        mdmOrgReqVo.setOrgCode(UserUtils.getUser().getOrgcode());
        List orgRespVos = (List)ApiResultUtil.objResult((Result)this.mdmOrgFeign.findAllChildrenOrgList(mdmOrgReqVo));
        Map orgRespVoMap = orgRespVos.stream().collect(Collectors.toMap(MdmOrgRespVo::getOrgCode, Function.identity()));
        if (!orgRespVoMap.containsKey(reqVo.getOrgCode())) {
            throw new BusinessException("\u53ea\u80fd\u9009\u62e9\u81ea\u5df1\u7684\u7ec4\u7ec7\u6216\u4e0b\u7ea7\u7ec4\u7ec7");
        }
    }

    private void checkCustomer(TpmBudgetGenerateRuleReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getOrgCode(), (String)"\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a");
        this.checkOrg(reqVo);
        MdmCustomerMsgRespVo customerMsgRespVo = (MdmCustomerMsgRespVo)ApiResultUtil.objResult((Result)this.mdmCustomerMsgFeign.query("", reqVo.getCustomerCode()));
        AssertUtils.isNotNull((Object)customerMsgRespVo, (String)"\u5ba2\u6237\u4e0d\u5b58\u5728");
        MdmCustomerOrgSearchReqVo mdmCustomerOrgSearchReqVo = new MdmCustomerOrgSearchReqVo();
        mdmCustomerOrgSearchReqVo.setOrgCodeList((List)Lists.newArrayList((Object[])new String[]{reqVo.getOrgCode()}));
        Map customerMsgRespVoMap = ((List)ApiResultUtil.objResult((Result)this.mdmCustomerMsgFeign.findCurrentAndSubCustomerList(mdmCustomerOrgSearchReqVo))).stream().collect(Collectors.toMap(MdmCustomerMsgRespVo::getCustomerCode, Function.identity()));
        if (!customerMsgRespVoMap.containsKey(reqVo.getCustomerCode())) {
            throw new BusinessException("\u5ba2\u6237\u4e0d\u5c5e\u4e8e\u6240\u9009\u7ec4\u7ec7");
        }
        MdmCustomerMsgRespVo mdmCustomerMsgRespVo = (MdmCustomerMsgRespVo)customerMsgRespVoMap.get(reqVo.getCustomerCode());
        reqVo.setCustomerName(mdmCustomerMsgRespVo.getCustomerName());
    }

    private void clearCustomerInfo(TpmBudgetGenerateRuleReqVo reqVo) {
        reqVo.setCustomerCode(null);
        reqVo.setCustomerName(null);
    }

    private void clearTerminalInfo(TpmBudgetGenerateRuleReqVo reqVo) {
        reqVo.setTerminalCode(null);
        reqVo.setTerminalName(null);
    }

    private void clearChannelInfo(TpmBudgetGenerateRuleReqVo reqVo) {
        reqVo.setChannel(null);
    }

    public void checkIsExist(TpmBudgetGenerateRuleReqVo reqVo) {
        int count;
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(TpmBudgetGenerateRuleEntity.class).eq(TpmBudgetGenerateRuleEntity::getBudgetSubjectCode, (Object)reqVo.getBudgetSubjectCode())).eq(TpmBudgetGenerateRuleEntity::getYear, (Object)reqVo.getYear())).eq(TpmBudgetGenerateRuleEntity::getMonth, (Object)reqVo.getMonth())).eq(TpmBudgetGenerateRuleEntity::getFeeBudgetType, (Object)reqVo.getFeeBudgetType());
        if (reqVo.getOrgCode() != null) {
            wrapper.eq(TpmBudgetGenerateRuleEntity::getOrgCode, (Object)reqVo.getOrgCode());
        } else {
            wrapper.isNull(TpmBudgetGenerateRuleEntity::getOrgCode);
        }
        if (reqVo.getCustomerCode() != null) {
            wrapper.eq(TpmBudgetGenerateRuleEntity::getCustomerCode, (Object)reqVo.getOrgCode());
        } else {
            wrapper.isNull(TpmBudgetGenerateRuleEntity::getCustomerCode);
        }
        if (reqVo.getTerminalCode() != null) {
            wrapper.eq(TpmBudgetGenerateRuleEntity::getTerminalCode, (Object)reqVo.getOrgCode());
        } else {
            wrapper.isNull(TpmBudgetGenerateRuleEntity::getTerminalCode);
        }
        if (reqVo.getId() != null) {
            wrapper.ne(BaseIdEntity::getId, (Object)reqVo.getId());
        }
        if ((count = this.tpmBudgetGenerateRuleMapper.selectCount((Wrapper)wrapper).intValue()) > 0) {
            throw new BusinessException("\u5df2\u5b58\u5728\u76f8\u540c\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u63d0\u4ea4");
        }
    }
}

