/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.budgetgeneraterule.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.budgetgeneraterule.mapper.TpmBudgetGenerateRuleMapper;
import com.biz.crm.budgetgeneraterule.model.TpmBudgetGenerateRuleEntity;
import com.biz.crm.budgetgeneraterule.service.ITpmBudgetGenerateRuleService;
import com.biz.crm.budgetgeneraterule.service.impl.TpmBudgetGenerateRuleHelper;
import com.biz.crm.common.PageResult;
import com.biz.crm.crmlog.handle.util.CrmLogSendUtil;
import com.biz.crm.eunm.CodeRuleEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.tpm.FeeBudgetDetailTypeEnum;
import com.biz.crm.feebudget.service.ITpmFeeBudgetService;
import com.biz.crm.income.mapper.TpmIncomeBudgetMapper;
import com.biz.crm.income.model.TpmIncomeBudgetEntity;
import com.biz.crm.nebular.tpm.budgetgeneraterule.req.TpmBudgetGenerateRuleReqVo;
import com.biz.crm.nebular.tpm.budgetgeneraterule.resp.TpmBudgetGenerateRuleRespVo;
import com.biz.crm.nebular.tpm.feebudget.req.TpmFeeBudgetReqVo;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.UserUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"TpmBudgetGenerateRuleServiceExpandImpl"})
public class TpmBudgetGenerateRuleServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<TpmBudgetGenerateRuleMapper, TpmBudgetGenerateRuleEntity>
implements ITpmBudgetGenerateRuleService {
    private static final Logger log = LoggerFactory.getLogger(TpmBudgetGenerateRuleServiceImpl.class);
    @Resource
    private TpmBudgetGenerateRuleMapper tpmBudgetGenerateRuleMapper;
    @Resource
    private TpmBudgetGenerateRuleHelper tpmBudgetGenerateRuleHelper;
    @Resource
    private CrmLogSendUtil crmLogSendUtil;
    @Resource
    private TpmIncomeBudgetMapper tpmIncomeBudgetMapper;
    @Resource
    private ITpmFeeBudgetService tpmFeeBudgetService;

    @Override
    public PageResult<TpmBudgetGenerateRuleRespVo> findList(TpmBudgetGenerateRuleReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<TpmBudgetGenerateRuleRespVo> list = this.tpmBudgetGenerateRuleMapper.findList((Page<TpmBudgetGenerateRuleRespVo>)page, reqVo);
        this.tpmBudgetGenerateRuleHelper.convertListDate(list);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public TpmBudgetGenerateRuleRespVo query(String id) {
        TpmBudgetGenerateRuleEntity entity = (TpmBudgetGenerateRuleEntity)((Object)this.tpmBudgetGenerateRuleMapper.selectById((Serializable)((Object)id)));
        return (TpmBudgetGenerateRuleRespVo)CrmBeanUtil.copy((Object)((Object)entity), TpmBudgetGenerateRuleRespVo.class);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(TpmBudgetGenerateRuleReqVo reqVo) {
        this.tpmBudgetGenerateRuleHelper.checkData(reqVo);
        TpmBudgetGenerateRuleEntity entity = (TpmBudgetGenerateRuleEntity)((Object)CrmBeanUtil.copy((Object)reqVo, TpmBudgetGenerateRuleEntity.class));
        entity.setBudgetRuleCode(CodeUtil.generateCode((String)CodeRuleEnum.BUDGET_RULE_CODE.getCode()));
        StringBuilder msg = new StringBuilder();
        this.generateFeeBudget(entity, msg);
        this.save((Object)entity);
        this.checkMsg(msg);
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        TpmBudgetGenerateRuleRespVo newData = (TpmBudgetGenerateRuleRespVo)CrmBeanUtil.copy((Object)((Object)entity), TpmBudgetGenerateRuleRespVo.class);
        this.crmLogSendUtil.sendForAdd(menuCodeObj.toString(), newData.getId(), newData.getId(), (Object)newData);
    }

    private void generateFeeBudget(TpmBudgetGenerateRuleEntity entity, StringBuilder msg) {
        List incomeBudgetEntities;
        if (entity.getIsGenerate().equals(YesNoEnum.yesNoEnum.ZERO.getValue())) {
            return;
        }
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(TpmIncomeBudgetEntity.class).eq(TpmIncomeBudgetEntity::getFeeBudgetType, (Object)entity.getFeeBudgetType())).eq(TpmIncomeBudgetEntity::getBudgetYear, (Object)entity.getYear())).eq(TpmIncomeBudgetEntity::getBudgetMonth, (Object)entity.getMonth());
        if (entity.getOrgCode() != null) {
            wrapper.eq(TpmIncomeBudgetEntity::getOrgCode, (Object)entity.getOrgCode());
        }
        if (entity.getCustomerCode() != null) {
            wrapper.eq(TpmIncomeBudgetEntity::getCustomerCode, (Object)entity.getCustomerCode());
        }
        if (entity.getTerminalCode() != null) {
            wrapper.eq(TpmIncomeBudgetEntity::getTerminalCode, (Object)entity.getTerminalCode());
        }
        if (entity.getChannel() != null) {
            wrapper.eq(TpmIncomeBudgetEntity::getChannel, (Object)entity.getChannel());
        }
        if (CollectionUtils.isNotEmpty((Collection)(incomeBudgetEntities = this.tpmIncomeBudgetMapper.selectList((Wrapper)wrapper)))) {
            String userName = UserUtils.getUser().getUsername();
            incomeBudgetEntities.forEach(tpmIncomeBudgetEntity -> {
                TpmFeeBudgetReqVo feeBudgetReqVo = (TpmFeeBudgetReqVo)CrmBeanUtil.copy((Object)tpmIncomeBudgetEntity, TpmFeeBudgetReqVo.class);
                feeBudgetReqVo.setId(null);
                feeBudgetReqVo.setBudgetQuater(String.valueOf(DateUtil.getQuaterByMonth((int)Integer.parseInt(feeBudgetReqVo.getBudgetMonth()))));
                feeBudgetReqVo.setInitAmount(tpmIncomeBudgetEntity.getInitAmount().multiply(entity.getRatio()).divide(new BigDecimal(100)));
                feeBudgetReqVo.setLockUserName(userName);
                feeBudgetReqVo.setFeeBudgetDetailType(FeeBudgetDetailTypeEnum.INIT.getCode());
                feeBudgetReqVo.setBudgetSubjectsCode(entity.getBudgetSubjectCode());
                feeBudgetReqVo.setBudgetSubjectsName(entity.getBudgetSubjectName());
                feeBudgetReqVo.setIsIncomeGenerate(Boolean.valueOf(true));
                this.tpmFeeBudgetService.save(feeBudgetReqVo);
            });
        } else {
            msg.append("\u89c4\u5219:").append(entity.getBudgetRuleCode()).append("\u672a\u627e\u5230\u5bf9\u5e94\u7ef4\u5ea6\u6536\u5165\u9884\u7b97;");
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(TpmBudgetGenerateRuleReqVo reqVo) {
        this.tpmBudgetGenerateRuleHelper.checkData(reqVo);
        TpmBudgetGenerateRuleEntity entity = (TpmBudgetGenerateRuleEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        if (entity.getIsGenerate().equals(YesNoEnum.yesNoEnum.ONE.getValue())) {
            throw new BusinessException("\u8be5\u89c4\u5219\u5df2\u751f\u6210\u8d39\u7528\u9884\u7b97\uff0c\u4e0d\u5141\u8bb8\u7f16\u8f91");
        }
        TpmBudgetGenerateRuleRespVo oldObject = (TpmBudgetGenerateRuleRespVo)CrmBeanUtil.copy((Object)((Object)entity), TpmBudgetGenerateRuleRespVo.class);
        StringBuilder msg = new StringBuilder();
        CrmBeanUtil.copyProperties((Object)reqVo, (Object)((Object)entity));
        this.generateFeeBudget(entity, msg);
        this.checkMsg(msg);
        TpmBudgetGenerateRuleRespVo newObject = (TpmBudgetGenerateRuleRespVo)CrmBeanUtil.copy((Object)((Object)entity), TpmBudgetGenerateRuleRespVo.class);
        this.updateById((Object)entity);
        this.crmLogSendUtil.sendForUpdate(ThreadLocalUtil.getObj((String)"menuCode").toString(), reqVo.getId(), reqVo.getId(), (Object)oldObject, (Object)newObject);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<String> ids) {
        List tpmBudgetGenerateRuleEntities = this.tpmBudgetGenerateRuleMapper.selectBatchIds(ids);
        ArrayList old = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)tpmBudgetGenerateRuleEntities)) {
            tpmBudgetGenerateRuleEntities.forEach(o -> {
                if (o.getIsGenerate().equals(YesNoEnum.yesNoEnum.ONE.getValue())) {
                    throw new BusinessException("\u6240\u9009\u6570\u636e\u5df2\u751f\u6210\u8d39\u7528\u9884\u7b97\uff0c\u4e0d\u5141\u8bb8\u5220\u9664");
                }
                old.add(CrmBeanUtil.copy((Object)o, TpmBudgetGenerateRuleRespVo.class));
            });
        }
        this.removeByIds(ids);
        old.forEach(o -> this.crmLogSendUtil.sendForDel(ThreadLocalUtil.getObj((String)"menuCode").toString(), o.getId(), o.getId(), CrmBeanUtil.copy((Object)o, TpmBudgetGenerateRuleRespVo.class)));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(TpmBudgetGenerateRuleReqVo reqVo) {
        List tpmBudgetGenerateRuleEntities = this.tpmBudgetGenerateRuleMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)tpmBudgetGenerateRuleEntities)) {
            tpmBudgetGenerateRuleEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(tpmBudgetGenerateRuleEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(TpmBudgetGenerateRuleReqVo reqVo) {
        List tpmBudgetGenerateRuleEntities = this.tpmBudgetGenerateRuleMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)tpmBudgetGenerateRuleEntities)) {
            tpmBudgetGenerateRuleEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(tpmBudgetGenerateRuleEntities);
    }

    private void checkMsg(StringBuilder msg) {
        if (StringUtils.isNotBlank((String)msg.toString())) {
            throw new BusinessException(msg.toString());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchGenerateFeeBudget(List<String> ids) {
        List entities = this.tpmBudgetGenerateRuleMapper.selectBatchIds(ids);
        StringBuilder msg = new StringBuilder();
        entities.forEach(entity -> {
            if (entity.getIsGenerate().equals(YesNoEnum.yesNoEnum.ZERO.getValue())) {
                entity.setIsGenerate(YesNoEnum.yesNoEnum.ONE.getValue());
                this.generateFeeBudget((TpmBudgetGenerateRuleEntity)((Object)entity), msg);
            }
        });
        this.updateBatchById(entities);
        this.checkMsg(msg);
    }
}

