/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.feerateform.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.PageResult;
import com.biz.crm.feerateform.mapper.FeeRateFormMapper;
import com.biz.crm.feerateform.service.FeeRateFormService;
import com.biz.crm.nebular.tpm.feerateform.FeeRateFormReqVo;
import com.biz.crm.nebular.tpm.feerateform.FeeRateFormRespVo;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.PageUtil;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class FeeRateFormServiceImpl
implements FeeRateFormService {
    @Resource
    private FeeRateFormMapper feeRateFormMapper;

    @Override
    public PageResult<FeeRateFormRespVo> list(FeeRateFormReqVo reqVo) {
        Integer month = Integer.parseInt(reqVo.getYearMonth().substring(5, 7));
        Date yearMonthDate = DateUtil.parse((String)reqVo.getYearMonth(), (String)"yyyy-MM");
        Calendar lastMonth = Calendar.getInstance();
        lastMonth.setTime(yearMonthDate);
        lastMonth.add(2, -1);
        String lastMonthStr = DateUtil.yyyy_MM.format(lastMonth.getTime());
        reqVo.setLastMonth(lastMonthStr);
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<FeeRateFormRespVo> pageList = this.feeRateFormMapper.findPageList((Page<FeeRateFormRespVo>)page, reqVo);
        for (FeeRateFormRespVo v : pageList) {
            v.setMonth(month);
            if (BigDecimal.ZERO.compareTo(v.getAmountSum()) == 0) continue;
            v.setRate(v.getApplyAmountSum().multiply(new BigDecimal(100)).divide(v.getAmountSum(), 0, 1));
        }
        return PageResult.builder().data(pageList).count(Long.valueOf(page.getTotal())).build();
    }
}

