/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.feewithholding.controller;

import com.biz.crm.act.service.ITpmActService;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.tpm.ActApproveStatusEnum;
import com.biz.crm.feewithholding.service.ITpmFeeWithholdingService;
import com.biz.crm.nebular.tpm.act.req.TpmActReqVo;
import com.biz.crm.nebular.tpm.act.resp.TpmActRespVo;
import com.biz.crm.nebular.tpm.act.resp.TpmFeeWithholdingActRespVo;
import com.biz.crm.nebular.tpm.feewithholding.req.TpmFeeWithholdingReqVo;
import com.biz.crm.nebular.tpm.feewithholding.resp.TpmFeeWithholdingRespVo;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/tpmfeewithholding"})
@Api(tags={"\u8d39\u7528\u9884\u63d0"})
public class TpmFeeWithholdingController {
    private static final Logger log = LoggerFactory.getLogger(TpmFeeWithholdingController.class);
    @Autowired
    private ITpmFeeWithholdingService tpmFeeWithholdingService;
    @Autowired
    private ITpmActService tpmActService;

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @PostMapping(value={"/list"})
    @CrmLog
    public Result<PageResult<TpmFeeWithholdingRespVo>> list(@RequestBody TpmFeeWithholdingReqVo tpmFeeWithholdingReqVo) {
        PageResult<TpmFeeWithholdingRespVo> result = this.tpmFeeWithholdingService.findList(tpmFeeWithholdingReqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @PostMapping(value={"/actList"})
    @CrmLog
    public Result<PageResult<TpmActRespVo>> actList(@RequestBody TpmActReqVo tpmActReqVo) {
        tpmActReqVo.setMaxYearMonth(DateUtil.getFormatDateStr((Date)new Date(), (String)"yyyy-MM"));
        tpmActReqVo.setApproveStatus(ActApproveStatusEnum.APPROVED.getCode());
        PageResult<TpmActRespVo> result = this.tpmActService.findList(tpmActReqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u67e5\u8be2")
    @GetMapping(value={"/query"})
    @CrmLog
    public Result<TpmFeeWithholdingRespVo> query(@RequestParam(value="id") String id) {
        TpmFeeWithholdingRespVo respVo = this.tpmFeeWithholdingService.query(id);
        return Result.ok((Object)respVo);
    }

    @ApiOperation(value="\u81ea\u52a8\u9884\u63d0")
    @PostMapping(value={"/auto"})
    @CrmLog
    public Result auto(@RequestBody TpmFeeWithholdingReqVo tpmFeeWithholdingReqVo) {
        this.tpmFeeWithholdingService.auto(tpmFeeWithholdingReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u624b\u5de5\u9884\u63d0")
    @PostMapping(value={"/handle"})
    @CrmLog
    public Result handle(@RequestBody List<TpmFeeWithholdingReqVo> reqVos) {
        this.tpmFeeWithholdingService.handle(reqVos);
        return Result.ok();
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PostMapping(value={"/update"})
    @CrmLog
    public Result update(@RequestBody TpmFeeWithholdingReqVo tpmFeeWithholdingReqVo) {
        this.tpmFeeWithholdingService.update(tpmFeeWithholdingReqVo);
        return Result.ok((String)"\u4fee\u6539\u6210\u529f");
    }

    @ApiOperation(value="\u5220\u9664")
    @PostMapping(value={"/delete"})
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        this.tpmFeeWithholdingService.deleteBatch(ids);
        return Result.ok((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u542f\u7528")
    @PostMapping(value={"/enable"})
    @CrmLog
    public Result enable(@RequestBody TpmFeeWithholdingReqVo tpmFeeWithholdingReqVo) {
        this.tpmFeeWithholdingService.enableBatch(tpmFeeWithholdingReqVo);
        return Result.ok((String)"\u542f\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u7981\u7528")
    @PostMapping(value={"/disable"})
    @CrmLog
    public Result disable(@RequestBody TpmFeeWithholdingReqVo tpmFeeWithholdingReqVo) {
        this.tpmFeeWithholdingService.disableBatch(tpmFeeWithholdingReqVo);
        return Result.ok((String)"\u7981\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u624b\u5de5\u65b0\u589e\u8d39\u7528\u9884\u63d0\u67e5\u627e\u6d3b\u52a8\u660e\u7ec6")
    @PostMapping(value={"findActDetailByFeeWithholding"})
    @CrmLog
    public Result<List<TpmFeeWithholdingActRespVo>> findActDetailByFeeWithholding(@RequestBody List<String> actCodeList) {
        List<TpmFeeWithholdingActRespVo> result = this.tpmFeeWithholdingService.findActDetailByFeeWithholding(actCodeList);
        return Result.ok(result);
    }
}

