/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.feewithholding.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.act.mapper.TpmActDetailMapper;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.common.PageResult;
import com.biz.crm.crmlog.handle.util.CrmLogSendUtil;
import com.biz.crm.eunm.CodeRuleEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.tpm.SendStatusEnum;
import com.biz.crm.eunm.tpm.WithholdingTypeEnum;
import com.biz.crm.feewithholding.mapper.TpmFeeWithholdingMapper;
import com.biz.crm.feewithholding.model.TpmFeeWithholdingEntity;
import com.biz.crm.feewithholding.service.ITpmFeeWithholdingService;
import com.biz.crm.nebular.tpm.act.req.TpmFeeWithholdingActReqVo;
import com.biz.crm.nebular.tpm.act.resp.TpmFeeWithholdingActRespVo;
import com.biz.crm.nebular.tpm.feewithholding.req.TpmFeeWithholdingReqVo;
import com.biz.crm.nebular.tpm.feewithholding.resp.TpmFeeWithholdingRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.StringUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"TpmFeeWithholdingServiceExpandImpl"})
public class TpmFeeWithholdingServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<TpmFeeWithholdingMapper, TpmFeeWithholdingEntity>
implements ITpmFeeWithholdingService {
    private static final Logger log = LoggerFactory.getLogger(TpmFeeWithholdingServiceImpl.class);
    @Resource
    private TpmFeeWithholdingMapper tpmFeeWithholdingMapper;
    @Resource
    private TpmActDetailMapper tpmActDetailMapper;
    @Resource
    private CrmLogSendUtil crmLogSendUtil;

    public Map<String, Map<String, String>> getDicts() {
        ArrayList dictCodes = Lists.newArrayList();
        dictCodes.add("withholding_type");
        dictCodes.add("send_status");
        return DictUtil.getDictValueMapsByCodes((List)dictCodes);
    }

    @Override
    public PageResult<TpmFeeWithholdingRespVo> findList(TpmFeeWithholdingReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<TpmFeeWithholdingRespVo> list = this.tpmFeeWithholdingMapper.findList((Page<TpmFeeWithholdingRespVo>)page, reqVo);
        this.convertListDate(list);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    public void convertListDate(List<TpmFeeWithholdingRespVo> list) {
        if (CollectionUtils.isNotEmpty(list)) {
            Map<String, Map<String, String>> map = this.getDicts();
            list.forEach(o -> {
                if (StringUtils.isNotEmpty((String)o.getEnableStatus())) {
                    o.setEnableStatusName((String)((Map)Optional.ofNullable(map.get("enable_status")).orElse(Maps.newHashMap())).get(o.getEnableStatus()));
                }
                if (StringUtils.isNotEmpty((String)o.getWithholdingType())) {
                    o.setWithholdingTypeName((String)((Map)Optional.ofNullable(map.get("withholding_type")).orElse(Maps.newHashMap())).get(o.getWithholdingType()));
                }
                if (StringUtils.isNotEmpty((String)o.getSendStatus())) {
                    o.setSendStatusName((String)((Map)Optional.ofNullable(map.get("send_status")).orElse(Maps.newHashMap())).get(o.getSendStatus()));
                }
            });
        }
    }

    @Override
    public TpmFeeWithholdingRespVo query(String id) {
        TpmFeeWithholdingRespVo respVo = (TpmFeeWithholdingRespVo)CrmBeanUtil.copy((Object)this.tpmFeeWithholdingMapper.findById(id), TpmFeeWithholdingRespVo.class);
        this.convertListDate(Lists.newArrayList((Object[])new TpmFeeWithholdingRespVo[]{respVo}));
        return respVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void auto(TpmFeeWithholdingReqVo reqVo) {
        Date date;
        try {
            date = DateUtil.yyyy_MM.parse(reqVo.getYearAndMonth());
        }
        catch (Exception e) {
            throw new BusinessException("\u65f6\u95f4\u683c\u5f0f\u9519\u8bef");
        }
        AssertUtils.isFalse((boolean)DateUtil.monthNotBeforeNow((Date)date), (String)"\u53ea\u80fd\u9884\u63d0\u5f53\u524d\u6708\u4ee5\u524d\u7684\u6d3b\u52a8");
        List<TpmFeeWithholdingActRespVo> respVos = this.tpmActDetailMapper.forFeeWithholding(TpmFeeWithholdingActReqVo.builder().feeDateStr(reqVo.getYearAndMonth()).build());
        ArrayList<TpmFeeWithholdingEntity> updateData = new ArrayList<TpmFeeWithholdingEntity>();
        ArrayList<TpmFeeWithholdingEntity> addData = new ArrayList<TpmFeeWithholdingEntity>();
        HashMap entityMap = CollectionUtil.listNotEmpty(respVos) ? this.searchExist(respVos.stream().map(TpmFeeWithholdingActRespVo::getActDetailCode).collect(Collectors.toList())) : new HashMap();
        respVos.forEach(o -> {
            TpmFeeWithholdingEntity entity = (TpmFeeWithholdingEntity)((Object)((Object)entityMap.get(o.getActDetailCode())));
            if (entity != null) {
                if (SendStatusEnum.NOT_SEND.getCode().equals(entity.getSendStatus())) {
                    TpmFeeWithholdingRespVo oldData = (TpmFeeWithholdingRespVo)CrmBeanUtil.copy((Object)((Object)entity), TpmFeeWithholdingRespVo.class);
                    entity.setWithholdingAmount(o.getApplyAmount().subtract(o.getAccountAmount()));
                    TpmFeeWithholdingRespVo newData = (TpmFeeWithholdingRespVo)CrmBeanUtil.copy((Object)((Object)entity), TpmFeeWithholdingRespVo.class);
                    this.crmLogSendUtil.sendForUpdate(ThreadLocalUtil.getObj((String)"menuCode").toString(), entity.getId(), entity.getId(), (Object)oldData, (Object)newData);
                    updateData.add(entity);
                }
            } else {
                entity = new TpmFeeWithholdingEntity();
                entity.setWithholdingAmount(o.getApplyAmount().subtract(o.getAccountAmount()));
                entity.setYearAndMonth(reqVo.getYearAndMonth());
                entity.setActDetailCode(o.getActDetailCode());
                entity.setWithholdingType(WithholdingTypeEnum.AUTO.getCode());
                addData.add(entity);
            }
        });
        this.saveOrUpdate(addData, updateData);
    }

    private void saveOrUpdate(List<TpmFeeWithholdingEntity> addData, List<TpmFeeWithholdingEntity> updateData) {
        if (updateData.size() == 0 && addData.size() == 0) {
            throw new BusinessException("\u65e0\u53ef\u65b0\u589e\u6216\u66f4\u65b0\u9884\u63d0\u6570\u636e");
        }
        if (addData.size() > 0) {
            List codes = CodeUtil.generateCodeList((String)CodeRuleEnum.FEE_WITHHOLDING.getCode(), (int)addData.size());
            for (int i = 0; i < addData.size(); ++i) {
                TpmFeeWithholdingEntity newData = addData.get(i);
                newData.setSendStatus(SendStatusEnum.NOT_SEND.getCode());
                newData.setWithholdingCode((String)codes.get(i));
                this.crmLogSendUtil.sendForAdd(ThreadLocalUtil.getObj((String)"menuCode").toString(), newData.getId(), newData.getId(), CrmBeanUtil.copy((Object)((Object)newData), TpmFeeWithholdingRespVo.class));
            }
            this.saveBatch(addData);
        }
        if (updateData.size() > 0) {
            this.updateBatchById(updateData);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void handle(List<TpmFeeWithholdingReqVo> reqVos) {
        List<String> actDetailCodeList = reqVos.stream().map(TpmFeeWithholdingReqVo::getActDetailCode).collect(Collectors.toList());
        Map<String, TpmFeeWithholdingActRespVo> actRespVoMap = this.tpmActDetailMapper.forFeeWithholding(TpmFeeWithholdingActReqVo.builder().actCodeDetailList(actDetailCodeList).build()).stream().collect(Collectors.toMap(TpmFeeWithholdingActRespVo::getActDetailCode, respVo -> respVo));
        Map<String, TpmFeeWithholdingEntity> entityMap = this.searchExist(actDetailCodeList);
        StringBuilder msg = new StringBuilder();
        ArrayList<TpmFeeWithholdingEntity> updateData = new ArrayList<TpmFeeWithholdingEntity>();
        ArrayList<TpmFeeWithholdingEntity> addData = new ArrayList<TpmFeeWithholdingEntity>();
        reqVos.forEach(reqVo -> {
            TpmFeeWithholdingEntity entity = (TpmFeeWithholdingEntity)((Object)((Object)CrmBeanUtil.copy((Object)reqVo, TpmFeeWithholdingEntity.class)));
            TpmFeeWithholdingActRespVo respVo = (TpmFeeWithholdingActRespVo)actRespVoMap.get(reqVo.getActDetailCode());
            if (respVo == null) {
                msg.append("\u672a\u627e\u5230\u6d3b\u52a8\u660e\u7ec6:").append(reqVo.getActDetailCode()).append(";");
            } else {
                if (respVo.getApplyAmount().subtract(respVo.getAccountAmount()).compareTo(reqVo.getWithholdingAmount()) < 0) {
                    msg.append("\u6d3b\u52a8:").append(reqVo.getActDetailCode()).append("\u53ef\u9884\u63d0\u91d1\u989d\u4e0d\u8db3;");
                }
                try {
                    if (DateUtil.monthNotBeforeNow((Date)DateUtil.yyyy_MM.parse(respVo.getFeeDateStr()))) {
                        msg.append("\u6d3b\u52a8:").append(reqVo.getActDetailCode()).append("\u4e0d\u662f\u5f53\u524d\u6708\u4ee5\u524d\u7684\u6d3b\u52a8;");
                    }
                }
                catch (Exception e) {
                    msg.append("\u6d3b\u52a8:").append(reqVo.getActDetailCode()).append("\u8d39\u7528\u6240\u5c5e\u5e74\u6708\u65f6\u95f4\u683c\u5f0f\u9519\u8bef;");
                }
            }
            TpmFeeWithholdingEntity checkEntity = (TpmFeeWithholdingEntity)((Object)((Object)entityMap.get(reqVo.getActDetailCode())));
            if (checkEntity != null) {
                if (SendStatusEnum.SEND.getCode().equals(checkEntity.getSendStatus())) {
                    return;
                }
                entity.setId(checkEntity.getId());
                updateData.add(entity);
            } else {
                if (respVo != null) {
                    entity.setYearAndMonth(respVo.getFeeDateStr());
                }
                entity.setWithholdingType(WithholdingTypeEnum.HANDLE.getCode());
                entity.setActDetailCode(reqVo.getActDetailCode());
                addData.add(entity);
            }
        });
        if (!StringUtils.isEmpty((String)msg.toString())) {
            throw new BusinessException(msg.toString());
        }
        this.saveOrUpdate(addData, updateData);
    }

    private Map<String, TpmFeeWithholdingEntity> searchExist(List<String> actDetailCodeList) {
        Map<String, TpmFeeWithholdingEntity> entityMap = this.tpmFeeWithholdingMapper.selectList((Wrapper)Wrappers.lambdaQuery(TpmFeeWithholdingEntity.class).in(TpmFeeWithholdingEntity::getActDetailCode, actDetailCodeList)).stream().collect(Collectors.toMap(TpmFeeWithholdingEntity::getActDetailCode, o -> o));
        return entityMap;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(TpmFeeWithholdingReqVo reqVo) {
        TpmFeeWithholdingEntity entity = (TpmFeeWithholdingEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        if (SendStatusEnum.SEND.getCode().equals(entity.getSendStatus())) {
            throw new BusinessException("\u8d39\u7528\u9884\u63d0\u5df2\u63a8\u9001");
        }
        List<TpmFeeWithholdingActRespVo> list = this.tpmActDetailMapper.forFeeWithholding(TpmFeeWithholdingActReqVo.builder().actCodeDetailList((List)Lists.newArrayList((Object[])new String[]{entity.getActDetailCode()})).build());
        if (list.size() == 0) {
            throw new BusinessException("\u5bf9\u5e94\u6d3b\u52a8\u660e\u7ec6\u4e0d\u5b58\u5728");
        }
        TpmFeeWithholdingActRespVo actRespVo = list.get(0);
        if (reqVo.getWithholdingAmount().compareTo(actRespVo.getApplyAmount().subtract(actRespVo.getAccountAmount())) > 0) {
            throw new BusinessException("\u6d3b\u52a8\u53ef\u9884\u63d0\u91d1\u989d\u4e0d\u8db3");
        }
        entity.setWithholdingAmount(reqVo.getWithholdingAmount());
        this.updateById((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<String> ids) {
        if (CollectionUtils.isNotEmpty(ids)) {
            this.tpmFeeWithholdingMapper.deleteBatchIds(ids);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(TpmFeeWithholdingReqVo reqVo) {
        List tpmFeeWithholdingEntities = this.tpmFeeWithholdingMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)tpmFeeWithholdingEntities)) {
            tpmFeeWithholdingEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(tpmFeeWithholdingEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(TpmFeeWithholdingReqVo reqVo) {
        List tpmFeeWithholdingEntities = this.tpmFeeWithholdingMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)tpmFeeWithholdingEntities)) {
            tpmFeeWithholdingEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(tpmFeeWithholdingEntities);
    }

    @Override
    public List<TpmFeeWithholdingActRespVo> findActDetailByFeeWithholding(List<String> actCodeList) {
        return this.tpmActDetailMapper.forFeeWithholding(TpmFeeWithholdingActReqVo.builder().actCodeList(actCodeList).feeDateStrEnd(DateUtil.getFormatDateStr((Date)new Date(), (String)"yyyy-MM")).build());
    }
}

