/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.invoicepool.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.eunm.tpm.InvoiceTypeEnum;
import com.biz.crm.invoicepool.mapper.TpmInvoicePoolMapper;
import com.biz.crm.invoicepool.model.TpmInvoicePoolEntity;
import com.biz.crm.nebular.tpm.audit.req.TpmAuditInvoiceReqVo;
import com.biz.crm.nebular.tpm.invoicepool.req.TpmInvoicePoolReqVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.NumberUtil;
import java.math.BigDecimal;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class TpmInvoiceHelper {
    @Resource
    private TpmInvoicePoolMapper tpmInvoicePoolMapper;

    public void checkInvoice(TpmInvoicePoolReqVo o) {
        AssertUtils.isNotEmpty((String)o.getInvoiceType(), (String)"\u53d1\u7968\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)o.getInvoiceCode(), (String)"\u53d1\u7968\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)o.getInvoiceNumber(), (String)"\u53d1\u7968\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        NumberUtil.checkNumber((BigDecimal)o.getTotalAmount(), (String)"\u7a0e\u4ef7\u5408\u8ba1", (BigDecimal)BigDecimal.ZERO, null);
        if (InvoiceTypeEnum.SPECIAL_VAT.getCode().equals(o.getInvoiceType()) || InvoiceTypeEnum.ORDINARY_VAT.getCode().equals(o.getInvoiceType())) {
            NumberUtil.checkNumber((BigDecimal)o.getAmount(), (String)"\u4e0d\u542b\u7a0e\u91d1\u989d", (BigDecimal)BigDecimal.ZERO, null);
            NumberUtil.checkNumber((BigDecimal)o.getTaxRate(), (String)"\u7a0e\u7387", (BigDecimal)BigDecimal.ZERO, null);
            NumberUtil.checkNumber((BigDecimal)o.getTaxAmount(), (String)"\u7a0e\u989d", (BigDecimal)BigDecimal.ZERO, null);
            AssertUtils.isTrue((o.getTotalAmount().multiply(o.getTaxRate()).divide(new BigDecimal(100)).compareTo(o.getTaxAmount()) == 0 ? 1 : 0) != 0, (String)"\u7a0e\u989d\u5e94\u7b49\u4e8e\u7a0e\u7387\u4e58\u7a0e\u4ef7\u5408\u8ba1");
            AssertUtils.isTrue((o.getTotalAmount().compareTo(o.getAmount().add(o.getTaxAmount())) == 0 ? 1 : 0) != 0, (String)"\u4e0d\u542b\u91d1\u989d\u52a0\u7a0e\u989d\u5e94\u7b49\u4e8e\u7a0e\u4ef7\u5408\u8ba1");
            AssertUtils.isNotEmpty((String)o.getPurchaserName(), (String)"\u8d2d\u4e70\u65b9\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.isNotEmpty((String)o.getPurchaserTaxpayerNumber(), (String)"\u8d2d\u4e70\u65b9\u7a0e\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.isNotEmpty((String)o.getSellerName(), (String)"\u9500\u552e\u65b9\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.isNotEmpty((String)o.getSellerTaxpayerNumber(), (String)"\u9500\u552e\u65b9\u7a0e\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.isNotEmpty((String)o.getSellerAccount(), (String)"\u9500\u552e\u65b9\u5f00\u884c\u53f7\u53ca\u8d26\u6237\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.isNotEmpty((String)o.getSellerInfo(), (String)"\u9500\u552e\u65b9\u5730\u5740\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a");
            if (InvoiceTypeEnum.SPECIAL_VAT.getCode().equals(o.getInvoiceType())) {
                AssertUtils.isNotEmpty((String)o.getPurchaserAccount(), (String)"\u8d2d\u4e70\u65b9\u5f00\u884c\u53f7\u53ca\u8d26\u6237\u4e0d\u80fd\u4e3a\u7a7a");
                AssertUtils.isNotEmpty((String)o.getPurchaserInfo(), (String)"\u8d2d\u4e70\u65b9\u5730\u5740\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a");
            }
        } else if (!InvoiceTypeEnum.STABLE.getCode().equals(o.getInvoiceType())) {
            throw new BusinessException("\u672a\u627e\u5230\u7684\u53d1\u7968\u7c7b\u578b");
        }
    }

    public void checkInvoicePool(TpmInvoicePoolReqVo o) {
        this.checkInvoice(o);
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery(TpmInvoicePoolEntity.class).eq(TpmInvoicePoolEntity::getInvoiceNumber, (Object)o.getInvoiceNumber());
        if (o.getId() != null) {
            wrapper.ne(BaseIdEntity::getId, (Object)o.getId());
        }
        if (this.tpmInvoicePoolMapper.selectOne((Wrapper)wrapper) != null) {
            throw new BusinessException("\u5df2\u5b58\u5728\u76f8\u540c\u53d1\u7968\u53f7\u7801\u7684\u53d1\u7968,\u8bf7\u52ff\u91cd\u590d\u4e0a\u4f20");
        }
    }

    public void checkAuditInvoice(TpmAuditInvoiceReqVo o) {
        NumberUtil.checkNumber((BigDecimal)o.getUsedAmount(), (String)"\u5df2\u4f7f\u7528\u91d1\u989d", (BigDecimal)BigDecimal.ZERO, null);
        NumberUtil.checkNumber((BigDecimal)o.getAvailableAmount(), (String)"\u53ef\u7528\u4f59\u989d", (BigDecimal)BigDecimal.ZERO, null);
        AssertUtils.isTrue((o.getTotalAmount().compareTo(o.getUsedAmount().add(o.getAvailableAmount())) == 0 ? 1 : 0) != 0, (String)"\u5df2\u4f7f\u7528\u91d1\u989d\u52a0\u53ef\u7528\u4f59\u989d\u5e94\u7b49\u4e8e\u7a0e\u4ef7\u5408\u8ba1");
        NumberUtil.checkNumber((BigDecimal)o.getUseAmount(), (String)"\u672c\u6b21\u4f7f\u7528\u91d1\u989d", (BigDecimal)BigDecimal.ZERO, null);
        this.checkInvoice((TpmInvoicePoolReqVo)o);
        TpmInvoicePoolEntity check = (TpmInvoicePoolEntity)((Object)this.tpmInvoicePoolMapper.selectOne((Wrapper)Wrappers.lambdaQuery(TpmInvoicePoolEntity.class).eq(TpmInvoicePoolEntity::getInvoiceNumber, (Object)o.getInvoiceNumber())));
        BigDecimal availableAmount = o.getTotalAmount();
        if (check != null) {
            if (check.getAvailableAmount().compareTo(BigDecimal.ZERO) <= 0) {
                throw new BusinessException("\u53d1\u7968" + o.getInvoiceNumber() + "\u53ef\u7528\u4f59\u989d\u4e3a0,\u8bf7\u91cd\u65b0\u4e0a\u4f20");
            }
            availableAmount = check.getAvailableAmount();
        }
        if (o.getUseAmount().compareTo(availableAmount) > 0) {
            throw new BusinessException("\u53d1\u7968" + o.getInvoiceNumber() + "\u4f7f\u7528\u91d1\u989d\u5927\u4e8e\u53ef\u7528\u4f59\u989d");
        }
    }
}

