/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.invoicepool.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.common.PageResult;
import com.biz.crm.crmlog.handle.util.CrmLogSendUtil;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.invoicepool.mapper.TpmInvoicePoolMapper;
import com.biz.crm.invoicepool.model.TpmInvoicePoolEntity;
import com.biz.crm.invoicepool.service.ITpmInvoicePoolService;
import com.biz.crm.invoicepool.service.impl.TpmInvoiceHelper;
import com.biz.crm.nebular.tpm.invoicepool.req.TpmInvoicePoolReqVo;
import com.biz.crm.nebular.tpm.invoicepool.resp.TpmInvoicePoolRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.NumberUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.StringUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"TpmInvoicePoolServiceExpandImpl"})
public class TpmInvoicePoolServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<TpmInvoicePoolMapper, TpmInvoicePoolEntity>
implements ITpmInvoicePoolService {
    private static final Logger log = LoggerFactory.getLogger(TpmInvoicePoolServiceImpl.class);
    @Resource
    private TpmInvoicePoolMapper tpmInvoicePoolMapper;
    @Resource
    private CrmLogSendUtil crmLogSendUtil;
    @Autowired
    private TpmInvoiceHelper invoiceHelper;

    @Override
    public PageResult<TpmInvoicePoolRespVo> findList(TpmInvoicePoolReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<TpmInvoicePoolRespVo> list = this.tpmInvoicePoolMapper.findList((Page<TpmInvoicePoolRespVo>)page, reqVo);
        this.convertData(list);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    private void convertData(List<TpmInvoicePoolRespVo> list) {
        if (CollectionUtils.isNotEmpty(list)) {
            Map map = DictUtil.getDictValueMapsByCodes((List)Lists.newArrayList((Object[])new String[]{"enable_status", "invoice_type"}));
            list.forEach(o -> {
                if (StringUtils.isNotEmpty((String)o.getEnableStatus())) {
                    o.setEnableStatusName((String)((Map)Optional.ofNullable(map.get("enable_status")).orElse(Maps.newHashMap())).get(o.getEnableStatus()));
                }
                if (StringUtils.isNotEmpty((String)o.getInvoiceType())) {
                    o.setInvoiceTypeName((String)((Map)Optional.ofNullable(map.get("invoice_type")).orElse(Maps.newHashMap())).get(o.getInvoiceType()));
                }
            });
        }
    }

    @Override
    public TpmInvoicePoolRespVo query(String id, String invoiceNumber) {
        if (id != null) {
            return (TpmInvoicePoolRespVo)CrmBeanUtil.copy((Object)this.tpmInvoicePoolMapper.selectById((Serializable)((Object)id)), TpmInvoicePoolRespVo.class);
        }
        if (invoiceNumber != null) {
            return (TpmInvoicePoolRespVo)CrmBeanUtil.copy((Object)this.tpmInvoicePoolMapper.selectOne((Wrapper)Wrappers.lambdaQuery(TpmInvoicePoolEntity.class).eq(TpmInvoicePoolEntity::getInvoiceNumber, (Object)invoiceNumber)), TpmInvoicePoolRespVo.class);
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(TpmInvoicePoolReqVo reqVo) {
        this.invoiceHelper.checkInvoicePool(reqVo);
        TpmInvoicePoolEntity entity = (TpmInvoicePoolEntity)((Object)CrmBeanUtil.copy((Object)reqVo, TpmInvoicePoolEntity.class));
        entity.setUsedAmount(entity.getTotalAmount());
        entity.setAvailableAmount(BigDecimal.ZERO);
        this.save((Object)entity);
        TpmInvoicePoolRespVo newData = (TpmInvoicePoolRespVo)CrmBeanUtil.copy((Object)((Object)entity), TpmInvoicePoolRespVo.class);
        this.crmLogSendUtil.sendForAdd(ThreadLocalUtil.getObj((String)"menuCode").toString(), newData.getId(), newData.getId(), (Object)newData);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(TpmInvoicePoolReqVo reqVo) {
        this.invoiceHelper.checkInvoice(reqVo);
        TpmInvoicePoolEntity entity = (TpmInvoicePoolEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        TpmInvoicePoolRespVo oldData = (TpmInvoicePoolRespVo)CrmBeanUtil.copy((Object)((Object)entity), TpmInvoicePoolRespVo.class);
        CrmBeanUtil.copyProperties((Object)reqVo, (Object)((Object)entity));
        NumberUtil.checkNumber((BigDecimal)reqVo.getUsedAmount(), (String)"\u4f7f\u7528\u91d1\u989d", (BigDecimal)BigDecimal.ZERO, null);
        NumberUtil.checkNumber((BigDecimal)reqVo.getAvailableAmount(), (String)"\u53ef\u7528\u91d1\u989d", (BigDecimal)BigDecimal.ZERO, null);
        AssertUtils.isTrue((reqVo.getUsedAmount().add(reqVo.getAvailableAmount()).compareTo(reqVo.getTotalAmount()) == 0 ? 1 : 0) != 0, (String)"\u7a0e\u4ef7\u5408\u8ba1\u5e94\u7b49\u4e8e\u4f7f\u7528\u91d1\u989d\u52a0\u4e0a\u53ef\u7528\u4f59\u989d");
        TpmInvoicePoolRespVo newData = (TpmInvoicePoolRespVo)CrmBeanUtil.copy((Object)((Object)entity), TpmInvoicePoolRespVo.class);
        this.updateById((Object)entity);
        this.crmLogSendUtil.sendForUpdate(ThreadLocalUtil.getObj((String)"menuCode").toString(), newData.getId(), newData.getId(), (Object)oldData, (Object)newData);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<String> ids) {
        if (CollectionUtils.isNotEmpty(ids)) {
            this.tpmInvoicePoolMapper.deleteBatchIds(ids);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(TpmInvoicePoolReqVo reqVo) {
        List tpmInvoicePoolEntities = this.tpmInvoicePoolMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)tpmInvoicePoolEntities)) {
            tpmInvoicePoolEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(tpmInvoicePoolEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(TpmInvoicePoolReqVo reqVo) {
        List tpmInvoicePoolEntities = this.tpmInvoicePoolMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)tpmInvoicePoolEntities)) {
            tpmInvoicePoolEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(tpmInvoicePoolEntities);
    }
}

