package com.biz.crm.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.persistence.Index;

@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("webservice_log")
@CrmTable(name ="webservice_log",tableNote = "webservice日志",indexes = {
        @Index(name = "index_webservice_log_method", columnList = "method")
})
public class WebserviceLogEntity extends CrmExtTenEntity<WebserviceLogEntity> {
    @CrmColumn(name = "method",length = 100,note = "请求方法")
    private String method;
    @CrmColumn(name = "uuid", length = 40)
    private String uuid;
    @CrmColumn(name = "status", length = 10,note = "状态")
    private String status;
    @CrmColumn(name = "msg", length = 500)
    private String msg;
    @CrmColumn(name = "req_json", mysqlType = "text",oracleType = "CLOB",note = "请求数据")
    private String reqJson;
    @CrmColumn(name = "resp_json", mysqlType = "text",oracleType = "CLOB")
    private String respJson;
    @CrmColumn(name = "exception_stack", mysqlType = "text",oracleType = "CLOB",note ="异常信息" )
    private String exceptionStack;
    @CrmColumn(name = "req_date", length = 40)
    private String reqDate;
    @CrmColumn(name = "resp_date", length = 40)
    private String respDate;
    @CrmColumn(name = "token", length = 100,note = "当前请求token")
    private String token;

}
