package com.biz.crm.gaode.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.gaode.service.GaodeAroundService;
import com.biz.crm.gaode.vo.AmapPoiQueryReqVo;
import com.biz.crm.gaode.vo.AmapPoiResultVo;
import com.biz.crm.gaode.vo.GaodeNearbyVo;
import com.biz.crm.gaode.vo.QueryAroundVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author jianglong
 * @version V1.0
 * @Package com.biz.crm.gaode.controller
 * @Description: TODO
 * @date 2021/3/8 下午12:43
 */
@Slf4j
@RestController
@RequestMapping("/gaode/gaodeAroundController")
@Api(tags = "高德地图api ")
public class GaodeAroundController {
    @Autowired
    private GaodeAroundService gaodeAroundService;

    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<GaodeNearbyVo>> queryAround(@RequestBody QueryAroundVo queryAroundVo) {
        Result<PageResult<GaodeNearbyVo>> resultResult = new Result<>();
        PageResult<GaodeNearbyVo> pageResult = gaodeAroundService.queryAround(queryAroundVo);
        resultResult.setResult(pageResult);
        return resultResult;
    }

    @ApiOperation(value = "高德POI关键字查询")
    @PostMapping("/queryKeywords")
    @CrmLog
    public Result<AmapPoiResultVo> queryKeywords(@RequestBody AmapPoiQueryReqVo reqVo) {
        return Result.ok(gaodeAroundService.queryKeywords(reqVo));
    }
}
