package com.biz.crm.mail.service.impl;

import com.biz.crm.base.BusinessException;
import com.biz.crm.mail.config.MailConfig;
import com.biz.crm.mail.service.MailService;
import com.biz.crm.nebular.webservice.mail.CrmMailMessage;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Service;

import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;

@Slf4j
@Service
@ConditionalOnMissingBean(name = "MailServiceExpandImpl")
public class MailServiceImpl implements MailService {

    @Autowired
    private MailConfig mailConfig;
    @Autowired(required = false)
    private JavaMailSender javaMailSender;

    @Override
    public void sendMail(CrmMailMessage crmMailMessage) {
        try {
            log.info("开始校验发件参数");
            if (javaMailSender == null) {
                throw new BusinessException("邮箱配置不正确");
            }
            if (crmMailMessage == null) {
                throw new BusinessException("空参数");
            }
            if (StringUtils.isEmpty(crmMailMessage.getSubject())) {
                throw new BusinessException("邮件缺失主题");
            }
            if (StringUtils.isEmpty(crmMailMessage.getContent())) {
                throw new BusinessException("邮件缺失正文");
            }
            log.info("开始发送邮件，主题：{}", crmMailMessage.getSubject());
            if (crmMailMessage.getTo() == null || crmMailMessage.getTo().isEmpty()) {
                if (crmMailMessage.getCarbonCopy() == null || crmMailMessage.getCarbonCopy().isEmpty()) {
                    if (crmMailMessage.getBlindCarbonCopy() == null || crmMailMessage.getBlindCarbonCopy().isEmpty()) {
                        throw new BusinessException("邮件缺失收件人");
                    }
                }
            }
            MimeMessage mimeMessage = javaMailSender.createMimeMessage();
            MimeMessageHelper helper = new MimeMessageHelper(mimeMessage, true);
            String fromName = StringUtils.isNotEmpty(mailConfig.getNickname()) ? (mailConfig.getNickname() + "<" + mailConfig.getUsername() + ">") : mailConfig.getUsername();
            helper.setFrom(fromName);
            if (crmMailMessage.getTo() != null && !crmMailMessage.getTo().isEmpty()) {
                helper.setTo(crmMailMessage.getTo().toArray(new String[0]));
            }
            if (crmMailMessage.getCarbonCopy() != null && !crmMailMessage.getCarbonCopy().isEmpty()) {
                helper.setCc(crmMailMessage.getCarbonCopy().toArray(new String[0]));
            }
            if (crmMailMessage.getBlindCarbonCopy() != null && !crmMailMessage.getBlindCarbonCopy().isEmpty()) {
                helper.setBcc(crmMailMessage.getBlindCarbonCopy().toArray(new String[0]));
            }
            helper.setSubject(crmMailMessage.getSubject());
            // 设置邮件内容，第二个参数设置是否支持 text/html 类型
            helper.setText(crmMailMessage.getContent(), true);
            javaMailSender.send(mimeMessage);
            log.info("邮件发送成功，主题：{}", crmMailMessage.getSubject());
        } catch (BusinessException e) {
            e.printStackTrace();
            log.error("邮件发送失败：{}", e);
            throw new BusinessException("邮件发送失败：" + e.getMsg());
        } catch (MessagingException e) {
            e.printStackTrace();
            log.error("邮件发送失败：{}", e);
            throw new BusinessException("邮件发送失败");
        }
    }


}
