package com.biz.crm.message.config;

import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.profile.DefaultProfile;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * @author jianglong
 * @version V1.0
 * @Package com.biz.crm.message.config
 * @Description: TODO
 * @date 2021/3/24 下午2:16
 */
@Configuration
@Slf4j
public class MessageClient {
    @Autowired
    private ShortMessageConf conf;
    //初始化ascClient
    @Bean("iAcsClient")
    public IAcsClient createIAcsClient(){
        String regionId = "default";
        DefaultProfile profile = DefaultProfile.getProfile(regionId, conf.getAccessKeyID(), conf.getAccessKeySecret());
        IAcsClient client = new DefaultAcsClient(profile);
        return client;
    }
}
