package com.biz.crm.util;

import com.alibaba.fastjson.JSONObject;
import com.aliyuncs.CommonRequest;
import com.aliyuncs.CommonResponse;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.exceptions.ServerException;
import com.aliyuncs.http.MethodType;
import com.biz.crm.base.BusinessException;
import com.biz.crm.message.ShortMessage;
import com.biz.crm.message.config.ShortMessageConf;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author jianglong
 * @version V1.0
 * @Package com.biz.crm.util
 * @Description: TODO
 * @date 2021/3/24 下午2:08
 */
@Component
@Slf4j
public class ShortMessageUtil {
    @Autowired
    private IAcsClient iAcsClient;
    @Autowired
    private ShortMessageConf conf;

    public boolean sendMessage(ShortMessage shortMessage){
        CommonRequest request = new CommonRequest();
        request.setMethod(MethodType.POST);
        request.setDomain("dysmsapi.aliyuncs.com");
        request.setVersion("2017-05-25");
        request.setAction("SendSms");
        if(StringUtils.isNotEmpty(shortMessage.getRegionId())){
            request.putQueryParameter("RegionId", shortMessage.getRegionId());
        }
        request.putQueryParameter("PhoneNumbers", shortMessage.getPhoneNumbers());
        request.putQueryParameter("TemplateCode", shortMessage.getTemplateCode());
        if (StringUtils.isNotEmpty(shortMessage.getTemplateParam())){
            request.putQueryParameter("TemplateParam", shortMessage.getTemplateParam());
        }
        if (StringUtils.isNotEmpty(shortMessage.getSmsUpExtendCode())){
            request.putQueryParameter("SmsUpExtendCode", shortMessage.getSmsUpExtendCode());
        }
        if (StringUtils.isNotEmpty(shortMessage.getOutId())){
            request.putQueryParameter("OutId", shortMessage.getOutId());
        }
        request.putQueryParameter("SignName", conf.getSignName());
        try {
            CommonResponse response = iAcsClient.getCommonResponse(request);
            log.info(response.getData());
            JSONObject object = JSONObject.parseObject(response.getData());
            if(object.get("Message").toString().equals("OK")){
                return true;
            }
            return false;
        } catch (ServerException e) {
            log.error("短信:",e);
            throw new BusinessException("短信发送失败");
        } catch (ClientException e) {
            log.error("短信:",e);
            throw new BusinessException("短信发送失败");
        } catch (Exception e){
            log.error("短信:",e);
            throw new BusinessException("短信发送失败");
        }
    }
}
