/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.gaode.service.impl;

import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.resttemplate.RestTemplateUtils;
import com.biz.crm.gaode.service.GaodeAroundService;
import com.biz.crm.gaode.vo.GaoResVo;
import com.biz.crm.gaode.vo.GaodeNearbyVo;
import com.biz.crm.gaode.vo.QueryAroundVo;
import com.biz.crm.util.JsonPropertyUtil;
import com.biz.crm.util.StringUtils;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class GaodeAroundServiceImpl
implements GaodeAroundService {
    private static final Logger log = LoggerFactory.getLogger(GaodeAroundServiceImpl.class);
    @Value(value="${gaode.key:}")
    private String key;
    @Value(value="${gaode.radius:}")
    private String radius;
    @Value(value="${gaode.keywords:}")
    private String keywords;

    @Override
    public PageResult<GaodeNearbyVo> queryAround(QueryAroundVo queryAroundVo) {
        if (StringUtils.isEmpty((String)this.key) || StringUtils.isEmpty((String)this.radius) || StringUtils.isEmpty((String)this.keywords)) {
            throw new BusinessException("\u8bf7\u7ef4\u62a4\u9ad8\u5fb7\u76f8\u5173\u53c2\u6570");
        }
        if (StringUtils.isEmpty((String)queryAroundVo.getLocation())) {
            throw new BusinessException("\u8bf7\u4f20\u5165\u5f53\u524d\u4e2d\u5fc3\u70b9");
        }
        HashMap uriVariables = new HashMap();
        StringBuffer url = new StringBuffer();
        url.append("https://restapi.amap.com/v3/place/around").append("?key=").append(this.key);
        url.append("&").append("location=").append(queryAroundVo.getLocation());
        url.append("&").append("radius=").append(this.radius);
        url.append("&").append("keywords=").append(this.keywords);
        url.append("&").append("extensions=").append("all");
        url.append("&").append("offset=").append(queryAroundVo.getOffset());
        url.append("&").append("page=").append(queryAroundVo.getPage());
        log.info("\u8bf7\u6c42\u9ad8\u5fb7\u9644\u8fd1\u95e8\u5e97url==> " + url.toString());
        ResponseEntity resVoResponseEntity = RestTemplateUtils.getForEntity((String)url.toString(), String.class, uriVariables);
        String strRes = (String)resVoResponseEntity.getBody();
        log.info("\u8bf7\u6c42\u9ad8\u5fb7\u9644\u8fd1\u95e8\u5e97\u8fd4\u56de\u53c2\u6570 ==> " + strRes);
        strRes = strRes.replaceAll("\"tel\":\\[]", "\"tel\":\"\"");
        strRes = strRes.replaceAll("\"address\":\\[]", "\"address\":\"\"");
        GaoResVo gaoResVo = (GaoResVo)JsonPropertyUtil.toObject((String)strRes, GaoResVo.class);
        PageResult pageResult = new PageResult();
        pageResult.setData(gaoResVo.getPois());
        pageResult.setCount(Long.valueOf(Long.parseLong(gaoResVo.getCount())));
        return pageResult;
    }
}

