/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mail.service.impl;

import com.biz.crm.base.BusinessException;
import com.biz.crm.mail.config.MailConfig;
import com.biz.crm.mail.service.MailService;
import com.biz.crm.nebular.webservice.mail.CrmMailMessage;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnMissingBean(name={"MailServiceExpandImpl"})
public class MailServiceImpl
implements MailService {
    private static final Logger log = LoggerFactory.getLogger(MailServiceImpl.class);
    @Autowired
    private MailConfig mailConfig;
    @Autowired(required=false)
    private JavaMailSender javaMailSender;

    @Override
    public void sendMail(CrmMailMessage crmMailMessage) {
        try {
            log.info("\u5f00\u59cb\u6821\u9a8c\u53d1\u4ef6\u53c2\u6570");
            if (this.javaMailSender == null) {
                throw new BusinessException("\u90ae\u7bb1\u914d\u7f6e\u4e0d\u6b63\u786e");
            }
            if (crmMailMessage == null) {
                throw new BusinessException("\u7a7a\u53c2\u6570");
            }
            if (StringUtils.isEmpty((CharSequence)crmMailMessage.getSubject())) {
                throw new BusinessException("\u90ae\u4ef6\u7f3a\u5931\u4e3b\u9898");
            }
            if (StringUtils.isEmpty((CharSequence)crmMailMessage.getContent())) {
                throw new BusinessException("\u90ae\u4ef6\u7f3a\u5931\u6b63\u6587");
            }
            log.info("\u5f00\u59cb\u53d1\u9001\u90ae\u4ef6\uff0c\u4e3b\u9898\uff1a{}", (Object)crmMailMessage.getSubject());
            if (!(crmMailMessage.getTo() != null && !crmMailMessage.getTo().isEmpty() || crmMailMessage.getCarbonCopy() != null && !crmMailMessage.getCarbonCopy().isEmpty() || crmMailMessage.getBlindCarbonCopy() != null && !crmMailMessage.getBlindCarbonCopy().isEmpty())) {
                throw new BusinessException("\u90ae\u4ef6\u7f3a\u5931\u6536\u4ef6\u4eba");
            }
            MimeMessage mimeMessage = this.javaMailSender.createMimeMessage();
            MimeMessageHelper helper = new MimeMessageHelper(mimeMessage, true);
            String fromName = StringUtils.isNotEmpty((CharSequence)this.mailConfig.getNickname()) ? this.mailConfig.getNickname() + "<" + this.mailConfig.getUsername() + ">" : this.mailConfig.getUsername();
            helper.setFrom(fromName);
            if (crmMailMessage.getTo() != null && !crmMailMessage.getTo().isEmpty()) {
                helper.setTo(crmMailMessage.getTo().toArray(new String[0]));
            }
            if (crmMailMessage.getCarbonCopy() != null && !crmMailMessage.getCarbonCopy().isEmpty()) {
                helper.setCc(crmMailMessage.getCarbonCopy().toArray(new String[0]));
            }
            if (crmMailMessage.getBlindCarbonCopy() != null && !crmMailMessage.getBlindCarbonCopy().isEmpty()) {
                helper.setBcc(crmMailMessage.getBlindCarbonCopy().toArray(new String[0]));
            }
            helper.setSubject(crmMailMessage.getSubject());
            helper.setText(crmMailMessage.getContent(), true);
            this.javaMailSender.send(mimeMessage);
            log.info("\u90ae\u4ef6\u53d1\u9001\u6210\u529f\uff0c\u4e3b\u9898\uff1a{}", (Object)crmMailMessage.getSubject());
        }
        catch (BusinessException e) {
            e.printStackTrace();
            log.error("\u90ae\u4ef6\u53d1\u9001\u5931\u8d25\uff1a{}", (Throwable)e);
            throw new BusinessException("\u90ae\u4ef6\u53d1\u9001\u5931\u8d25\uff1a" + e.getMsg());
        }
        catch (MessagingException e) {
            e.printStackTrace();
            log.error("\u90ae\u4ef6\u53d1\u9001\u5931\u8d25\uff1a{}", (Throwable)e);
            throw new BusinessException("\u90ae\u4ef6\u53d1\u9001\u5931\u8d25");
        }
    }
}

