/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.util;

import com.alibaba.fastjson.JSONObject;
import com.aliyuncs.CommonRequest;
import com.aliyuncs.CommonResponse;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.exceptions.ServerException;
import com.aliyuncs.http.MethodType;
import com.biz.crm.base.BusinessException;
import com.biz.crm.message.ShortMessage;
import com.biz.crm.message.config.ShortMessageConf;
import com.biz.crm.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ShortMessageUtil {
    private static final Logger log = LoggerFactory.getLogger(ShortMessageUtil.class);
    @Autowired
    private IAcsClient iAcsClient;
    @Autowired
    private ShortMessageConf conf;

    public boolean sendMessage(ShortMessage shortMessage) {
        CommonRequest request = new CommonRequest();
        request.setMethod(MethodType.POST);
        request.setDomain("dysmsapi.aliyuncs.com");
        request.setVersion("2017-05-25");
        request.setAction("SendSms");
        if (StringUtils.isNotEmpty((String)shortMessage.getRegionId())) {
            request.putQueryParameter("RegionId", shortMessage.getRegionId());
        }
        request.putQueryParameter("PhoneNumbers", shortMessage.getPhoneNumbers());
        request.putQueryParameter("TemplateCode", shortMessage.getTemplateCode());
        if (StringUtils.isNotEmpty((String)shortMessage.getTemplateParam())) {
            request.putQueryParameter("TemplateParam", shortMessage.getTemplateParam());
        }
        if (StringUtils.isNotEmpty((String)shortMessage.getSmsUpExtendCode())) {
            request.putQueryParameter("SmsUpExtendCode", shortMessage.getSmsUpExtendCode());
        }
        if (StringUtils.isNotEmpty((String)shortMessage.getOutId())) {
            request.putQueryParameter("OutId", shortMessage.getOutId());
        }
        request.putQueryParameter("SignName", this.conf.getSignName());
        try {
            CommonResponse response = this.iAcsClient.getCommonResponse(request);
            log.info(response.getData());
            JSONObject object = JSONObject.parseObject((String)response.getData());
            return object.get((Object)"Message").toString().equals("OK");
        }
        catch (ServerException e) {
            log.error("\u77ed\u4fe1:", (Throwable)e);
            throw new BusinessException("\u77ed\u4fe1\u53d1\u9001\u5931\u8d25");
        }
        catch (ClientException e) {
            log.error("\u77ed\u4fe1:", (Throwable)e);
            throw new BusinessException("\u77ed\u4fe1\u53d1\u9001\u5931\u8d25");
        }
        catch (Exception e) {
            log.error("\u77ed\u4fe1:", (Throwable)e);
            throw new BusinessException("\u77ed\u4fe1\u53d1\u9001\u5931\u8d25");
        }
    }
}

