/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.gaode.service.impl;

import com.alibaba.fastjson.JSON;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.resttemplate.RestTemplateUtils;
import com.biz.crm.gaode.service.GaodeAroundService;
import com.biz.crm.gaode.vo.AmapPoiQueryReqVo;
import com.biz.crm.gaode.vo.AmapPoiResultVo;
import com.biz.crm.gaode.vo.GaoResVo;
import com.biz.crm.gaode.vo.GaodeNearbyVo;
import com.biz.crm.gaode.vo.QueryAroundVo;
import com.biz.crm.util.JsonPropertyUtil;
import com.biz.crm.util.StringUtils;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class GaodeAroundServiceImpl
implements GaodeAroundService {
    private static final Logger log = LoggerFactory.getLogger(GaodeAroundServiceImpl.class);
    @Value(value="${gaode.key:}")
    private String key;
    @Value(value="${gaode.radius:}")
    private String radius;
    @Value(value="${gaode.keywords:}")
    private String keywords;

    @Override
    public PageResult<GaodeNearbyVo> queryAround(QueryAroundVo queryAroundVo) {
        if (StringUtils.isNotEmpty((String)queryAroundVo.getRadius())) {
            this.radius = queryAroundVo.getRadius();
        }
        if (StringUtils.isNotEmpty((String)queryAroundVo.getKeywords())) {
            this.keywords = queryAroundVo.getKeywords();
        }
        if (StringUtils.isEmpty((String)this.key) || StringUtils.isEmpty((String)this.radius) || StringUtils.isEmpty((String)this.keywords)) {
            throw new BusinessException("\u8bf7\u7ef4\u62a4\u9ad8\u5fb7\u76f8\u5173\u53c2\u6570");
        }
        HashMap uriVariables = new HashMap();
        StringBuffer url = new StringBuffer();
        url.append("https://restapi.amap.com/v3/place/around").append("?key=").append(this.key);
        url.append("&").append("location=").append(queryAroundVo.getLocation());
        url.append("&").append("radius=").append(this.radius);
        url.append("&").append("keywords=").append(this.keywords);
        url.append("&").append("extensions=").append("all");
        url.append("&").append("offset=").append(queryAroundVo.getOffset());
        url.append("&").append("page=").append(queryAroundVo.getPage());
        log.info("\u8bf7\u6c42\u9ad8\u5fb7\u9644\u8fd1\u95e8\u5e97url==> " + url.toString());
        ResponseEntity resVoResponseEntity = RestTemplateUtils.getForEntity((String)url.toString(), String.class, uriVariables);
        String strRes = (String)resVoResponseEntity.getBody();
        log.info("\u8bf7\u6c42\u9ad8\u5fb7\u9644\u8fd1\u95e8\u5e97\u8fd4\u56de\u53c2\u6570 ==> " + strRes);
        strRes = strRes.replaceAll("\"tel\":\\[]", "\"tel\":\"\"");
        strRes = strRes.replaceAll("\"address\":\\[]", "\"address\":\"\"");
        GaoResVo gaoResVo = (GaoResVo)JsonPropertyUtil.toObject((String)strRes, GaoResVo.class);
        PageResult pageResult = new PageResult();
        pageResult.setData(gaoResVo.getPois());
        pageResult.setCount(Long.valueOf(Long.parseLong(gaoResVo.getCount())));
        return pageResult;
    }

    @Override
    public AmapPoiResultVo queryKeywords(AmapPoiQueryReqVo reqVo) {
        HashMap uriVariables = new HashMap();
        StringBuffer url = new StringBuffer();
        url.append("https://restapi.amap.com/v3/place/text").append("?key=").append(this.key);
        url.append("&").append("citylimit=").append(reqVo.getCitylimit());
        url.append("&").append("city=").append(reqVo.getCity());
        url.append("&").append("types=").append(reqVo.getTypes());
        url.append("&").append("extensions=").append("all");
        url.append("&").append("keywords=").append(reqVo.getKeywords());
        url.append("&").append("offset=").append(reqVo.getOffset());
        url.append("&").append("page=").append(reqVo.getPage());
        ResponseEntity resVoResponseEntity = RestTemplateUtils.getForEntity((String)url.toString(), String.class, uriVariables);
        String strRes = (String)resVoResponseEntity.getBody();
        strRes = strRes.replace("\"parent\":[]", "\"parent\":\"\"");
        strRes = strRes.replace("\"type\":[]", "\"type\":\"\"");
        strRes = strRes.replace("\"typecode\":[]", "\"typecode\":\"\"");
        strRes = strRes.replace("\"pcode\":[]", "\"pcode\":\"\"");
        strRes = strRes.replace("\"pname\":[]", "\"pname\":\"\"");
        strRes = strRes.replace("\"citycode\":[]", "\"citycode\":\"\"");
        strRes = strRes.replace("\"cityname\":[]", "\"cityname\":\"\"");
        strRes = strRes.replace("\"adcode\":[]", "\"adcode\":\"\"");
        strRes = strRes.replace("\"adname\":[]", "\"adname\":\"\"");
        strRes = strRes.replace("\"tel\":[]", "\"tel\":\"\"");
        strRes = strRes.replace("\"address\":[]", "\"address\":\"\"");
        strRes = strRes.replace("\"biz_type\":[]", "\"biz_type\":\"\"");
        strRes = strRes.replace("\"location\":[]", "\"location\":\"\"");
        strRes = strRes.replace("\"distance\":[]", "\"distance\":\"\"");
        strRes = strRes.replace("\"postcode\":[]", "\"postcode\":\"\"");
        strRes = strRes.replace("\"website\":[]", "\"website\":\"\"");
        strRes = strRes.replace("\"email\":[]", "\"email\":\"\"");
        strRes = strRes.replace("\"entr_location\":[]", "\"entr_location\":\"\"");
        strRes = strRes.replace("\"exit_location\":[]", "\"exit_location\":\"\"");
        strRes = strRes.replace("\"navi_poiid\":[]", "\"navi_poiid\":\"\"");
        strRes = strRes.replace("\"gridcode\":[]", "\"gridcode\":\"\"");
        strRes = strRes.replace("\"alias\":[]", "\"alias\":\"\"");
        strRes = strRes.replace("\"business_area\":[]", "\"business_area\":\"\"");
        strRes = strRes.replace("\"tag\":[]", "\"tag\":\"\"");
        return (AmapPoiResultVo)JSON.parseObject((String)strRes, AmapPoiResultVo.class);
    }
}

